/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.TextAttributes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SelectionModelWindow
implements SelectionModel {
    private final SelectionModel myHostModel;
    private final DocumentWindow myDocument;
    private final EditorWindow myInjectedEditor;

    SelectionModelWindow(EditorEx delegate2, DocumentWindow document, EditorWindow injectedEditor) {
        this.myDocument = document;
        this.myInjectedEditor = injectedEditor;
        this.myHostModel = delegate2.getSelectionModel();
    }

    @NotNull
    public Editor getEditor() {
        EditorWindow editorWindow = this.myInjectedEditor;
        if (editorWindow == null) {
            SelectionModelWindow.$$$reportNull$$$0(0);
        }
        return editorWindow;
    }

    @Nullable
    public VisualPosition getSelectionStartPosition() {
        return this.myInjectedEditor.offsetToVisualPosition(this.getSelectionStart());
    }

    @Nullable
    public VisualPosition getSelectionEndPosition() {
        return this.myInjectedEditor.offsetToVisualPosition(this.getSelectionEnd());
    }

    public boolean hasSelection(boolean anyCaret) {
        return this.myHostModel.hasSelection(anyCaret);
    }

    public void addSelectionListener(@NotNull SelectionListener listener2) {
        if (listener2 == null) {
            SelectionModelWindow.$$$reportNull$$$0(1);
        }
        this.myHostModel.addSelectionListener(listener2);
    }

    public void removeSelectionListener(@NotNull SelectionListener listener2) {
        if (listener2 == null) {
            SelectionModelWindow.$$$reportNull$$$0(2);
        }
        this.myHostModel.removeSelectionListener(listener2);
    }

    public void copySelectionToClipboard() {
        this.myHostModel.copySelectionToClipboard();
    }

    public void setBlockSelection(@NotNull LogicalPosition blockStart, @NotNull LogicalPosition blockEnd) {
        if (blockStart == null) {
            SelectionModelWindow.$$$reportNull$$$0(3);
        }
        if (blockEnd == null) {
            SelectionModelWindow.$$$reportNull$$$0(4);
        }
        this.myHostModel.setBlockSelection(this.myInjectedEditor.injectedToHost(blockStart), this.myInjectedEditor.injectedToHost(blockEnd));
    }

    public int @NotNull [] getBlockSelectionStarts() {
        int[] result2 = this.myHostModel.getBlockSelectionStarts();
        for (int i2 = 0; i2 < result2.length; ++i2) {
            result2[i2] = this.myDocument.hostToInjected(result2[i2]);
        }
        if (result2 == null) {
            SelectionModelWindow.$$$reportNull$$$0(5);
        }
        return result2;
    }

    public int @NotNull [] getBlockSelectionEnds() {
        int[] result2 = this.myHostModel.getBlockSelectionEnds();
        for (int i2 = 0; i2 < result2.length; ++i2) {
            result2[i2] = this.myDocument.hostToInjected(result2[i2]);
        }
        if (result2 == null) {
            SelectionModelWindow.$$$reportNull$$$0(6);
        }
        return result2;
    }

    public TextAttributes getTextAttributes() {
        return this.myHostModel.getTextAttributes();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/injected/SelectionModelWindow";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockStart";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockEnd";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/injected/SelectionModelWindow";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBlockSelectionStarts";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getBlockSelectionEnds";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addSelectionListener";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeSelectionListener";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setBlockSelection";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string2);
        };
    }
}

