/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.ide.util.treeView.WeighedItem;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ColoredItem;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.SearchScopeProvider;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.ui.FileColorManager;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DefaultSearchScopeProviders {
    private DefaultSearchScopeProviders() {
    }

    @NotNull
    public static GlobalSearchScope wrapNamedScope(@NotNull Project project2, @NotNull NamedScope namedScope, boolean colored) {
        if (project2 == null) {
            DefaultSearchScopeProviders.$$$reportNull$$$0(0);
        }
        if (namedScope == null) {
            DefaultSearchScopeProviders.$$$reportNull$$$0(1);
        }
        GlobalSearchScope scope = GlobalSearchScopesCore.filterScope(project2, namedScope);
        if (!colored && !(namedScope instanceof WeighedItem)) {
            GlobalSearchScope globalSearchScope = scope;
            if (globalSearchScope == null) {
                DefaultSearchScopeProviders.$$$reportNull$$$0(2);
            }
            return globalSearchScope;
        }
        int weight = namedScope instanceof WeighedItem ? ((WeighedItem)namedScope).getWeight() : -1;
        Color color = !colored ? null : FileColorManager.getInstance(project2).getScopeColor(namedScope.getScopeId());
        return new MyWeightedScope(scope, weight, color);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedScope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/DefaultSearchScopeProviders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/DefaultSearchScopeProviders";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapNamedScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "wrapNamedScope";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2 -> new IllegalStateException(string2);
        };
    }

    private static class MyWeightedScope
    extends DelegatingGlobalSearchScope
    implements WeighedItem,
    ColoredItem {
        final int weight;
        final Color color;

        MyWeightedScope(@NotNull GlobalSearchScope scope, int weight, Color color) {
            if (scope == null) {
                MyWeightedScope.$$$reportNull$$$0(0);
            }
            super(scope);
            this.weight = weight;
            this.color = color;
        }

        public int getWeight() {
            return this.weight;
        }

        @Override
        @Nullable
        public Color getColor() {
            return this.color;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/DefaultSearchScopeProviders$MyWeightedScope", "<init>"));
        }
    }

    public static class CustomNamed
    implements SearchScopeProvider {
        @Override
        public String getDisplayName() {
            return LangBundle.message("default.search.scope.custom.named.display.name", new Object[0]);
        }

        @Override
        @NotNull
        public List<SearchScope> getSearchScopes(@NotNull Project project2, @NotNull DataContext dataContext2) {
            NamedScopesHolder[] holders;
            if (project2 == null) {
                CustomNamed.$$$reportNull$$$0(0);
            }
            if (dataContext2 == null) {
                CustomNamed.$$$reportNull$$$0(1);
            }
            ArrayList<SearchScope> result2 = new ArrayList<SearchScope>();
            for (NamedScopesHolder holder : holders = NamedScopesHolder.getAllNamedScopeHolders(project2)) {
                NamedScope[] scopes;
                for (NamedScope scope : scopes = holder.getEditableScopes()) {
                    result2.add(DefaultSearchScopeProviders.wrapNamedScope(project2, scope, true));
                }
            }
            ArrayList<SearchScope> arrayList = result2;
            if (arrayList == null) {
                CustomNamed.$$$reportNull$$$0(2);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/search/DefaultSearchScopeProviders$CustomNamed";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/search/DefaultSearchScopeProviders$CustomNamed";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSearchScopes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getSearchScopes";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2 -> new IllegalStateException(string2);
            };
        }
    }
}

