/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.FileTypeNameEnumerator;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileIndexingState;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.IndexingStamp;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.impl.AbstractUpdateData;
import com.intellij.util.indexing.impl.InputData;
import com.intellij.util.indexing.impl.InputDataDiffBuilder;
import com.intellij.util.indexing.impl.ValueContainerImpl;
import com.intellij.util.io.MeasurableIndexStore;
import com.intellij.util.io.SimpleStringPersistentEnumerator;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.IntConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileTypeIndexImplBase
implements UpdatableIndex<FileType, Void, FileContent, Void>,
FileTypeNameEnumerator,
MeasurableIndexStore {
    private static final Logger LOG = Logger.getInstance(FileTypeIndexImplBase.class);
    @NotNull
    protected final FileBasedIndexExtension<FileType, Void> myExtension;
    @NotNull
    protected final ID<FileType, Void> myIndexId;
    @NotNull
    protected final ReadWriteLock myLock;
    @NotNull
    protected final SimpleStringPersistentEnumerator myFileTypeEnumerator;
    @NotNull
    private final ConcurrentIntObjectMap<Ref<FileType>> myId2FileTypeCache;
    @NotNull
    protected final AtomicBoolean myInMemoryMode;
    @NotNull
    protected final FileTypeIndex.IndexChangeListener myIndexChangedPublisher;

    public FileTypeIndexImplBase(@NotNull FileBasedIndexExtension<FileType, Void> extension2) throws IOException {
        if (extension2 == null) {
            FileTypeIndexImplBase.$$$reportNull$$$0(0);
        }
        this.myLock = new ReentrantReadWriteLock();
        this.myId2FileTypeCache = ConcurrentCollectionFactory.createConcurrentIntObjectMap();
        this.myInMemoryMode = new AtomicBoolean();
        this.myExtension = extension2;
        if (this.myExtension.dependsOnFileContent()) {
            throw new IllegalArgumentException(this.myExtension.getName() + " should not depend on content");
        }
        this.myIndexId = extension2.getName();
        this.myFileTypeEnumerator = new SimpleStringPersistentEnumerator(this.getStorageFile().resolveSibling("fileType.enum"));
        this.myIndexChangedPublisher = (FileTypeIndex.IndexChangeListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(FileTypeIndex.INDEX_CHANGE_TOPIC);
    }

    protected abstract int getIndexedFileTypeId(int var1) throws StorageException;

    protected abstract void processFileIdsForFileTypeId(int var1, @NotNull IntConsumer var2);

    @NotNull
    protected Path getStorageFile() throws IOException {
        Path path2 = IndexInfrastructure.getStorageFile(this.myIndexId);
        if (path2 == null) {
            FileTypeIndexImplBase.$$$reportNull$$$0(1);
        }
        return path2;
    }

    @Nullable
    protected FileType getFileTypeById(int id) {
        Ref<FileType> fileType = (Ref<FileType>)this.myId2FileTypeCache.get(id);
        if (fileType == null) {
            String fileTypeName = this.myFileTypeEnumerator.valueOf(id);
            FileType fileTypeByName = fileTypeName == null ? null : FileTypeManager.getInstance().findFileTypeByName(fileTypeName);
            fileType = Ref.create(fileTypeByName);
            this.myId2FileTypeCache.put(id, fileType);
        }
        return (FileType)fileType.get();
    }

    @Override
    public String getFileTypeName(int id) {
        FileType fileType = this.getFileTypeById(id);
        return fileType == null ? null : fileType.getName();
    }

    @Override
    public int getFileTypeId(String name) throws IOException {
        return this.myFileTypeEnumerator.enumerate(name);
    }

    protected int getFileTypeId(@Nullable FileType fileType) throws StorageException {
        if (fileType == null) {
            return 0;
        }
        try {
            return this.getFileTypeId(fileType.getName());
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    public boolean processAllKeys(@NotNull Processor<? super FileType> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter) throws StorageException {
        if (processor == null) {
            FileTypeIndexImplBase.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            FileTypeIndexImplBase.$$$reportNull$$$0(3);
        }
        for (String fileTypeName : this.myFileTypeEnumerator.entries()) {
            FileType fileType = FileTypeManager.getInstance().findFileTypeByName(fileTypeName);
            if (fileType == null || processor.process(fileType)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ReadWriteLock getLock() {
        ReadWriteLock readWriteLock = this.myLock;
        if (readWriteLock == null) {
            FileTypeIndexImplBase.$$$reportNull$$$0(4);
        }
        return readWriteLock;
    }

    @NotNull
    public Map<FileType, Void> getIndexedFileData(int fileId) throws StorageException {
        int foundData = this.getIndexedFileTypeId(fileId);
        if (foundData == 0) {
            Map<FileType, Void> map2 = Collections.emptyMap();
            if (map2 == null) {
                FileTypeIndexImplBase.$$$reportNull$$$0(5);
            }
            return map2;
        }
        Map<FileType, Object> map3 = Collections.singletonMap(this.getFileTypeById(foundData), null);
        if (map3 == null) {
            FileTypeIndexImplBase.$$$reportNull$$$0(6);
        }
        return map3;
    }

    public Void getFileIndexMetaData(@NotNull IndexedFile file2) {
        if (file2 == null) {
            FileTypeIndexImplBase.$$$reportNull$$$0(7);
        }
        return null;
    }

    public void setIndexedStateForFileOnFileIndexMetaData(int fileId, @Nullable Void data2) {
        IndexingStamp.setFileIndexedStateCurrent(fileId, this.myIndexId);
    }

    public void setIndexedStateForFile(int fileId, @NotNull IndexedFile file2) {
        if (file2 == null) {
            FileTypeIndexImplBase.$$$reportNull$$$0(8);
        }
        IndexingStamp.setFileIndexedStateCurrent(fileId, this.myIndexId);
    }

    public void invalidateIndexedStateForFile(int fileId) {
        IndexingStamp.setFileIndexedStateOutdated(fileId, this.myIndexId);
    }

    public void setUnindexedStateForFile(int fileId) {
        IndexingStamp.setFileIndexedStateUnindexed(fileId, this.myIndexId);
    }

    @NotNull
    public FileIndexingState getIndexingStateForFile(int fileId, @NotNull IndexedFile file2) {
        int indexedFileTypeId;
        block9: {
            FileIndexingState fileIndexingState;
            FileIndexingState isIndexed;
            if (file2 == null) {
                FileTypeIndexImplBase.$$$reportNull$$$0(9);
            }
            if ((isIndexed = IndexingStamp.isFileIndexedStateCurrent(fileId, this.myIndexId)) != FileIndexingState.UP_TO_DATE) {
                FileIndexingState fileIndexingState2 = isIndexed;
                if (fileIndexingState2 == null) {
                    FileTypeIndexImplBase.$$$reportNull$$$0(10);
                }
                return fileIndexingState2;
            }
            try {
                indexedFileTypeId = this.getIndexedFileTypeId(fileId);
                if (indexedFileTypeId != 0) break block9;
                fileIndexingState = FileIndexingState.NOT_INDEXED;
            }
            catch (StorageException e) {
                LOG.error(e);
                FileIndexingState fileIndexingState3 = FileIndexingState.OUT_DATED;
                if (fileIndexingState3 == null) {
                    FileTypeIndexImplBase.$$$reportNull$$$0(13);
                }
                return fileIndexingState3;
            }
            if (fileIndexingState == null) {
                FileTypeIndexImplBase.$$$reportNull$$$0(11);
            }
            return fileIndexingState;
        }
        int actualFileTypeId = this.getFileTypeId(file2.getFileType());
        FileIndexingState fileIndexingState = indexedFileTypeId == actualFileTypeId ? FileIndexingState.UP_TO_DATE : FileIndexingState.OUT_DATED;
        if (fileIndexingState == null) {
            FileTypeIndexImplBase.$$$reportNull$$$0(12);
        }
        return fileIndexingState;
    }

    @NotNull
    public IndexExtension<FileType, Void, FileContent> getExtension() {
        FileBasedIndexExtension<FileType, Void> fileBasedIndexExtension = this.myExtension;
        if (fileBasedIndexExtension == null) {
            FileTypeIndexImplBase.$$$reportNull$$$0(14);
        }
        return fileBasedIndexExtension;
    }

    @Override
    public int keysCountApproximately() {
        return this.myFileTypeEnumerator.getSize();
    }

    public void removeTransientDataForFile(int inputId) {
    }

    public void removeTransientDataForKeys(int inputId, @NotNull InputDataDiffBuilder<FileType, Void> diffBuilder) {
        if (diffBuilder == null) {
            FileTypeIndexImplBase.$$$reportNull$$$0(15);
        }
        throw new UnsupportedOperationException();
    }

    public void updateWithMap(@NotNull AbstractUpdateData<FileType, Void> updateData) {
        if (updateData == null) {
            FileTypeIndexImplBase.$$$reportNull$$$0(16);
        }
        throw new UnsupportedOperationException();
    }

    public void setBufferingEnabled(boolean enabled) {
        this.myInMemoryMode.set(enabled);
    }

    public void cleanupMemoryStorage() {
    }

    public void cleanupForNextTest() {
    }

    @NotNull
    public Computable<Boolean> prepareUpdate(int inputId, @NotNull InputData<FileType, Void> data2) {
        if (data2 == null) {
            FileTypeIndexImplBase.$$$reportNull$$$0(17);
        }
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ValueContainer<Void> getData(@NotNull FileType type) throws StorageException {
        if (type == null) {
            FileTypeIndexImplBase.$$$reportNull$$$0(18);
        }
        int fileTypeId = this.getFileTypeId(type);
        ValueContainerImpl<Void> result2 = new ValueContainerImpl<Void>(false);
        this.myLock.readLock().lock();
        try {
            this.processFileIdsForFileTypeId(fileTypeId, id -> result2.addValue(id, null));
        }
        finally {
            this.myLock.readLock().unlock();
        }
        ValueContainerImpl<Void> valueContainerImpl = result2;
        if (valueContainerImpl == null) {
            FileTypeIndexImplBase.$$$reportNull$$$0(19);
        }
        return valueContainerImpl;
    }

    protected void notifyInvertedIndexChangedForFileTypeId(int id) {
        if (id == 0) {
            return;
        }
        FileType fileType = this.getFileTypeById(id);
        if (fileType != null) {
            this.myIndexChangedPublisher.onChangedForFileType(fileType);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 5, 6, 10, 11, 12, 13, 14, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/FileTypeIndexImplBase";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diffBuilder";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updateData";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/FileTypeIndexImplBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStorageFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLock";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexedFileData";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexingStateForFile";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtension";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 19: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processAllKeys";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFileIndexMetaData";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setIndexedStateForFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getIndexingStateForFile";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "removeTransientDataForKeys";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "updateWithMap";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "prepareUpdate";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 4, 5, 6, 10, 11, 12, 13, 14, 19 -> new IllegalStateException(string2);
        };
    }
}

