/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.FileTypeNameEnumerator;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.SubstitutedFileType;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class FileTypeKeyDescriptor
implements KeyDescriptor<FileType> {
    private final NotNullLazyValue<FileTypeNameEnumerator> myFileTypeNameEnumerator = NotNullLazyValue.lazy(() -> (FileTypeNameEnumerator)((FileBasedIndexImpl)FileBasedIndex.getInstance()).getIndex(FileTypeIndex.NAME));

    FileTypeKeyDescriptor() {
    }

    @Override
    public int getHashCode(FileType value) {
        return value.getName().hashCode();
    }

    @Override
    public boolean isEqual(FileType val1, FileType val2) {
        if (val1 instanceof SubstitutedFileType) {
            val1 = ((SubstitutedFileType)val1).getFileType();
        }
        if (val2 instanceof SubstitutedFileType) {
            val2 = ((SubstitutedFileType)val2).getFileType();
        }
        if (val1 instanceof OutDatedFileType || val2 instanceof OutDatedFileType) {
            return Objects.equals(val1.getName(), val2.getName());
        }
        return Comparing.equal(val1, val2);
    }

    @Override
    public void save(@NotNull DataOutput out, FileType value) throws IOException {
        if (out == null) {
            FileTypeKeyDescriptor.$$$reportNull$$$0(0);
        }
        DataInputOutputUtil.writeINT(out, this.getFileTypeId(value.getName()));
    }

    @Override
    public FileType read(@NotNull DataInput in) throws IOException {
        String read;
        if (in == null) {
            FileTypeKeyDescriptor.$$$reportNull$$$0(1);
        }
        if ((read = this.getFileTypeName(DataInputOutputUtil.readINT(in))) == null) {
            return UnknownFileType.INSTANCE;
        }
        FileType fileType = FileTypeRegistry.getInstance().findFileTypeByName(read);
        return fileType == null ? new OutDatedFileType(read) : fileType;
    }

    int getFileTypeId(@NotNull String fileTypeName) throws IOException {
        if (fileTypeName == null) {
            FileTypeKeyDescriptor.$$$reportNull$$$0(2);
        }
        return this.myFileTypeNameEnumerator.getValue().getFileTypeId(fileTypeName);
    }

    @Nullable
    String getFileTypeName(int fileTypeId) throws IOException {
        return this.myFileTypeNameEnumerator.getValue().getFileTypeName(fileTypeId);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypeName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/search/FileTypeKeyDescriptor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "save";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "read";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getFileTypeId";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class OutDatedFileType
    implements FileType {
        @NotNull
        private final String myName;

        private OutDatedFileType(@NotNull String name) {
            if (name == null) {
                OutDatedFileType.$$$reportNull$$$0(0);
            }
            this.myName = name;
        }

        @Override
        @NotNull
        public String getName() {
            String string2 = this.myName;
            if (string2 == null) {
                OutDatedFileType.$$$reportNull$$$0(1);
            }
            return string2;
        }

        @Override
        @NotNull
        public String getDescription() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public String getDefaultExtension() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Icon getIcon() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isBinary() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isReadOnly() {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nullable
        public String getCharset(@NotNull VirtualFile file2, byte @NotNull [] content2) {
            if (file2 == null) {
                OutDatedFileType.$$$reportNull$$$0(2);
            }
            if (content2 == null) {
                OutDatedFileType.$$$reportNull$$$0(3);
            }
            throw new UnsupportedOperationException();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/search/FileTypeKeyDescriptor$OutDatedFileType";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/search/FileTypeKeyDescriptor$OutDatedFileType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getCharset";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1 -> new IllegalStateException(string2);
            };
        }
    }
}

