/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.FileTypeIndexImpl;
import com.intellij.psi.search.FileTypeNameEnumerator;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileIndexingState;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.impl.MapInputDataDiffBuilder;
import com.intellij.util.indexing.impl.storage.TransientFileContentIndex;
import com.intellij.util.indexing.impl.storage.VfsAwareMapReduceIndex;
import com.intellij.util.indexing.storage.VfsAwareIndexStorageLayout;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.PersistentStringEnumerator;
import com.intellij.util.io.StorageLockContext;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FileTypeMapReduceIndex
extends TransientFileContentIndex<FileType, Void, VfsAwareMapReduceIndex.IndexerIdHolder>
implements FileTypeNameEnumerator {
    private static final Logger LOG = Logger.getInstance(FileTypeIndexImpl.class);
    private PersistentStringEnumerator myFileTypeNameEnumerator;

    FileTypeMapReduceIndex(@NotNull FileBasedIndexExtension<FileType, Void> extension2, @NotNull VfsAwareIndexStorageLayout<FileType, Void> layout) throws IOException {
        if (extension2 == null) {
            FileTypeMapReduceIndex.$$$reportNull$$$0(0);
        }
        if (layout == null) {
            FileTypeMapReduceIndex.$$$reportNull$$$0(1);
        }
        super(extension2, layout);
        this.myFileTypeNameEnumerator = FileTypeMapReduceIndex.createFileTypeNameEnumerator();
    }

    @Override
    @NotNull
    public FileIndexingState getIndexingStateForFile(int fileId, @NotNull IndexedFile file2) {
        FileIndexingState fileIndexingState;
        FileIndexingState isIndexed;
        if (file2 == null) {
            FileTypeMapReduceIndex.$$$reportNull$$$0(2);
        }
        if ((isIndexed = super.getIndexingStateForFile(fileId, file2)) != FileIndexingState.UP_TO_DATE) {
            FileIndexingState fileIndexingState2 = isIndexed;
            if (fileIndexingState2 == null) {
                FileTypeMapReduceIndex.$$$reportNull$$$0(3);
            }
            return fileIndexingState2;
        }
        try {
            Collection inputData = ((MapInputDataDiffBuilder)this.getKeysDiffBuilder(fileId)).getKeys();
            FileType indexedFileType = (FileType)ContainerUtil.getFirstItem(inputData);
            fileIndexingState = this.getExtension().getKeyDescriptor().isEqual(indexedFileType, file2.getFileType()) ? FileIndexingState.UP_TO_DATE : FileIndexingState.OUT_DATED;
        }
        catch (IOException e) {
            LOG.error(e);
            FileIndexingState fileIndexingState3 = FileIndexingState.OUT_DATED;
            if (fileIndexingState3 == null) {
                FileTypeMapReduceIndex.$$$reportNull$$$0(5);
            }
            return fileIndexingState3;
        }
        if (fileIndexingState == null) {
            FileTypeMapReduceIndex.$$$reportNull$$$0(4);
        }
        return fileIndexingState;
    }

    @Override
    protected void doFlush() throws IOException, StorageException {
        super.doFlush();
        this.myFileTypeNameEnumerator.force();
    }

    @Override
    protected void doDispose() throws StorageException {
        try {
            super.doDispose();
        }
        catch (Throwable throwable) {
            IOUtil.closeSafe(LOG, this.myFileTypeNameEnumerator);
            throw throwable;
        }
        IOUtil.closeSafe(LOG, this.myFileTypeNameEnumerator);
    }

    @Override
    protected void doClear() throws StorageException, IOException {
        super.doClear();
        IOUtil.closeSafe(LOG, this.myFileTypeNameEnumerator);
        IOUtil.deleteAllFilesStartingWith(FileTypeMapReduceIndex.getFileTypeNameEnumeratorPath());
        this.myFileTypeNameEnumerator = FileTypeMapReduceIndex.createFileTypeNameEnumerator();
    }

    @Override
    public int getFileTypeId(String name) throws IOException {
        return this.myFileTypeNameEnumerator.enumerate(name);
    }

    @Override
    @Nullable
    public String getFileTypeName(int id) throws IOException {
        return this.myFileTypeNameEnumerator.valueOf(id);
    }

    @NotNull
    private static PersistentStringEnumerator createFileTypeNameEnumerator() throws IOException {
        return new PersistentStringEnumerator(FileTypeMapReduceIndex.getFileTypeNameEnumeratorPath(), 128, true, new StorageLockContext());
    }

    @NotNull
    private static Path getFileTypeNameEnumeratorPath() throws IOException {
        Path path2 = IndexInfrastructure.getIndexRootDir((ID)FileTypeIndex.NAME).resolve("file.type.names");
        if (path2 == null) {
            FileTypeMapReduceIndex.$$$reportNull$$$0(6);
        }
        return path2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layout";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/FileTypeMapReduceIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/FileTypeMapReduceIndex";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexingStateForFile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypeNameEnumeratorPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getIndexingStateForFile";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3, 4, 5, 6 -> new IllegalStateException(string2);
        };
    }
}

