/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.find.impl.FindInProjectUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.search.IndexPatternOptimizer;
import com.intellij.util.PlatformUtils;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class IndexPatternOptimizerImpl
implements IndexPatternOptimizer {
    @NotNull
    public List<String> extractStringsToFind(@NotNull String regexp) {
        Project[] openProjects;
        if (regexp == null) {
            IndexPatternOptimizerImpl.$$$reportNull$$$0(0);
        }
        if ("\\btodo\\b.*".equals(regexp)) {
            List<String> list2 = Collections.singletonList("todo");
            if (list2 == null) {
                IndexPatternOptimizerImpl.$$$reportNull$$$0(1);
            }
            return list2;
        }
        if ("\\bfixme\\b.*".equals(regexp)) {
            List<String> list3 = Collections.singletonList("fixme");
            if (list3 == null) {
                IndexPatternOptimizerImpl.$$$reportNull$$$0(2);
            }
            return list3;
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && PlatformUtils.isDataGrip()) {
            List<String> list4 = Collections.emptyList();
            if (list4 == null) {
                IndexPatternOptimizerImpl.$$$reportNull$$$0(3);
            }
            return list4;
        }
        Project project2 = null;
        ProjectManager projectManager = ProjectManager.getInstanceIfCreated();
        if (projectManager != null && (openProjects = projectManager.getOpenProjects()).length == 1) {
            project2 = openProjects[0];
        }
        if (project2 == null) {
            project2 = ProjectManager.getInstance().getDefaultProject();
        }
        String stringToFind = FindInProjectUtil.extractStringToFind(regexp, project2);
        List<String> list5 = StringUtil.getWordsIn(stringToFind);
        if (list5 == null) {
            IndexPatternOptimizerImpl.$$$reportNull$$$0(4);
        }
        return list5;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "regexp";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/IndexPatternOptimizerImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/IndexPatternOptimizerImpl";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "extractStringsToFind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "extractStringsToFind";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 2, 3, 4 -> new IllegalStateException(string2);
        };
    }
}

