/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.search.FileTypeIndexImplBase;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.impl.storage.AbstractIntLog;
import com.intellij.util.indexing.impl.storage.IntLog;
import com.intellij.util.io.StorageLockContext;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.IOException;
import java.nio.file.Path;
import java.util.BitSet;
import java.util.function.IntConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LogFileTypeIndex
extends FileTypeIndexImplBase {
    private static final Logger LOG = Logger.getInstance(LogFileTypeIndex.class);
    @NotNull
    private final LogBasedIntIntIndex myPersistentLog;
    @NotNull
    private final MemorySnapshot mySnapshot;

    public LogFileTypeIndex(@NotNull FileBasedIndexExtension<FileType, Void> extension2) throws IOException, StorageException {
        if (extension2 == null) {
            LogFileTypeIndex.$$$reportNull$$$0(0);
        }
        super(extension2);
        Path storageFile = this.getStorageFile();
        this.myPersistentLog = new LogBasedIntIntIndex(new IntLog(storageFile.resolveSibling(storageFile.getFileName().toString() + ".log.index"), true, new StorageLockContext(false, true)));
        this.mySnapshot = LogFileTypeIndex.loadIndexToMemory(this.myPersistentLog, id -> this.notifyInvertedIndexChangedForFileTypeId(id));
    }

    public long getModificationStamp() {
        return this.myPersistentLog.getModificationStamp();
    }

    @NotNull
    public Computable<Boolean> mapInputAndPrepareUpdate(int inputId, @Nullable FileContent content2) {
        Computable<Boolean> computable;
        try {
            int fileTypeId = this.getFileTypeId(content2 == null ? null : content2.getFileType());
            computable = () -> this.updateIndex(fileTypeId, inputId);
        }
        catch (StorageException e) {
            throw new RuntimeException(e);
        }
        if (computable == null) {
            LogFileTypeIndex.$$$reportNull$$$0(1);
        }
        return computable;
    }

    @Override
    protected int getIndexedFileTypeId(int fileId) {
        this.myLock.readLock().lock();
        try {
            int n = this.mySnapshot.getIndexedData(fileId);
            return n;
        }
        finally {
            this.myLock.readLock().unlock();
        }
    }

    @Override
    protected void processFileIdsForFileTypeId(int fileTypeId, @NotNull IntConsumer consumer2) {
        if (consumer2 == null) {
            LogFileTypeIndex.$$$reportNull$$$0(2);
        }
        this.mySnapshot.getFileIds(fileTypeId).forEach(consumer2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Boolean updateIndex(int fileTypeId, int inputId) {
        this.myLock.writeLock().lock();
        try {
            if (this.myInMemoryMode.get()) {
                throw new IllegalStateException("file type index should not be updated for unsaved changes");
            }
            boolean snapshotModified = this.mySnapshot.addData(fileTypeId, inputId);
            if (snapshotModified) {
                this.myPersistentLog.addData(fileTypeId, inputId);
            }
        }
        catch (StorageException e) {
            LOG.error(e);
            Boolean bl = Boolean.FALSE;
            Boolean bl2 = bl;
            if (bl2 == null) {
                LogFileTypeIndex.$$$reportNull$$$0(3);
            }
            return bl2;
        }
        finally {
            this.myLock.writeLock().unlock();
        }
        Boolean bl = Boolean.TRUE;
        if (bl == null) {
            LogFileTypeIndex.$$$reportNull$$$0(4);
        }
        return bl;
    }

    public void flush() throws StorageException {
        try {
            this.myPersistentLog.flush();
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    public void clear() throws StorageException {
        this.mySnapshot.clear();
        this.myPersistentLog.clear();
    }

    public void dispose() {
        try {
            this.myPersistentLog.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    private static MemorySnapshot loadIndexToMemory(@NotNull LogBasedIntIntIndex intLogIndex, @NotNull IntConsumer invertedIndexChangeCallback) throws StorageException {
        if (intLogIndex == null) {
            LogFileTypeIndex.$$$reportNull$$$0(5);
        }
        if (invertedIndexChangeCallback == null) {
            LogFileTypeIndex.$$$reportNull$$$0(6);
        }
        Int2ObjectOpenHashMap<BitSet> invertedIndex = new Int2ObjectOpenHashMap<BitSet>();
        IntArrayList forwardIndex = new IntArrayList();
        intLogIndex.processEntries((data2, inputId) -> {
            if (data2 != 0) {
                LogFileTypeIndex.setForwardIndexData(forwardIndex, data2, inputId);
                invertedIndex.computeIfAbsent(data2, __ -> new BitSet()).set(inputId);
            } else {
                int previousData = MemorySnapshot.getDataFromForwardIndex(forwardIndex, inputId);
                if (previousData != 0) {
                    forwardIndex.set(inputId, 0);
                    ((BitSet)invertedIndex.get(previousData)).clear(inputId);
                }
            }
            return true;
        });
        return new MemorySnapshot(invertedIndex, forwardIndex, invertedIndexChangeCallback);
    }

    private static boolean setForwardIndexData(@NotNull IntList forwardIndex, int data2, int inputId) {
        if (forwardIndex == null) {
            LogFileTypeIndex.$$$reportNull$$$0(7);
        }
        if (inputId >= forwardIndex.size()) {
            forwardIndex.size((inputId + 1) * 3 / 2);
        }
        return data2 != forwardIndex.set(inputId, data2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/LogFileTypeIndex";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "intLogIndex";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invertedIndexChangeCallback";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forwardIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/LogFileTypeIndex";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "mapInputAndPrepareUpdate";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "updateIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processFileIdsForFileTypeId";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadIndexToMemory";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setForwardIndexData";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 3, 4 -> new IllegalStateException(string2);
        };
    }

    private static class LogBasedIntIntIndex
    implements IntIntIndex {
        private final AbstractIntLog myLog;

        private LogBasedIntIntIndex(@NotNull AbstractIntLog log) {
            if (log == null) {
                LogBasedIntIntIndex.$$$reportNull$$$0(0);
            }
            this.myLog = log;
        }

        @Override
        public boolean addData(int data2, int inputId) throws StorageException {
            this.myLog.addData(data2, inputId);
            return true;
        }

        private void processEntries(@NotNull AbstractIntLog.IntLogEntryProcessor processor) throws StorageException {
            if (processor == null) {
                LogBasedIntIntIndex.$$$reportNull$$$0(1);
            }
            this.myLog.processEntries(processor);
        }

        public long getModificationStamp() {
            return this.myLog.getModificationStamp();
        }

        public void clear() {
            this.myLog.clear();
        }

        public void close() throws IOException {
            this.myLog.close();
        }

        public void flush() throws IOException {
            this.myLog.flush();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "log";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/search/LogFileTypeIndex$LogBasedIntIntIndex";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processEntries";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MemorySnapshot
    implements IntIntIndex {
        @NotNull
        private final Int2ObjectMap<BitSet> myInvertedIndex;
        @NotNull
        private final IntList myForwardIndex;
        @NotNull
        private final IntConsumer myInvertedIndexChangeCallback;

        private MemorySnapshot(@NotNull Int2ObjectMap<BitSet> invertedIndex, @NotNull IntList forwardIndex, @NotNull IntConsumer invertedIndexChangeCallback) {
            if (invertedIndex == null) {
                MemorySnapshot.$$$reportNull$$$0(0);
            }
            if (forwardIndex == null) {
                MemorySnapshot.$$$reportNull$$$0(1);
            }
            if (invertedIndexChangeCallback == null) {
                MemorySnapshot.$$$reportNull$$$0(2);
            }
            this.myInvertedIndex = invertedIndex;
            this.myForwardIndex = forwardIndex;
            this.myInvertedIndexChangeCallback = invertedIndexChangeCallback;
        }

        @Override
        public synchronized boolean addData(int data2, int inputId) {
            int indexedData = this.getIndexedData(inputId);
            if (indexedData != 0) {
                BitSet indexedSet = (BitSet)this.myInvertedIndex.get(indexedData);
                assert (indexedSet != null);
                indexedSet.clear(inputId);
            }
            boolean updated = LogFileTypeIndex.setForwardIndexData(this.myForwardIndex, data2, inputId);
            if (data2 != 0) {
                this.myInvertedIndex.computeIfAbsent(data2, __ -> new BitSet()).set(inputId);
            }
            this.triggerOnInvertedIndexChangeCallback(data2, indexedData);
            return updated;
        }

        private void triggerOnInvertedIndexChangeCallback(int newData, int oldData) {
            if (oldData != newData) {
                if (oldData != 0) {
                    this.myInvertedIndexChangeCallback.accept(oldData);
                }
                if (newData != 0) {
                    this.myInvertedIndexChangeCallback.accept(newData);
                }
            }
        }

        @NotNull
        public synchronized IntSeq getFileIds(int data2) {
            BitSet fileIds = (BitSet)this.myInvertedIndex.get(data2);
            return fileIds == null ? IntSeq.EMPTY : new IntSeq.FromBitSet(fileIds);
        }

        public synchronized int getIndexedData(int inputId) {
            return MemorySnapshot.getDataFromForwardIndex(this.myForwardIndex, inputId);
        }

        private static int getDataFromForwardIndex(@NotNull IntList forwardIndex, int inputId) {
            if (forwardIndex == null) {
                MemorySnapshot.$$$reportNull$$$0(3);
            }
            if (forwardIndex.size() <= inputId) {
                return 0;
            }
            return forwardIndex.getInt(inputId);
        }

        private void clear() {
            this.myInvertedIndex.clear();
            this.myForwardIndex.clear();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "invertedIndex";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "forwardIndex";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "invertedIndexChangeCallback";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/search/LogFileTypeIndex$MemorySnapshot";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getDataFromForwardIndex";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static interface IntSeq {
        public static final IntSeq EMPTY = new IntSeq(){

            @Override
            public void forEach(@NotNull IntConsumer consumer2) {
                if (consumer2 == null) {
                    1.$$$reportNull$$$0(0);
                }
            }

            @Override
            @NotNull
            public IntSeq copy() {
                1 v0 = this;
                if (v0 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return v0;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "consumer";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/search/LogFileTypeIndex$IntSeq$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/search/LogFileTypeIndex$IntSeq$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "copy";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "forEach";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string2);
                    case 1 -> new IllegalStateException(string2);
                };
            }
        };

        public void forEach(@NotNull IntConsumer var1);

        @NotNull
        public IntSeq copy();

        public static class FromBitSet
        implements IntSeq {
            private final BitSet myBitSet;

            private FromBitSet(@NotNull BitSet set2) {
                if (set2 == null) {
                    FromBitSet.$$$reportNull$$$0(0);
                }
                this.myBitSet = set2;
            }

            @Override
            public void forEach(@NotNull IntConsumer consumer2) {
                if (consumer2 == null) {
                    FromBitSet.$$$reportNull$$$0(1);
                }
                this.myBitSet.stream().forEach(consumer2);
            }

            @Override
            @NotNull
            public IntSeq copy() {
                return new FromBitSet((BitSet)this.myBitSet.clone());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "set";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "consumer";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/psi/search/LogFileTypeIndex$IntSeq$FromBitSet";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "forEach";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private static interface IntIntIndex {
        public boolean addData(int var1, int var2) throws StorageException;
    }
}

