/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.search.FileTypeIndexImplBase;
import com.intellij.util.SystemProperties;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.containers.BitSetAsRAIntContainer;
import com.intellij.util.indexing.containers.IntHashSetAsRAIntContainer;
import com.intellij.util.indexing.containers.IntIdsIterator;
import com.intellij.util.indexing.containers.RandomAccessIntContainer;
import com.intellij.util.indexing.containers.UpgradableRandomAccessIntContainer;
import com.intellij.util.indexing.impl.ValueContainerImpl;
import com.intellij.util.io.UnInterruptibleFileChannel;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.function.IntConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MappedFileTypeIndex
extends FileTypeIndexImplBase {
    private static final Logger LOG = Logger.getInstance(MappedFileTypeIndex.class);
    private static final int INVERTED_INDEX_SIZE_THRESHOLD = SystemProperties.getIntProperty("mapped.file.type.index.inverse.upgrade.threshold", 256);
    @NotNull
    private final IndexDataController myDataController;

    public MappedFileTypeIndex(@NotNull FileBasedIndexExtension<FileType, Void> extension2) throws IOException, StorageException {
        if (extension2 == null) {
            MappedFileTypeIndex.$$$reportNull$$$0(0);
        }
        super(extension2);
        Path storageFile = this.getStorageFile();
        this.myDataController = MappedFileTypeIndex.loadIndexToMemory(storageFile.resolveSibling(storageFile.getFileName().toString() + ".index"), id -> this.notifyInvertedIndexChangedForFileTypeId(id));
    }

    private static short checkFileTypeIdIsShort(int fileTypeId) {
        assert (fileTypeId < Short.MAX_VALUE) : "file type id = " + fileTypeId;
        return (short)fileTypeId;
    }

    public long getModificationStamp() {
        return this.myDataController.getModificationStamp();
    }

    @Override
    protected void processFileIdsForFileTypeId(int fileTypeId, @NotNull IntConsumer consumer2) {
        if (consumer2 == null) {
            MappedFileTypeIndex.$$$reportNull$$$0(1);
        }
        IntIdsIterator it = this.myDataController.getFileIds(MappedFileTypeIndex.checkFileTypeIdIsShort(fileTypeId));
        while (it.hasNext()) {
            consumer2.accept(it.next());
        }
    }

    @NotNull
    public Computable<Boolean> mapInputAndPrepareUpdate(int inputId, @Nullable FileContent content2) {
        Computable<Boolean> computable;
        try {
            int fileTypeId = this.getFileTypeId(content2 == null ? null : content2.getFileType());
            computable = () -> this.updateIndex(inputId, MappedFileTypeIndex.checkFileTypeIdIsShort(fileTypeId));
        }
        catch (StorageException e) {
            throw new RuntimeException(e);
        }
        if (computable == null) {
            MappedFileTypeIndex.$$$reportNull$$$0(2);
        }
        return computable;
    }

    @Override
    protected int getIndexedFileTypeId(int fileId) throws StorageException {
        this.myLock.readLock().lock();
        try {
            short s = this.myDataController.getIndexedData(fileId);
            return s;
        }
        finally {
            this.myLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Boolean updateIndex(int inputId, short fileTypeId) {
        this.myLock.writeLock().lock();
        try {
            if (this.myInMemoryMode.get()) {
                throw new IllegalStateException("file type index should not be updated for unsaved changes");
            }
            this.myDataController.setAssociation(inputId, fileTypeId);
        }
        catch (StorageException e) {
            LOG.error(e);
            Boolean bl = Boolean.FALSE;
            Boolean bl2 = bl;
            if (bl2 == null) {
                MappedFileTypeIndex.$$$reportNull$$$0(3);
            }
            return bl2;
        }
        finally {
            this.myLock.writeLock().unlock();
        }
        Boolean bl = Boolean.TRUE;
        if (bl == null) {
            MappedFileTypeIndex.$$$reportNull$$$0(4);
        }
        return bl;
    }

    public void flush() throws StorageException {
        this.myDataController.flush();
    }

    public void clear() throws StorageException {
        this.myDataController.clear();
    }

    public void dispose() {
        try {
            this.myDataController.close();
        }
        catch (StorageException e) {
            throw new RuntimeException(e);
        }
    }

    private static RandomAccessIntContainer createContainerForInvertedIndex() {
        return new UpgradableRandomAccessIntContainer<IntHashSetAsRAIntContainer, BitSetAsRAIntContainer>(INVERTED_INDEX_SIZE_THRESHOLD, () -> new IntHashSetAsRAIntContainer(INVERTED_INDEX_SIZE_THRESHOLD, 0.75f), container -> {
            int maxId = 0;
            IntIdsIterator it = container.intIterator();
            while (it.hasNext()) {
                int id = it.next();
                if (maxId >= id) continue;
                maxId = id;
            }
            return new BitSetAsRAIntContainer(maxId + 1);
        });
    }

    @NotNull
    private static IndexDataController loadIndexToMemory(@NotNull Path forwardIndexStorageFile, @NotNull IntConsumer invertedIndexChangeCallback) throws StorageException {
        if (forwardIndexStorageFile == null) {
            MappedFileTypeIndex.$$$reportNull$$$0(5);
        }
        if (invertedIndexChangeCallback == null) {
            MappedFileTypeIndex.$$$reportNull$$$0(6);
        }
        IndexDataController.ForwardIndexFileController forwardIndex = new IndexDataController.ForwardIndexFileController(forwardIndexStorageFile);
        Int2ObjectOpenHashMap<RandomAccessIntContainer> invertedIndex = new Int2ObjectOpenHashMap<RandomAccessIntContainer>();
        forwardIndex.processEntries((inputId, data2) -> {
            if (data2 != 0) {
                invertedIndex.computeIfAbsent((int)data2, __ -> MappedFileTypeIndex.createContainerForInvertedIndex()).add(inputId);
            }
        });
        return new IndexDataController(invertedIndex, forwardIndex, invertedIndexChangeCallback);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/MappedFileTypeIndex";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forwardIndexStorageFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invertedIndexChangeCallback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/MappedFileTypeIndex";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "mapInputAndPrepareUpdate";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "updateIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processFileIdsForFileTypeId";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadIndexToMemory";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 3, 4 -> new IllegalStateException(string2);
        };
    }

    private static class IndexDataController {
        @NotNull
        private final Int2ObjectMap<RandomAccessIntContainer> myInvertedIndex;
        @NotNull
        private final ForwardIndexFileController myForwardIndex;
        @NotNull
        private final IntConsumer myInvertedIndexChangeCallback;

        private IndexDataController(@NotNull Int2ObjectMap<RandomAccessIntContainer> invertedIndex, @NotNull ForwardIndexFileController forwardIndex, @NotNull IntConsumer invertedIndexChangeCallback) {
            if (invertedIndex == null) {
                IndexDataController.$$$reportNull$$$0(0);
            }
            if (forwardIndex == null) {
                IndexDataController.$$$reportNull$$$0(1);
            }
            if (invertedIndexChangeCallback == null) {
                IndexDataController.$$$reportNull$$$0(2);
            }
            this.myInvertedIndex = invertedIndex;
            this.myForwardIndex = forwardIndex;
            this.myInvertedIndexChangeCallback = invertedIndexChangeCallback;
        }

        public synchronized void setAssociation(int inputId, short data2) throws StorageException {
            short indexedData = this.getIndexedData(inputId);
            if (indexedData != 0) {
                RandomAccessIntContainer indexedSet = (RandomAccessIntContainer)this.myInvertedIndex.get(indexedData);
                assert (indexedSet != null);
                indexedSet.remove(inputId);
            }
            this.myForwardIndex.set(inputId, data2);
            if (data2 != 0) {
                this.myInvertedIndex.computeIfAbsent((int)data2, __ -> MappedFileTypeIndex.createContainerForInvertedIndex()).add(inputId);
            }
            this.triggerOnInvertedIndexChangeCallback(data2, indexedData);
        }

        private void triggerOnInvertedIndexChangeCallback(short newData, short oldData) {
            if (oldData != newData) {
                if (oldData != 0) {
                    this.myInvertedIndexChangeCallback.accept(oldData);
                }
                if (newData != 0) {
                    this.myInvertedIndexChangeCallback.accept(newData);
                }
            }
        }

        @NotNull
        public synchronized IntIdsIterator getFileIds(int data2) {
            RandomAccessIntContainer fileIds = (RandomAccessIntContainer)this.myInvertedIndex.get(data2);
            IntIdsIterator intIdsIterator = fileIds == null ? ValueContainerImpl.EMPTY_ITERATOR : fileIds.intIterator();
            if (intIdsIterator == null) {
                IndexDataController.$$$reportNull$$$0(3);
            }
            return intIdsIterator;
        }

        public synchronized short getIndexedData(int inputId) throws StorageException {
            return this.myForwardIndex.get(inputId);
        }

        public long getModificationStamp() {
            return this.myForwardIndex.myModificationsCounter;
        }

        public void clear() throws StorageException {
            this.myInvertedIndex.clear();
            this.myForwardIndex.clear();
        }

        public void flush() throws StorageException {
            this.myForwardIndex.flush();
        }

        public void close() throws StorageException {
            this.myForwardIndex.close();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "invertedIndex";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "forwardIndex";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "invertedIndexChangeCallback";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/search/MappedFileTypeIndex$IndexDataController";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/search/MappedFileTypeIndex$IndexDataController";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileIds";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 3 -> new IllegalStateException(string2);
            };
        }

        private static class ForwardIndexFileController {
            private static final int ELEMENT_BYTES = 2;
            private static final int DEFAULT_FILE_ALLOCATION_BYTES = 512;
            private static final int DEFAULT_FULL_SCAN_BUFFER_BYTES = 1024;
            @NotNull
            private final FileChannel myFileChannel;
            private volatile long myElementsCount;
            private volatile long myModificationsCounter;
            @NotNull
            private final ByteBuffer myDataBuffer;

            private ForwardIndexFileController(@NotNull Path storage) throws StorageException {
                if (storage == null) {
                    ForwardIndexFileController.$$$reportNull$$$0(0);
                }
                this.myModificationsCounter = 0L;
                this.myDataBuffer = ByteBuffer.allocate(2);
                try {
                    this.myFileChannel = new UnInterruptibleFileChannel(storage, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
                    long fileSize = this.myFileChannel.size();
                    if (fileSize % 2L != 0L) {
                        LOG.error("file type index is corrupted");
                        this.clear();
                        fileSize = 0L;
                    }
                    this.myElementsCount = fileSize / 2L;
                }
                catch (IOException e) {
                    throw this.closeWithException(new StorageException(e));
                }
            }

            private static long offsetInFile(long inputId) {
                return inputId * 2L;
            }

            public short get(int inputId) throws StorageException {
                try {
                    int result2;
                    this.myDataBuffer.clear();
                    for (int bytesLeft = 2; bytesLeft > 0; bytesLeft -= result2) {
                        result2 = this.myFileChannel.read(this.myDataBuffer, ForwardIndexFileController.offsetInFile(inputId) + (long)this.myDataBuffer.position());
                        if (result2 == -1 && bytesLeft == 2) {
                            return 0;
                        }
                        if (result2 != -1) continue;
                        throw new StorageException("forward file type index is corrupted");
                    }
                    this.myDataBuffer.flip();
                    return this.myDataBuffer.getShort();
                }
                catch (IOException e) {
                    throw this.closeWithException(new StorageException(e));
                }
            }

            public void set(int inputId, short value) throws StorageException {
                try {
                    this.ensureCapacity(inputId);
                    this.myDataBuffer.clear();
                    this.myDataBuffer.putShort(value);
                    this.myDataBuffer.flip();
                    for (int bytesWritten = 0; bytesWritten < 2; bytesWritten += this.myFileChannel.write(this.myDataBuffer, ForwardIndexFileController.offsetInFile(inputId) + (long)bytesWritten)) {
                    }
                }
                catch (IOException e) {
                    throw this.closeWithException(new StorageException(e));
                }
                ++this.myModificationsCounter;
            }

            private void ensureCapacity(int inputIdToStore) throws StorageException {
                int elementsToStore = inputIdToStore + 1;
                if (this.myElementsCount >= (long)elementsToStore) {
                    return;
                }
                try {
                    int zeroBufSize = 512;
                    ByteBuffer zeroBuf = ByteBuffer.allocate(512);
                    while (this.myElementsCount < (long)elementsToStore) {
                        this.myFileChannel.write(zeroBuf, ForwardIndexFileController.offsetInFile(this.myElementsCount) + (long)zeroBuf.position());
                        if (zeroBuf.hasRemaining()) continue;
                        zeroBuf.position(0);
                        this.myElementsCount += 256L;
                    }
                }
                catch (IOException e) {
                    throw this.closeWithException(new StorageException(e));
                }
            }

            public void processEntries(@NotNull EntriesProcessor processor) throws StorageException {
                if (processor == null) {
                    ForwardIndexFileController.$$$reportNull$$$0(1);
                }
                try {
                    boolean isReadAction = ApplicationManager.getApplication().isReadAccessAllowed();
                    int bufferSize = 1024;
                    ByteBuffer buffer = ByteBuffer.allocate(1024);
                    int i2 = 0;
                    while ((long)i2 < this.myElementsCount) {
                        int cur;
                        if (isReadAction) {
                            ProgressManager.checkCanceled();
                        }
                        buffer.clear();
                        while (buffer.position() < 1024 && (cur = this.myFileChannel.read(buffer, ForwardIndexFileController.offsetInFile(i2) + (long)buffer.position())) != -1) {
                        }
                        buffer.flip();
                        if (buffer.limit() % 2 != 0) {
                            throw new StorageException("forward index is corrupted");
                        }
                        while (buffer.position() < buffer.limit()) {
                            processor.process(i2, buffer.getShort());
                            ++i2;
                        }
                    }
                }
                catch (IOException e) {
                    throw this.closeWithException(new StorageException(e));
                }
            }

            public void clear() throws StorageException {
                try {
                    this.myFileChannel.truncate(0L);
                    this.myElementsCount = 0L;
                    ++this.myModificationsCounter;
                }
                catch (IOException e) {
                    throw this.closeWithException(new StorageException(e));
                }
            }

            public void flush() throws StorageException {
                try {
                    this.myFileChannel.force(true);
                }
                catch (IOException e) {
                    throw this.closeWithException(new StorageException(e));
                }
            }

            public void close() throws StorageException {
                try {
                    this.myFileChannel.close();
                }
                catch (IOException e) {
                    throw new StorageException(e);
                }
            }

            private StorageException closeWithException(StorageException e) {
                try {
                    this.myFileChannel.close();
                }
                catch (IOException ioe) {
                    e.addSuppressed(ioe);
                }
                return e;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "storage";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "processor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/psi/search/MappedFileTypeIndex$IndexDataController$ForwardIndexFileController";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processEntries";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }

            @FunctionalInterface
            public static interface EntriesProcessor {
                public void process(int var1, short var2) throws StorageException;
            }
        }
    }
}

