/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.scope;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.scope.RangeBasedLocalSearchScope;
import java.util.ArrayList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class EditorSelectionLocalSearchScope
extends RangeBasedLocalSearchScope {
    private final Editor myEditor;
    private final Project myProject;
    private PsiElement[] myPsiElements;
    private VirtualFile[] myVirtualFiles;
    private TextRange[] myRanges;

    private void initVirtualFilesAndRanges() {
        if (this.myRanges != null) {
            return;
        }
        SelectionModel selectionModel = this.myEditor.getSelectionModel();
        if (!selectionModel.hasSelection()) {
            this.myVirtualFiles = VirtualFile.EMPTY_ARRAY;
            this.myRanges = TextRange.EMPTY_ARRAY;
            return;
        }
        this.myVirtualFiles = new VirtualFile[]{FileDocumentManager.getInstance().getFile(this.myEditor.getDocument())};
        int[] selectionStarts = selectionModel.getBlockSelectionStarts();
        int[] selectionEnds = selectionModel.getBlockSelectionEnds();
        this.myRanges = new TextRange[selectionStarts.length];
        for (int i2 = 0; i2 < selectionStarts.length; ++i2) {
            this.myRanges[i2] = new TextRange(selectionStarts[i2], selectionEnds[i2]);
        }
    }

    private void init() {
        ReadAction.run(() -> {
            PsiFile psiFile = PsiDocumentManager.getInstance(this.myProject).getPsiFile(this.myEditor.getDocument());
            if (psiFile == null) {
                this.myPsiElements = PsiElement.EMPTY_ARRAY;
                return;
            }
            SelectionModel selectionModel = this.myEditor.getSelectionModel();
            if (!selectionModel.hasSelection()) {
                this.myPsiElements = PsiElement.EMPTY_ARRAY;
                return;
            }
            int[] selectionStarts = selectionModel.getBlockSelectionStarts();
            int[] selectionEnds = selectionModel.getBlockSelectionEnds();
            ArrayList<@NotNull E> elements = new ArrayList();
            for (int i2 = 0; i2 < selectionStarts.length; ++i2) {
                EditorSelectionLocalSearchScope.collectPsiElementsAtRange(psiFile, elements, selectionStarts[i2], selectionEnds[i2]);
            }
            this.myPsiElements = elements.toArray(PsiElement.EMPTY_ARRAY);
        });
    }

    @Override
    @NotNull
    protected @NotNull PsiElement @NotNull [] getPsiElements() {
        if (this.myPsiElements == null) {
            this.init();
        }
        if (this.myPsiElements == null) {
            EditorSelectionLocalSearchScope.$$$reportNull$$$0(0);
        }
        return this.myPsiElements;
    }

    @NotNull
    private @NotNull TextRange @NotNull [] getRanges() {
        this.initVirtualFilesAndRanges();
        if (this.myRanges == null) {
            EditorSelectionLocalSearchScope.$$$reportNull$$$0(1);
        }
        return this.myRanges;
    }

    public EditorSelectionLocalSearchScope(@NotNull Editor editor2, Project project2, @NotNull @Nls String displayName) {
        if (editor2 == null) {
            EditorSelectionLocalSearchScope.$$$reportNull$$$0(2);
        }
        if (displayName == null) {
            EditorSelectionLocalSearchScope.$$$reportNull$$$0(3);
        }
        this(editor2, project2, displayName, false);
    }

    public EditorSelectionLocalSearchScope(@NotNull Editor editor2, Project project2, @NotNull @Nls String displayName, boolean ignoreInjectedPsi) {
        if (editor2 == null) {
            EditorSelectionLocalSearchScope.$$$reportNull$$$0(4);
        }
        if (displayName == null) {
            EditorSelectionLocalSearchScope.$$$reportNull$$$0(5);
        }
        super(displayName, ignoreInjectedPsi);
        this.myEditor = editor2;
        this.myProject = project2;
    }

    @Override
    public VirtualFile @NotNull [] getVirtualFiles() {
        this.initVirtualFilesAndRanges();
        if (this.myVirtualFiles == null) {
            EditorSelectionLocalSearchScope.$$$reportNull$$$0(6);
        }
        return this.myVirtualFiles;
    }

    @Override
    public boolean equals(Object o) {
        TextRange[] otherRanges;
        if (this == o) {
            return true;
        }
        if (!(o instanceof EditorSelectionLocalSearchScope)) {
            return false;
        }
        EditorSelectionLocalSearchScope other = (EditorSelectionLocalSearchScope)o;
        VirtualFile[] files2 = this.getVirtualFiles();
        VirtualFile[] otherFiles = other.getVirtualFiles();
        if (!Comparing.equal(files2.length, otherFiles.length)) {
            return false;
        }
        if (files2.length > 0 && !Comparing.equal(files2[0], otherFiles[0])) {
            return false;
        }
        TextRange[] ranges2 = this.getRanges();
        if (ranges2.length != (otherRanges = other.getRanges()).length) {
            return false;
        }
        for (int i2 = 0; i2 < ranges2.length; ++i2) {
            if (Comparing.equal(ranges2[i2], otherRanges[i2])) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder builder2 = new StringBuilder();
        TextRange[] ranges2 = this.getRanges();
        VirtualFile[] files2 = this.getVirtualFiles();
        if (files2.length > 0) {
            builder2.append(files2[0].toString());
        }
        for (int i2 = 0; i2 < ranges2.length; ++i2) {
            if (i2 > 0) {
                builder2.append(',');
            }
            builder2.append('{');
            builder2.append(ranges2[i2].toString());
            builder2.append('}');
        }
        return builder2.toString();
    }

    @Override
    protected int calcHashCode() {
        int result2 = 0;
        TextRange[] ranges2 = this.getRanges();
        VirtualFile[] files2 = this.getVirtualFiles();
        if (files2.length > 0) {
            result2 += files2[0].hashCode();
        }
        for (TextRange range : ranges2) {
            result2 += range.hashCode();
        }
        return result2;
    }

    @Override
    public boolean containsRange(@NotNull PsiFile file2, @NotNull TextRange range) {
        TextRange[] ranges2;
        VirtualFile[] files2;
        VirtualFile virtualFile2;
        if (file2 == null) {
            EditorSelectionLocalSearchScope.$$$reportNull$$$0(7);
        }
        if (range == null) {
            EditorSelectionLocalSearchScope.$$$reportNull$$$0(8);
        }
        if ((virtualFile2 = file2.getVirtualFile()) == null) {
            virtualFile2 = file2.getNavigationElement().getContainingFile().getVirtualFile();
        }
        if ((files2 = this.getVirtualFiles()).length == 0) {
            return false;
        }
        if (!files2[0].equals(virtualFile2)) {
            return false;
        }
        for (TextRange textRange : ranges2 = this.getRanges()) {
            if (!textRange.contains(range)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public @NotNull TextRange @NotNull [] getRanges(@NotNull VirtualFile file2) {
        VirtualFile[] files2;
        if (file2 == null) {
            EditorSelectionLocalSearchScope.$$$reportNull$$$0(9);
        }
        if ((files2 = this.getVirtualFiles()).length == 1 && files2[0].equals(file2)) {
            return this.getRanges();
        }
        if (TextRange.EMPTY_ARRAY == null) {
            EditorSelectionLocalSearchScope.$$$reportNull$$$0(10);
        }
        return TextRange.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 7, 8, 9 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/scope/EditorSelectionLocalSearchScope";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiElements";
                break;
            }
            case 1: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRanges";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/scope/EditorSelectionLocalSearchScope";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFiles";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "containsRange";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRanges";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 2, 3, 4, 5, 7, 8, 9 -> new IllegalArgumentException(string2);
        };
    }
}

