/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.scope;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.AbstractFileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public abstract class RangeBasedLocalSearchScope
extends LocalSearchScope {
    private static final Logger LOG = Logger.getInstance(RangeBasedLocalSearchScope.class);
    protected final boolean myIgnoreInjectedPsi;
    @NotNull
    @Nls
    protected final String myDisplayName;
    private LocalSearchScope myLocalSearchScope;

    public RangeBasedLocalSearchScope(@NotNull @Nls String displayName, boolean ignoreInjectedPsi) {
        if (displayName == null) {
            RangeBasedLocalSearchScope.$$$reportNull$$$0(0);
        }
        super(PsiElement.EMPTY_ARRAY);
        this.myDisplayName = displayName;
        this.myIgnoreInjectedPsi = ignoreInjectedPsi;
    }

    @NotNull
    public abstract @NotNull TextRange @NotNull [] getRanges(@NotNull VirtualFile var1);

    protected static void collectPsiElementsAtRange(@NotNull PsiFile psiFile, @NotNull @NotNull List<? super @NotNull PsiElement> elements, int start, int end) {
        PsiElement parent2;
        if (psiFile == null) {
            RangeBasedLocalSearchScope.$$$reportNull$$$0(1);
        }
        if (elements == null) {
            RangeBasedLocalSearchScope.$$$reportNull$$$0(2);
        }
        int modifiedEnd = end;
        int length = psiFile.getTextLength();
        if (end > length) {
            LOG.error("Range extends beyond the PSI file range. Maybe PSI file is not actual");
        }
        if (end == length) {
            --modifiedEnd;
        }
        PsiElement startElement = psiFile.findElementAt(start);
        PsiElement endElement = psiFile.findElementAt(modifiedEnd);
        if (startElement == null || endElement == null) {
            return;
        }
        if (startElement.getContainingFile() != endElement.getContainingFile()) {
            startElement = AbstractFileViewProvider.findElementAt(psiFile, start);
            endElement = AbstractFileViewProvider.findElementAt(psiFile, modifiedEnd);
            if (startElement == null || endElement == null) {
                return;
            }
        }
        if ((parent2 = PsiTreeUtil.findCommonParent(startElement, endElement)) == null) {
            return;
        }
        PsiElement[] children2 = parent2.getChildren();
        TextRange range = new TextRange(start, end);
        if (children2.length == 0) {
            if (parent2.getContainingFile() != null && range.intersects(parent2.getTextRange())) {
                elements.add(parent2);
            }
        } else {
            for (PsiElement child : children2) {
                TextRange childRange = child.getTextRange();
                if (child instanceof PsiWhiteSpace || child.getContainingFile() == null || childRange == null || !range.intersects(childRange)) continue;
                elements.add(child);
            }
        }
    }

    @Override
    public boolean isIgnoreInjectedPsi() {
        return this.myIgnoreInjectedPsi;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string2 = this.myDisplayName;
        if (string2 == null) {
            RangeBasedLocalSearchScope.$$$reportNull$$$0(3);
        }
        return string2;
    }

    @NotNull
    protected abstract @NotNull PsiElement @NotNull [] getPsiElements();

    private void createIfNeeded() {
        if (this.myLocalSearchScope == null) {
            this.myLocalSearchScope = ReadAction.compute(() -> new LocalSearchScope(this.getPsiElements(), this.myDisplayName, this.myIgnoreInjectedPsi));
        }
    }

    @Override
    public PsiElement @NotNull [] getScope() {
        this.createIfNeeded();
        PsiElement[] psiElementArray = this.myLocalSearchScope.getScope();
        if (psiElementArray == null) {
            RangeBasedLocalSearchScope.$$$reportNull$$$0(4);
        }
        return psiElementArray;
    }

    @Override
    @NotNull
    public LocalSearchScope intersectWith(@NotNull LocalSearchScope scope2) {
        if (scope2 == null) {
            RangeBasedLocalSearchScope.$$$reportNull$$$0(5);
        }
        this.createIfNeeded();
        LocalSearchScope localSearchScope = this.myLocalSearchScope.intersectWith(scope2);
        if (localSearchScope == null) {
            RangeBasedLocalSearchScope.$$$reportNull$$$0(6);
        }
        return localSearchScope;
    }

    @Override
    @NotNull
    public SearchScope intersectWith(@NotNull SearchScope scope2) {
        if (scope2 == null) {
            RangeBasedLocalSearchScope.$$$reportNull$$$0(7);
        }
        this.createIfNeeded();
        SearchScope searchScope2 = this.myLocalSearchScope.intersectWith(scope2);
        if (searchScope2 == null) {
            RangeBasedLocalSearchScope.$$$reportNull$$$0(8);
        }
        return searchScope2;
    }

    @Override
    @NotNull
    public SearchScope union(@NotNull SearchScope scope) {
        if (scope == null) {
            RangeBasedLocalSearchScope.$$$reportNull$$$0(9);
        }
        this.createIfNeeded();
        SearchScope searchScope2 = this.myLocalSearchScope.union(scope);
        if (searchScope2 == null) {
            RangeBasedLocalSearchScope.$$$reportNull$$$0(10);
        }
        return searchScope2;
    }

    @Override
    public boolean contains(@NotNull VirtualFile file2) {
        if (file2 == null) {
            RangeBasedLocalSearchScope.$$$reportNull$$$0(11);
        }
        this.createIfNeeded();
        return this.myLocalSearchScope.contains(file2);
    }

    @Override
    public boolean isInScope(@NotNull VirtualFile file2) {
        if (file2 == null) {
            RangeBasedLocalSearchScope.$$$reportNull$$$0(12);
        }
        this.createIfNeeded();
        return this.myLocalSearchScope.isInScope(file2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 6, 8, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/scope/RangeBasedLocalSearchScope";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope2";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/scope/RangeBasedLocalSearchScope";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getScope";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "intersectWith";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "union";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectPsiElementsAtRange";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "intersectWith";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "union";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isInScope";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3, 4, 6, 8, 10 -> new IllegalStateException(string2);
        };
    }
}

