/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.scope.packageSet;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.scope.packageSet.PackageSetBase;
import java.io.File;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class PatternBasedPackageSet
extends PackageSetBase {
    protected final Pattern myModulePattern;
    protected final Pattern myModuleGroupPattern;
    protected final String myModulePatternText;

    public PatternBasedPackageSet(@NonNls String modulePatternText) {
        this.myModulePatternText = modulePatternText;
        Pattern moduleGroupPattern = null;
        Pattern modulePattern = null;
        if (modulePatternText != null && !modulePatternText.isEmpty()) {
            if (modulePatternText.startsWith("group:")) {
                int index2 = modulePatternText.indexOf(58, 6);
                if (index2 == -1) {
                    index2 = modulePatternText.length();
                }
                moduleGroupPattern = PatternBasedPackageSet.convertToPattern(modulePatternText.substring(6, index2));
                if (index2 < modulePatternText.length() - 1) {
                    modulePattern = PatternBasedPackageSet.convertToPattern(modulePatternText.substring(index2 + 1));
                }
            } else {
                modulePattern = PatternBasedPackageSet.convertToPattern(modulePatternText);
            }
        }
        this.myModulePattern = modulePattern;
        this.myModuleGroupPattern = moduleGroupPattern;
    }

    protected boolean matchesModule(VirtualFile file2, ProjectFileIndex fileIndex) {
        Module module2 = fileIndex.getModuleForFile(file2);
        if (module2 != null) {
            String[] groupPath;
            if (this.myModulePattern != null && this.myModulePattern.matcher(module2.getName()).matches()) {
                return true;
            }
            if (this.myModuleGroupPattern != null && (groupPath = ModuleManager.getInstance(module2.getProject()).getModuleGroupPath(module2)) != null) {
                for (String node2 : groupPath) {
                    if (!this.myModuleGroupPattern.matcher(node2).matches()) continue;
                    return true;
                }
            }
        }
        return this.myModulePattern == null && this.myModuleGroupPattern == null;
    }

    public abstract String getPattern();

    public abstract boolean isOn(String var1);

    @NotNull
    public abstract PatternBasedPackageSet updatePattern(@NotNull String var1, @NotNull String var2);

    @NotNull
    public abstract PatternBasedPackageSet updateModulePattern(@NotNull String var1, @NotNull String var2);

    public String getModulePattern() {
        return this.myModulePatternText;
    }

    @NotNull
    private static Pattern convertToPattern(String text2) {
        StringBuilder builder2 = new StringBuilder(text2.length());
        for (int i2 = 0; i2 < text2.length(); ++i2) {
            char c2 = text2.charAt(i2);
            if (c2 == ' ' || Character.isLetter(c2) || Character.isDigit(c2) || c2 == '_') {
                builder2.append(c2);
                continue;
            }
            if (c2 == '*') {
                builder2.append(".*");
                continue;
            }
            builder2.append('\\').append(c2);
        }
        Pattern pattern = Pattern.compile(builder2.toString());
        if (pattern == null) {
            PatternBasedPackageSet.$$$reportNull$$$0(0);
        }
        return pattern;
    }

    protected static boolean matchesLibrary(Pattern libPattern, VirtualFile file2, ProjectFileIndex fileIndex) {
        if (libPattern != null) {
            List<OrderEntry> entries2 = fileIndex.getOrderEntriesForFile(file2);
            for (OrderEntry orderEntry2 : entries2) {
                String jdkName;
                String presentableName;
                String fileName;
                String libraryName;
                if (!(orderEntry2 instanceof LibraryOrderEntry ? ((libraryName = ((LibraryOrderEntry)orderEntry2).getLibraryName()) != null ? libPattern.matcher(libraryName).matches() : libPattern.matcher(fileName = new File(presentableName = orderEntry2.getPresentableName()).getName()).matches()) : orderEntry2 instanceof JdkOrderEntry && (jdkName = ((JdkOrderEntry)orderEntry2).getJdkName()) != null && libPattern.matcher(jdkName).matches())) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/scope/packageSet/PatternBasedPackageSet", "convertToPattern"));
    }
}

