/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.statistics;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.KeyedExtensionCollector;
import com.intellij.psi.statistics.Statistician;
import com.intellij.psi.statistics.StatisticsInfo;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StatisticsManager {
    public static final int OBLIVION_THRESHOLD = 7;
    public static final int RECENCY_OBLIVION_THRESHOLD = 10000;
    public static final KeyedExtensionCollector<Statistician, Key> COLLECTOR = new KeyedExtensionCollector("com.intellij.statistician");

    @Nullable
    public static <T, Loc> StatisticsInfo serialize(Key<? extends Statistician<T, Loc>> key, T element, Loc location2) {
        for (Statistician statistician : COLLECTOR.forKey(key)) {
            StatisticsInfo info2 = statistician.serialize(element, location2);
            if (info2 == null) continue;
            return info2;
        }
        return null;
    }

    public static StatisticsManager getInstance() {
        return ApplicationManager.getApplication().getService(StatisticsManager.class);
    }

    public abstract int getUseCount(@NotNull StatisticsInfo var1);

    public abstract int getLastUseRecency(@NotNull StatisticsInfo var1);

    public abstract void incUseCount(@NotNull StatisticsInfo var1);

    public <T, Loc> int getUseCount(Key<? extends Statistician<T, Loc>> key, T element, Loc location2) {
        StatisticsInfo info2 = StatisticsManager.serialize(key, element, location2);
        return info2 == null ? 0 : this.getUseCount(info2);
    }

    public <T, Loc> void incUseCount(Key<? extends Statistician<T, Loc>> key, T element, Loc location2) {
        StatisticsInfo info2 = StatisticsManager.serialize(key, element, location2);
        if (info2 != null) {
            this.incUseCount(info2);
        }
    }

    public abstract StatisticsInfo[] getAllValues(@NonNls String var1);
}

