/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.stubs.BinaryFileStubBuilder;
import com.intellij.psi.stubs.BinaryFileStubBuilders;
import com.intellij.psi.stubs.SerializedStubTree;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubBuilderType;
import com.intellij.psi.stubs.StubCumulativeInputDiffBuilder;
import com.intellij.psi.stubs.StubIndexEx;
import com.intellij.psi.stubs.StubTreeBuilder;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.psi.stubs.StubUpdatingIndexStorage;
import com.intellij.psi.tree.StubFileElementType;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DocumentContent;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileBasedIndexInfrastructureExtensionUpdatableIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.IndexedFileImpl;
import com.intellij.util.indexing.StorageException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PerFileElementTypeStubModificationTracker
implements StubIndexEx.FileUpdateProcessor {
    static final Logger LOG = Logger.getInstance(PerFileElementTypeStubModificationTracker.class);
    public static final int PRECISE_CHECK_THRESHOLD = SystemProperties.getIntProperty("stub.index.per.file.element.type.modification.tracker.precise.check.threshold", 20);
    private final ConcurrentMap<String, List<StubFileElementType<?>>> myFileElementTypesCache = new ConcurrentHashMap();
    private final ConcurrentMap<StubFileElementType<?>, Long> myModCounts = new ConcurrentHashMap();
    private final ClearableLazyValue<StubUpdatingIndexStorage> myStubUpdatingIndexStorage = ClearableLazyValue.createAtomic(() -> {
        FileBasedIndexImpl fileBasedIndex = (FileBasedIndexImpl)FileBasedIndex.getInstance();
        fileBasedIndex.waitUntilIndicesAreInitialized();
        Object index2 = fileBasedIndex.getIndex(StubUpdatingIndex.INDEX_ID);
        while (index2 instanceof FileBasedIndexInfrastructureExtensionUpdatableIndex) {
            index2 = ((FileBasedIndexInfrastructureExtensionUpdatableIndex)index2).getBaseIndex();
        }
        return (StubUpdatingIndexStorage)((Object)((Object)index2));
    });
    private final Queue<VirtualFile> myPendingUpdates = new ArrayDeque<VirtualFile>();
    private final Queue<FileInfo> myProbablyExpensiveUpdates = new ArrayDeque<FileInfo>();
    private final Set<StubFileElementType<?>> myModificationsInCurrentBatch = new HashSet();

    PerFileElementTypeStubModificationTracker() {
    }

    private void registerModificationFor(@NotNull StubFileElementType<?> fileElementType) {
        if (fileElementType == null) {
            PerFileElementTypeStubModificationTracker.$$$reportNull$$$0(0);
        }
        this.myModificationsInCurrentBatch.add(fileElementType);
        this.myModCounts.compute(fileElementType, (__, value) -> {
            if (value == null) {
                return 1L;
            }
            return value + 1L;
        });
    }

    private boolean wereModificationsInCurrentBatch(@NotNull StubFileElementType<?> fileElementType) {
        if (fileElementType == null) {
            PerFileElementTypeStubModificationTracker.$$$reportNull$$$0(1);
        }
        return this.myModificationsInCurrentBatch.contains(fileElementType);
    }

    public Long getModificationStamp(@NotNull StubFileElementType<?> fileElementType) {
        if (fileElementType == null) {
            PerFileElementTypeStubModificationTracker.$$$reportNull$$$0(2);
        }
        return this.myModCounts.getOrDefault(fileElementType, 0L);
    }

    public synchronized void processUpdate(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PerFileElementTypeStubModificationTracker.$$$reportNull$$$0(3);
        }
        this.myPendingUpdates.add(file2);
    }

    public synchronized void endUpdatesBatch() {
        this.myModificationsInCurrentBatch.clear();
        ReadAction.run(() -> {
            this.fastCheck();
            if (this.myProbablyExpensiveUpdates.size() > PRECISE_CHECK_THRESHOLD) {
                this.coarseCheck();
            } else {
                this.preciseCheck();
            }
        });
    }

    private void fastCheck() {
        while (!this.myPendingUpdates.isEmpty()) {
            StubFileElementType<?> before;
            VirtualFile file2 = this.myPendingUpdates.poll();
            if (file2.isDirectory()) continue;
            if (!file2.isValid()) {
                List<StubFileElementType<?>> beforeSuitableTypes = this.determinePreviousFileElementType(FileBasedIndex.getFileId((VirtualFile)file2), this.myStubUpdatingIndexStorage.getValue());
                for (StubFileElementType<?> type : beforeSuitableTypes) {
                    this.registerModificationFor(type);
                }
                continue;
            }
            Project project2 = ((FileBasedIndexImpl)FileBasedIndex.getInstance()).findProjectForFileId(((VirtualFileWithId)((Object)file2)).getId());
            if (project2 == null || project2.isDisposed()) continue;
            IndexedFileImpl indexedFile = new IndexedFileImpl(file2, project2);
            StubFileElementType current = PerFileElementTypeStubModificationTracker.determineCurrentFileElementType(indexedFile);
            List<StubFileElementType<?>> beforeSuitableTypes = this.determinePreviousFileElementType(FileBasedIndex.getFileId((VirtualFile)file2), this.myStubUpdatingIndexStorage.getValue());
            if (beforeSuitableTypes.size() > 1) {
                for (StubFileElementType<?> type : beforeSuitableTypes) {
                    this.registerModificationFor(type);
                }
                if (current == null) continue;
                this.registerModificationFor(current);
                continue;
            }
            StubFileElementType<?> stubFileElementType = before = beforeSuitableTypes.isEmpty() ? null : beforeSuitableTypes.get(0);
            if (current != before) {
                if (current != null) {
                    this.registerModificationFor(current);
                }
                if (before == null) continue;
                this.registerModificationFor(before);
                continue;
            }
            if (current == null) continue;
            this.myProbablyExpensiveUpdates.add(new FileInfo(file2, project2, current));
        }
    }

    private void coarseCheck() {
        while (!this.myProbablyExpensiveUpdates.isEmpty()) {
            FileInfo info2 = this.myProbablyExpensiveUpdates.poll();
            if (this.wereModificationsInCurrentBatch(info2.type)) continue;
            this.registerModificationFor(info2.type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preciseCheck() {
        DataIndexer<Integer, SerializedStubTree, FileContent> stubIndexer = this.myStubUpdatingIndexStorage.getValue().getIndexer();
        while (!this.myProbablyExpensiveUpdates.isEmpty()) {
            FileInfo info2 = this.myProbablyExpensiveUpdates.poll();
            if (this.wereModificationsInCurrentBatch(info2.type) || info2.project != null && info2.project.isDisposed()) continue;
            FileBasedIndexImpl.markFileIndexed(info2.file, null);
            try {
                StubCumulativeInputDiffBuilder diffBuilder = (StubCumulativeInputDiffBuilder)this.myStubUpdatingIndexStorage.getValue().getForwardIndexAccessor().getDiffBuilder(FileBasedIndex.getFileId((VirtualFile)info2.file), null);
                FileContent fileContent = PerFileElementTypeStubModificationTracker.getTransientAwareFileContent(info2);
                if (fileContent == null) {
                    this.registerModificationFor(info2.type);
                    continue;
                }
                Stub stub = StubTreeBuilder.buildStubTree(fileContent);
                Map<Object, Object> serializedStub = stub == null ? Collections.emptyMap() : stubIndexer.map(fileContent);
                if (!diffBuilder.differentiate(serializedStub, (__, ___, ____) -> {}, (__, ___, ____) -> {}, (__, ___) -> {}, true)) continue;
                this.registerModificationFor(info2.type);
            }
            catch (StorageException | IOException e) {
                LOG.error(e);
            }
            finally {
                FileBasedIndexImpl.unmarkBeingIndexed();
            }
        }
    }

    @Nullable
    private static FileContent getTransientAwareFileContent(FileInfo info2) throws IOException {
        Document doc = FileDocumentManager.getInstance().getDocument(info2.file);
        if (doc == null || info2.project == null) {
            try {
                return FileContentImpl.createByFile(info2.file, info2.project);
            }
            catch (FileNotFoundException ignored) {
                return null;
            }
        }
        PsiFile psi = PsiDocumentManager.getInstance(info2.project).getPsiFile(doc);
        DocumentContent content2 = FileBasedIndexImpl.findLatestContent(doc, psi);
        VirtualFile file2 = info2.file;
        return FileContentImpl.createByContent(file2, () -> {
            CharSequence text2 = content2.getText();
            return text2.toString().getBytes(file2.getCharset());
        }, info2.project);
    }

    public void dispose() {
        this.myFileElementTypesCache.clear();
        this.myModCounts.clear();
        this.myPendingUpdates.clear();
        this.myProbablyExpensiveUpdates.clear();
        this.myModificationsInCurrentBatch.clear();
        this.myStubUpdatingIndexStorage.drop();
    }

    @Nullable
    private static StubFileElementType determineCurrentFileElementType(IndexedFile indexedFile) {
        if (PerFileElementTypeStubModificationTracker.shouldSkipFile(indexedFile.getFile())) {
            return null;
        }
        StubBuilderType stubBuilderType = StubTreeBuilder.getStubBuilderType(indexedFile, true);
        if (stubBuilderType == null) {
            return null;
        }
        return stubBuilderType.getStubFileElementType();
    }

    @NotNull
    private List<StubFileElementType<?>> determinePreviousFileElementType(int fileId, StubUpdatingIndexStorage index2) {
        String storedVersion = (String)index2.getStoredSubIndexerVersion(fileId);
        if (storedVersion == null) {
            List<StubFileElementType<?>> list2 = Collections.emptyList();
            if (list2 == null) {
                PerFileElementTypeStubModificationTracker.$$$reportNull$$$0(4);
            }
            return list2;
        }
        List list3 = this.myFileElementTypesCache.compute(storedVersion, (__, value) -> {
            if (value != null) {
                return value;
            }
            List<StubFileElementType<?>> types = StubBuilderType.getStubFileElementTypeFromVersion(storedVersion);
            if (types.size() > 1) {
                LOG.error("Cannot distinguish StubFileElementTypes. This might worsen the performance. Providing unique externalId or adding a distinctive debugName when instantiating StubFileElementTypes can help. Version: " + storedVersion + " -> " + ContainerUtil.map(types, t -> t.getClass().getName() + "{" + t.getExternalId() + ";" + t.getDebugName() + ";" + t.getLanguage() + "}"));
            }
            return types;
        });
        if (list3 == null) {
            PerFileElementTypeStubModificationTracker.$$$reportNull$$$0(5);
        }
        return list3;
    }

    private static boolean shouldSkipFile(VirtualFile file2) {
        if (((FileBasedIndexImpl)FileBasedIndex.getInstance()).isTooLarge(file2)) {
            return true;
        }
        FileType fileType = file2.getFileType();
        BinaryFileStubBuilder builder2 = (BinaryFileStubBuilder)BinaryFileStubBuilders.INSTANCE.forFileType(fileType);
        if (builder2 != null) {
            return true;
        }
        return !StubUpdatingIndex.canHaveStub((VirtualFile)file2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileElementType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubs/PerFileElementTypeStubModificationTracker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubs/PerFileElementTypeStubModificationTracker";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "determinePreviousFileElementType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerModificationFor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "wereModificationsInCurrentBatch";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getModificationStamp";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processUpdate";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 4, 5 -> new IllegalStateException(string2);
        };
    }

    private record FileInfo(VirtualFile file, Project project, StubFileElementType<?> type) {
    }
}

