/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.templateLanguages;

import com.intellij.lang.DependentLanguage;
import com.intellij.lang.InjectableLanguage;
import com.intellij.lang.Language;
import com.intellij.lang.LanguagePerFileMappings;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.FilePropertyPusher;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.templateLanguages.TemplateDataLanguagePatterns;
import com.intellij.psi.templateLanguages.TemplateDataLanguagePusher;
import com.intellij.psi.templateLanguages.TemplateLanguage;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="TemplateDataLanguageMappings", storages={@Storage(value="templateLanguages.xml")})
public final class TemplateDataLanguageMappings
extends LanguagePerFileMappings<Language> {
    private final FilePropertyPusher<Language> myPropertyPusher;

    public static TemplateDataLanguageMappings getInstance(Project project2) {
        return project2.getService(TemplateDataLanguageMappings.class);
    }

    public TemplateDataLanguageMappings(@NotNull Project project2) {
        if (project2 == null) {
            TemplateDataLanguageMappings.$$$reportNull$$$0(0);
        }
        super(project2);
        this.myPropertyPusher = new TemplateDataLanguagePusher();
    }

    @Override
    protected String serialize(@NotNull Language language) {
        if (language == null) {
            TemplateDataLanguageMappings.$$$reportNull$$$0(1);
        }
        return language.getID();
    }

    @Override
    @NotNull
    public List<Language> getAvailableValues() {
        return TemplateDataLanguageMappings.getTemplateableLanguages();
    }

    @Override
    @Nullable
    public Language getMapping(@Nullable VirtualFile file2) {
        Language t = (Language)this.getConfiguredMapping(file2);
        return t == null || t == Language.ANY ? this.getDefaultMapping(file2) : t;
    }

    @Override
    public Language getDefaultMapping(@Nullable VirtualFile file2) {
        return TemplateDataLanguageMappings.getDefaultMappingForFile(file2);
    }

    @Nullable
    public static Language getDefaultMappingForFile(@Nullable VirtualFile file2) {
        return file2 == null ? null : TemplateDataLanguagePatterns.getInstance().getTemplateDataLanguageByFileName(file2);
    }

    @NotNull
    public static List<Language> getTemplateableLanguages() {
        List<Language> list2 = ContainerUtil.findAll(Language.getRegisteredLanguages(), new Condition<Language>(){

            @Override
            public boolean value(Language language) {
                if (language == Language.ANY) {
                    return false;
                }
                if (language instanceof TemplateLanguage || language instanceof DependentLanguage || language instanceof InjectableLanguage) {
                    return false;
                }
                if (language.getBaseLanguage() != null) {
                    return this.value(language.getBaseLanguage());
                }
                return true;
            }
        });
        if (list2 == null) {
            TemplateDataLanguageMappings.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @Override
    @NotNull
    protected FilePropertyPusher<Language> getFilePropertyPusher() {
        FilePropertyPusher<Language> filePropertyPusher = this.myPropertyPusher;
        if (filePropertyPusher == null) {
            TemplateDataLanguageMappings.$$$reportNull$$$0(3);
        }
        return filePropertyPusher;
    }

    @Override
    @NotNull
    protected Language handleUnknownMapping(VirtualFile file2, String value) {
        Language defaultMapping = this.getDefaultMapping(file2);
        Language language = defaultMapping != null ? defaultMapping : PlainTextLanguage.INSTANCE;
        if (language == null) {
            TemplateDataLanguageMappings.$$$reportNull$$$0(4);
        }
        return language;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/templateLanguages/TemplateDataLanguageMappings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/templateLanguages/TemplateDataLanguageMappings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateableLanguages";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePropertyPusher";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "handleUnknownMapping";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 3, 4 -> new IllegalStateException(string2);
        };
    }
}

