/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.templateLanguages;

import com.intellij.FilePropertyPusherBase;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.psi.FilePropertyKey;
import com.intellij.psi.FilePropertyKeyImpl;
import com.intellij.psi.templateLanguages.TemplateDataLanguageMappings;
import com.intellij.psi.templateLanguages.TemplateLanguage;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateDataLanguagePusher
extends FilePropertyPusherBase<Language> {
    private static final FileAttribute PERSISTENCE = new FileAttribute("template_language", 4, true);
    public static final FilePropertyKey<Language> KEY = FilePropertyKeyImpl.createPersistentStringKey("TEMPLATE_DATA_LANGUAGE", PERSISTENCE, TemplateDataLanguagePusher::asString, TemplateDataLanguagePusher::fromString);

    @Override
    @NotNull
    public FilePropertyKey<Language> getFilePropertyKey() {
        FilePropertyKey<Language> filePropertyKey = KEY;
        if (filePropertyKey == null) {
            TemplateDataLanguagePusher.$$$reportNull$$$0(0);
        }
        return filePropertyKey;
    }

    @Override
    public boolean pushDirectoriesOnly() {
        return false;
    }

    @Override
    @NotNull
    public Language getDefaultValue() {
        Language language = Language.ANY;
        if (language == null) {
            TemplateDataLanguagePusher.$$$reportNull$$$0(1);
        }
        return language;
    }

    @Override
    @Nullable
    public Language getImmediateValue(@NotNull Project project2, @Nullable VirtualFile file2) {
        if (project2 == null) {
            TemplateDataLanguagePusher.$$$reportNull$$$0(2);
        }
        return (Language)TemplateDataLanguageMappings.getInstance(project2).getImmediateMapping(file2);
    }

    @Override
    @Nullable
    public Language getImmediateValue(@NotNull Module module2) {
        if (module2 == null) {
            TemplateDataLanguagePusher.$$$reportNull$$$0(3);
        }
        return null;
    }

    @Override
    public boolean acceptsFile(@NotNull VirtualFile file2, @NotNull Project project2) {
        FileType type;
        if (file2 == null) {
            TemplateDataLanguagePusher.$$$reportNull$$$0(4);
        }
        if (project2 == null) {
            TemplateDataLanguagePusher.$$$reportNull$$$0(5);
        }
        if ((type = FileTypeManager.getInstance().getFileTypeByFileName(file2.getNameSequence())) != UnknownFileType.INSTANCE) {
            return type instanceof LanguageFileType && ((LanguageFileType)type).getLanguage() instanceof TemplateLanguage;
        }
        return TemplateDataLanguageMappings.getInstance(project2).getImmediateMapping(file2) != null;
    }

    @Override
    public boolean acceptsDirectory(@NotNull VirtualFile file2, @NotNull Project project2) {
        if (file2 == null) {
            TemplateDataLanguagePusher.$$$reportNull$$$0(6);
        }
        if (project2 == null) {
            TemplateDataLanguagePusher.$$$reportNull$$$0(7);
        }
        return true;
    }

    private static String asString(@NotNull Language property) {
        if (property == null) {
            TemplateDataLanguagePusher.$$$reportNull$$$0(8);
        }
        return property.getID();
    }

    @NotNull
    private static Language fromString(@NotNull String id) {
        if (id == null) {
            TemplateDataLanguagePusher.$$$reportNull$$$0(9);
        }
        Language lang = Language.findLanguageByID(id);
        Language language = ObjectUtils.notNull(lang, Language.ANY);
        if (language == null) {
            TemplateDataLanguagePusher.$$$reportNull$$$0(10);
        }
        return language;
    }

    @Override
    public void propertyChanged(@NotNull Project project2, @NotNull VirtualFile fileOrDir, @NotNull Language actualProperty) {
        if (project2 == null) {
            TemplateDataLanguagePusher.$$$reportNull$$$0(11);
        }
        if (fileOrDir == null) {
            TemplateDataLanguagePusher.$$$reportNull$$$0(12);
        }
        if (actualProperty == null) {
            TemplateDataLanguagePusher.$$$reportNull$$$0(13);
        }
        PushedFilePropertiesUpdater.getInstance(project2).filePropertiesChanged(fileOrDir, file2 -> this.acceptsFile((VirtualFile)file2, project2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8, 9, 11, 12, 13 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/templateLanguages/TemplateDataLanguagePusher";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualProperty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePropertyKey";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValue";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/templateLanguages/TemplateDataLanguagePusher";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "fromString";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getImmediateValue";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "acceptsFile";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "acceptsDirectory";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "asString";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fromString";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "propertyChanged";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 2, 3, 4, 5, 6, 7, 8, 9, 11, 12, 13 -> new IllegalArgumentException(string2);
        };
    }
}

