/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.psi.util.PsiUtilCore;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/psi/util/PsiEditorUtilBase;", "Lcom/intellij/psi/util/PsiEditorUtil;", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "findEditorByPsiElement", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "intellij.platform.lang"})
@SourceDebugExtension(value={"SMAP\nPsiEditorUtilBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PsiEditorUtilBase.kt\ncom/intellij/psi/util/PsiEditorUtilBase\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,77:1\n26#2:78\n10#3:79\n*S KotlinDebug\n*F\n+ 1 PsiEditorUtilBase.kt\ncom/intellij/psi/util/PsiEditorUtilBase\n*L\n47#1:78\n18#1:79\n*E\n"})
public final class PsiEditorUtilBase
implements PsiEditorUtil {
    @NotNull
    public static final PsiEditorUtilBase INSTANCE = new PsiEditorUtilBase();
    @NotNull
    private static final Logger LOG;

    private PsiEditorUtilBase() {
    }

    @Nullable
    public Editor findEditorByPsiElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiFile psiFile = element.getContainingFile();
        if (IntentionPreviewUtils.isPreviewElement(psiFile)) {
            return IntentionPreviewUtils.getPreviewEditor();
        }
        VirtualFile virtualFile2 = PsiUtilCore.getVirtualFile(element);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile virtualFile3 = virtualFile2;
        Project project2 = psiFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"psiFile.project");
        Project project3 = project2;
        if (virtualFile3.isInLocalFileSystem() || virtualFile3.getFileSystem() instanceof NonPhysicalFileSystem) {
            FileEditor[] fileEditorArray;
            FileEditor[] fileEditorArray2;
            FileEditorManager fileEditorManager;
            FileEditorManager fileEditorManager2 = fileEditorManager = FileEditorManager.getInstance(project3);
            Object object = fileEditorArray2 = fileEditorManager2 != null ? fileEditorManager2.getEditors(virtualFile3) : null;
            if (fileEditorArray2 == null) {
                boolean $i$f$emptyArray = false;
                fileEditorArray = new FileEditor[]{};
            } else {
                fileEditorArray = fileEditorArray2;
            }
            for (FileEditor editor2 : fileEditorArray) {
                if (!(editor2 instanceof TextEditor)) continue;
                return ((TextEditor)editor2).getEditor();
            }
        }
        Promise promise = DataManager.getInstance().getDataContextFromFocusAsync();
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"getInstance().dataContextFromFocusAsync");
        Promise asyncResult = promise;
        if (asyncResult.isSucceeded()) {
            Document cachedDocument;
            Editor editor3 = null;
            try {
                Object t = asyncResult.blockingGet(-1);
                if (t == null) {
                    String string2 = "Required value was null.";
                    throw new IllegalArgumentException(string2.toString());
                }
                editor3 = (Editor)CommonDataKeys.EDITOR.getData((DataContext)t);
            }
            catch (TimeoutException e) {
                LOG.error(e);
            }
            catch (ExecutionException e) {
                LOG.error(e);
            }
            if (editor3 != null && (cachedDocument = PsiDocumentManager.getInstance(project3).getCachedDocument(psiFile)) == editor3.getDocument()) {
                return editor3;
            }
        }
        return null;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PsiEditorUtilBase.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        LOG = logger;
    }
}

