/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiFileWithOneLanguage;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.psi.util.PsiUtilCore;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiUtilBase
extends PsiUtilCore
implements PsiEditorUtil {
    private static final Logger LOG = Logger.getInstance(PsiUtilBase.class);
    public static final Comparator<Language> LANGUAGE_COMPARATOR = Comparator.comparing(Language::getID);

    public static boolean isUnderPsiRoot(@NotNull PsiFile root, @NotNull PsiElement element) {
        PsiFile containingFile;
        if (root == null) {
            PsiUtilBase.$$$reportNull$$$0(0);
        }
        if (element == null) {
            PsiUtilBase.$$$reportNull$$$0(1);
        }
        if ((containingFile = element.getContainingFile()) == root) {
            return true;
        }
        for (PsiFile psiRoot : root.getViewProvider().getAllFiles()) {
            if (containingFile != psiRoot) continue;
            return true;
        }
        PsiLanguageInjectionHost host = InjectedLanguageManager.getInstance(root.getProject()).getInjectionHost(element);
        return host != null && PsiUtilBase.isUnderPsiRoot(root, host);
    }

    @Nullable
    public static Language getLanguageInEditor(@NotNull Editor editor2, @NotNull Project project2) {
        if (editor2 == null) {
            PsiUtilBase.$$$reportNull$$$0(2);
        }
        if (project2 == null) {
            PsiUtilBase.$$$reportNull$$$0(3);
        }
        return PsiUtilBase.getLanguageInEditor(editor2.getCaretModel().getCurrentCaret(), project2);
    }

    @Nullable
    public static Language getLanguageInEditor(@NotNull Caret caret, @NotNull Project project2) {
        if (caret == null) {
            PsiUtilBase.$$$reportNull$$$0(4);
        }
        if (project2 == null) {
            PsiUtilBase.$$$reportNull$$$0(5);
        }
        Editor editor2 = caret.getEditor();
        PsiUtilBase.assertEditorAndProjectConsistent(project2, editor2);
        PsiFile file2 = PsiDocumentManager.getInstance(project2).getPsiFile(editor2.getDocument());
        if (file2 == null) {
            return null;
        }
        if (file2 instanceof PsiFileWithOneLanguage) {
            return file2.getLanguage();
        }
        int caretOffset = caret.getOffset();
        int mostProbablyCorrectLanguageOffset = caretOffset == caret.getSelectionEnd() ? caret.getSelectionStart() : caretOffset;
        PsiElement elt = PsiUtilBase.getElementAtOffset(file2, mostProbablyCorrectLanguageOffset);
        Language lang = PsiUtilBase.findLanguageFromElement(elt);
        if (caret.hasSelection()) {
            lang = PsiUtilBase.evaluateLanguageInRange(caret.getSelectionStart(), caret.getSelectionEnd(), file2);
        }
        return PsiUtilBase.narrowLanguage(lang, file2.getLanguage());
    }

    @Nullable
    public static PsiElement getElementAtCaret(@NotNull Editor editor2) {
        Project project2;
        if (editor2 == null) {
            PsiUtilBase.$$$reportNull$$$0(6);
        }
        if ((project2 = editor2.getProject()) == null) {
            return null;
        }
        PsiFile file2 = PsiDocumentManager.getInstance(project2).getPsiFile(editor2.getDocument());
        return file2 == null ? null : file2.findElementAt(editor2.getCaretModel().getOffset());
    }

    @Nullable
    public static PsiFile getPsiFileInEditor(@NotNull Editor editor2, @NotNull Project project2) {
        if (editor2 == null) {
            PsiUtilBase.$$$reportNull$$$0(7);
        }
        if (project2 == null) {
            PsiUtilBase.$$$reportNull$$$0(8);
        }
        return PsiUtilBase.getPsiFileInEditor(editor2.getCaretModel().getCurrentCaret(), project2);
    }

    @Nullable
    public static PsiFile getPsiFileInEditor(@NotNull Caret caret, @NotNull Project project2) {
        if (caret == null) {
            PsiUtilBase.$$$reportNull$$$0(9);
        }
        if (project2 == null) {
            PsiUtilBase.$$$reportNull$$$0(10);
        }
        Editor editor2 = caret.getEditor();
        PsiUtilBase.assertEditorAndProjectConsistent(project2, editor2);
        PsiFile file2 = PsiDocumentManager.getInstance(project2).getPsiFile(editor2.getDocument());
        if (file2 == null) {
            return null;
        }
        PsiUtilCore.ensureValid(file2);
        if (file2 instanceof PsiFileWithOneLanguage) {
            return file2;
        }
        Language language = PsiUtilBase.getLanguageInEditor(caret, project2);
        if (language == file2.getLanguage()) {
            return file2;
        }
        int caretOffset = caret.getOffset();
        int mostProbablyCorrectLanguageOffset = caretOffset == caret.getSelectionEnd() ? caret.getSelectionStart() : caretOffset;
        return PsiUtilBase.getPsiFileAtOffset(file2, mostProbablyCorrectLanguageOffset);
    }

    public static void assertEditorAndProjectConsistent(@NotNull Project project2, @NotNull Editor editor2) {
        Project editorProject;
        if (project2 == null) {
            PsiUtilBase.$$$reportNull$$$0(11);
        }
        if (editor2 == null) {
            PsiUtilBase.$$$reportNull$$$0(12);
        }
        if ((editorProject = editor2.getProject()) != null && editorProject != project2) {
            throw new IllegalArgumentException("Inconsistent editor/project combination: the editor belongs to " + editorProject + "; but passed project=" + project2);
        }
    }

    public static PsiFile getPsiFileAtOffset(@NotNull PsiFile file2, int offset2) {
        if (file2 == null) {
            PsiUtilBase.$$$reportNull$$$0(13);
        }
        if (file2 instanceof PsiFileWithOneLanguage) {
            return file2;
        }
        PsiElement elt = PsiUtilBase.getElementAtOffset(file2, offset2);
        PsiUtilBase.ensureValid(elt);
        return elt.getContainingFile();
    }

    @Nullable
    public static Language reallyEvaluateLanguageInRange(int start, int end, @NotNull PsiFile file2) {
        TextRange range;
        int endOffset;
        if (file2 == null) {
            PsiUtilBase.$$$reportNull$$$0(14);
        }
        if (file2 instanceof PsiBinaryFile || file2 instanceof PsiFileWithOneLanguage) {
            return file2.getLanguage();
        }
        Language lang = null;
        int curOffset = start;
        do {
            PsiElement elt;
            if (!((elt = PsiUtilBase.getElementAtOffset(file2, curOffset)) instanceof PsiWhiteSpace)) {
                Language language = PsiUtilBase.findLanguageFromElement(elt);
                if (lang == null) {
                    lang = language;
                } else if (lang != language) {
                    return null;
                }
            }
            if ((range = elt.getTextRange()) != null) continue;
            LOG.error("Null range for element " + elt + " of " + elt.getClass() + " in file " + file2 + " at offset " + curOffset);
            return file2.getLanguage();
        } while ((curOffset = (endOffset = range.getEndOffset()) <= curOffset ? curOffset + 1 : endOffset) < end);
        return PsiUtilBase.narrowLanguage(lang, file2.getLanguage());
    }

    @NotNull
    private static Language evaluateLanguageInRange(int start, int end, @NotNull PsiFile file2) {
        if (file2 == null) {
            PsiUtilBase.$$$reportNull$$$0(15);
        }
        PsiElement elt = PsiUtilBase.getElementAtOffset(file2, start);
        TextRange selectionRange = new TextRange(start, end);
        while (true) {
            if (elt instanceof PsiFile) {
                Language language = elt.getLanguage();
                if (language == null) {
                    PsiUtilBase.$$$reportNull$$$0(16);
                }
                return language;
            }
            PsiElement parent2 = elt.getParent();
            TextRange range = elt.getTextRange();
            if (range == null) {
                LOG.error("Range is null for " + elt + "; " + elt.getClass());
                Language language = file2.getLanguage();
                if (language == null) {
                    PsiUtilBase.$$$reportNull$$$0(17);
                }
                return language;
            }
            if (range.contains(selectionRange) || parent2 == null) {
                Language language = elt.getLanguage();
                if (language == null) {
                    PsiUtilBase.$$$reportNull$$$0(18);
                }
                return language;
            }
            elt = parent2;
        }
    }

    @NotNull
    public static ASTNode getRoot(@NotNull ASTNode node2) {
        if (node2 == null) {
            PsiUtilBase.$$$reportNull$$$0(19);
        }
        ASTNode child = node2;
        while (true) {
            ASTNode parent2;
            if ((parent2 = child.getTreeParent()) == null) {
                ASTNode aSTNode = child;
                if (aSTNode == null) {
                    PsiUtilBase.$$$reportNull$$$0(20);
                }
                return aSTNode;
            }
            child = parent2;
        }
    }

    @Deprecated
    @Nullable
    public Editor findEditorByPsiElement(@NotNull PsiElement element) {
        if (element == null) {
            PsiUtilBase.$$$reportNull$$$0(21);
        }
        return PsiUtilBase.findEditor(element);
    }

    @Deprecated
    @Nullable
    public static Editor findEditor(@NotNull PsiElement element) {
        if (element == null) {
            PsiUtilBase.$$$reportNull$$$0(22);
        }
        return PsiEditorUtil.findEditor((PsiElement)element);
    }

    public static boolean isSymLink(@NotNull PsiFileSystemItem element) {
        VirtualFile virtualFile2;
        if (element == null) {
            PsiUtilBase.$$$reportNull$$$0(23);
        }
        return (virtualFile2 = element.getVirtualFile()) != null && virtualFile2.is(VFileProperty.SYMLINK);
    }

    @Nullable
    public static VirtualFile asVirtualFile(@Nullable PsiElement element) {
        if (element instanceof PsiFileSystemItem) {
            PsiFileSystemItem psiFileSystemItem = (PsiFileSystemItem)element;
            return psiFileSystemItem.isValid() ? psiFileSystemItem.getVirtualFile() : null;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 16, 17, 18, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/util/PsiUtilBase";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/util/PsiUtilBase";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluateLanguageInRange";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isUnderPsiRoot";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageInEditor";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getElementAtCaret";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getPsiFileInEditor";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "assertEditorAndProjectConsistent";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getPsiFileAtOffset";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "reallyEvaluateLanguageInRange";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "evaluateLanguageInRange";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getRoot";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findEditorByPsiElement";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findEditor";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isSymLink";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 16, 17, 18, 20 -> new IllegalStateException(string2);
        };
    }
}

