/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util.proximity;

import com.intellij.navigation.PsiElementNavigationItem;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.Weigher;
import com.intellij.psi.WeighingComparable;
import com.intellij.psi.WeighingService;
import com.intellij.psi.statistics.StatisticsInfo;
import com.intellij.psi.statistics.StatisticsManager;
import com.intellij.psi.util.ProximityLocation;
import com.intellij.psi.util.proximity.ProximityStatistician;
import com.intellij.psi.util.proximity.ProximityWeigher;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.FactoryMap;
import java.util.Comparator;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class PsiProximityComparator
implements Comparator<Object> {
    public static final Key<ProximityStatistician> STATISTICS_KEY = Key.create("proximity");
    public static final Key<ProximityWeigher> WEIGHER_KEY = Key.create("proximity");
    private static final Key<Module> MODULE_BY_LOCATION = Key.create("ModuleByLocation");
    private final PsiElement myContext;
    private final Map<PsiElement, WeighingComparable<PsiElement, ProximityLocation>> myProximities;
    private final Module myContextModule;

    public PsiProximityComparator(@Nullable PsiElement context2) {
        this.myContext = context2;
        this.myContextModule = context2 == null ? null : ModuleUtilCore.findModuleForPsiElement(context2);
        this.myProximities = FactoryMap.create(key -> PsiProximityComparator.getProximity(key, this.myContext));
    }

    @Override
    public int compare(Object o1, Object o2) {
        PsiElement element1 = PsiProximityComparator.getPsiElement(o1);
        PsiElement element2 = PsiProximityComparator.getPsiElement(o2);
        if (element1 == null) {
            return element2 == null ? 0 : 1;
        }
        if (element2 == null) {
            return -1;
        }
        if (this.myContext != null && this.myContextModule != null) {
            int count2;
            StatisticsManager statisticsManager;
            int count1;
            ProximityLocation location2 = new ProximityLocation(this.myContext, this.myContextModule);
            StatisticsInfo info1 = StatisticsManager.serialize(STATISTICS_KEY, element1, location2);
            StatisticsInfo info2 = StatisticsManager.serialize(STATISTICS_KEY, element2, location2);
            if (info1 != null && info2 != null && (count1 = (statisticsManager = StatisticsManager.getInstance()).getLastUseRecency(info1)) != (count2 = statisticsManager.getLastUseRecency(info2))) {
                return count1 < count2 ? -1 : 1;
            }
        }
        WeighingComparable<PsiElement, ProximityLocation> proximity1 = this.myProximities.get(element1);
        WeighingComparable<PsiElement, ProximityLocation> proximity2 = this.myProximities.get(element2);
        if (proximity1 == null || proximity2 == null) {
            return 0;
        }
        return -proximity1.compareTo(proximity2);
    }

    private static PsiElement getPsiElement(Object o) {
        return o instanceof PsiElement ? (PsiElement)o : (o instanceof PsiElementNavigationItem ? ((PsiElementNavigationItem)o).getTargetElement() : null);
    }

    @Nullable
    public static WeighingComparable<PsiElement, ProximityLocation> getProximity(PsiElement element, PsiElement context2) {
        if (element == null) {
            return null;
        }
        Module contextModule = context2 != null ? ModuleUtilCore.findModuleForPsiElement(context2) : null;
        return WeighingService.weigh(WEIGHER_KEY, element, new ProximityLocation(context2, contextModule));
    }

    @Nullable
    public static WeighingComparable<PsiElement, ProximityLocation> getProximity(Computable<? extends PsiElement> elementComputable, PsiElement context2, ProcessingContext processingContext) {
        PsiElement element = elementComputable.compute();
        if (element == null || context2 == null) {
            return null;
        }
        Module contextModule = processingContext.get(MODULE_BY_LOCATION);
        if (contextModule == null) {
            contextModule = ModuleUtilCore.findModuleForPsiElement(context2);
            processingContext.put(MODULE_BY_LOCATION, contextModule);
        }
        return new WeighingComparable<PsiElement, ProximityLocation>(elementComputable, new ProximityLocation(context2, contextModule, processingContext), WeighingService.getWeighers(WEIGHER_KEY).toArray(new Weigher[0]));
    }
}

