/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util.proximity;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.util.NullableLazyKey;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.ProximityLocation;
import com.intellij.psi.util.proximity.ProximityWeigher;
import org.jetbrains.annotations.NotNull;

public class SameDirectoryWeigher
extends ProximityWeigher {
    private static final NullableLazyKey<PsiDirectory, ProximityLocation> PLACE_DIRECTORY = NullableLazyKey.create("placeDirectory", location2 -> SameDirectoryWeigher.getParentDirectory(location2.getPosition()));

    private static PsiDirectory getParentDirectory(PsiElement element) {
        PsiFile file2 = InjectedLanguageManager.getInstance(element.getProject()).getTopLevelFile(element);
        if (file2 != null) {
            element = file2.getOriginalFile();
        }
        while (element != null && !(element instanceof PsiDirectory)) {
            element = element.getParent();
        }
        return (PsiDirectory)element;
    }

    public Boolean weigh(@NotNull PsiElement element, @NotNull ProximityLocation location2) {
        if (element == null) {
            SameDirectoryWeigher.$$$reportNull$$$0(0);
        }
        if (location2 == null) {
            SameDirectoryWeigher.$$$reportNull$$$0(1);
        }
        if (location2.getPosition() == null) {
            return Boolean.TRUE;
        }
        PsiDirectory placeDirectory = PLACE_DIRECTORY.getValue(location2);
        return placeDirectory != null && placeDirectory.equals(SameDirectoryWeigher.getParentDirectory(element));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "location";
                break;
            }
        }
        objectArray[1] = "com/intellij/psi/util/proximity/SameDirectoryWeigher";
        objectArray[2] = "weigh";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

