/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.lang.ElementsHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.PsiNavigateUtil;
import org.jetbrains.annotations.NotNull;

public abstract class ClassRefactoringHandlerBase
implements RefactoringActionHandler,
ElementsHandler {
    @Override
    public boolean isEnabledOnElements(PsiElement[] elements) {
        return elements.length == 1 && this.acceptsElement(elements[0]);
    }

    protected static void navigate(PsiElement element) {
        PsiNavigateUtil.navigate(element);
    }

    public void invoke(@NotNull Project project2, Editor editor2, PsiFile file2, DataContext dataContext2) {
        PsiElement position;
        if (project2 == null) {
            ClassRefactoringHandlerBase.$$$reportNull$$$0(0);
        }
        int offset2 = editor2.getCaretModel().getOffset();
        editor2.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement element = position = file2.findElementAt(offset2);
        while (true) {
            if (element == null || element instanceof PsiFile) {
                String message = RefactoringBundle.getCannotRefactorMessage((String)this.getInvalidPositionMessage());
                CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor2, (String)message, (String)this.getTitle(), (String)this.getHelpId());
                return;
            }
            if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project2, (PsiElement)element)) {
                return;
            }
            if (this.acceptsElement(element)) {
                this.invoke(project2, new PsiElement[]{position}, dataContext2);
                return;
            }
            element = element.getParent();
        }
    }

    public void invoke(@NotNull Project project2, PsiElement @NotNull [] elements, DataContext dataContext2) {
        if (project2 == null) {
            ClassRefactoringHandlerBase.$$$reportNull$$$0(1);
        }
        if (elements == null) {
            ClassRefactoringHandlerBase.$$$reportNull$$$0(2);
        }
        PsiFile file2 = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext2);
        Editor editor2 = (Editor)CommonDataKeys.EDITOR.getData(dataContext2);
        this.showDialog(project2, elements[0], editor2, file2, dataContext2);
    }

    protected abstract boolean acceptsElement(PsiElement var1);

    protected abstract void showDialog(Project var1, PsiElement var2, Editor var3, PsiFile var4, DataContext var5);

    protected abstract String getHelpId();

    @NlsContexts.DialogTitle
    protected abstract String getTitle();

    @NlsContexts.DialogMessage
    protected abstract String getInvalidPositionMessage();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "elements";
                break;
            }
        }
        objectArray[1] = "com/intellij/refactoring/ClassRefactoringHandlerBase";
        objectArray[2] = "invoke";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

