/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.actions;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageRefactoringSupport;
import com.intellij.lang.refactoring.RefactoringSupportProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import com.intellij.refactoring.lang.ElementsHandler;
import com.intellij.util.CachedValueImpl;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BasePlatformRefactoringAction
extends BaseRefactoringAction {
    private final CachedValue<Boolean> myHidden = new CachedValueImpl<Boolean>(() -> CachedValueProvider.Result.create(Boolean.valueOf(this.calcHidden()), LanguageRefactoringSupport.INSTANCE));
    private final Condition<RefactoringSupportProvider> myCondition = provider2 -> this.getRefactoringHandler((RefactoringSupportProvider)provider2) != null;

    @Override
    protected final RefactoringActionHandler getHandler(@NotNull DataContext dataContext2) {
        Language[] languages;
        RefactoringActionHandler handler2;
        RefactoringActionHandler handler3;
        RefactoringActionHandler handler4;
        if (dataContext2 == null) {
            BasePlatformRefactoringAction.$$$reportNull$$$0(0);
        }
        PsiElement element = null;
        Editor editor2 = (Editor)CommonDataKeys.EDITOR.getData(dataContext2);
        PsiFile file2 = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext2);
        if (editor2 != null && file2 != null && (element = BasePlatformRefactoringAction.getElementAtCaret(editor2, file2)) != null && (handler4 = this.getHandler(element.getLanguage(), element)) != null) {
            return handler4;
        }
        PsiElement referenced = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext2);
        if (referenced != null && (handler3 = this.getHandler(referenced.getLanguage(), referenced)) != null) {
            return handler3;
        }
        PsiElement[] psiElements = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext2);
        if (psiElements != null && psiElements.length > 1 && (handler2 = this.getHandler(psiElements[0].getLanguage(), psiElements[0])) != null && this.isEnabledOnElements(psiElements)) {
            return handler2;
        }
        if (element == null) {
            element = referenced;
        }
        if ((languages = (Language[])LangDataKeys.CONTEXT_LANGUAGES.getData(dataContext2)) != null) {
            for (Language language : languages) {
                RefactoringActionHandler handler5 = this.getHandler(language, element);
                if (handler5 == null) continue;
                return handler5;
            }
        }
        return null;
    }

    @Nullable
    protected RefactoringActionHandler getHandler(@NotNull Language language, PsiElement element) {
        List providers;
        if (language == null) {
            BasePlatformRefactoringAction.$$$reportNull$$$0(1);
        }
        if ((providers = LanguageRefactoringSupport.INSTANCE.allForLanguage(language)).isEmpty()) {
            return null;
        }
        if (element == null) {
            return this.getRefactoringHandler((RefactoringSupportProvider)providers.get(0));
        }
        for (RefactoringSupportProvider provider2 : providers) {
            if (!provider2.isAvailable(element)) continue;
            return this.getRefactoringHandler(provider2, element);
        }
        return null;
    }

    @Override
    protected boolean isAvailableOnElementInEditorAndFile(@NotNull PsiElement element, @NotNull Editor editor2, @NotNull PsiFile file2, @NotNull DataContext context2) {
        if (element == null) {
            BasePlatformRefactoringAction.$$$reportNull$$$0(2);
        }
        if (editor2 == null) {
            BasePlatformRefactoringAction.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            BasePlatformRefactoringAction.$$$reportNull$$$0(4);
        }
        if (context2 == null) {
            BasePlatformRefactoringAction.$$$reportNull$$$0(5);
        }
        return this.getHandler(context2) != null;
    }

    @Override
    protected boolean isAvailableForLanguage(Language language) {
        List providers = LanguageRefactoringSupport.INSTANCE.allForLanguage(language);
        return ContainerUtil.find(providers, this.myCondition) != null;
    }

    @Override
    protected boolean isEnabledOnElements(PsiElement @NotNull [] elements) {
        if (elements == null) {
            BasePlatformRefactoringAction.$$$reportNull$$$0(6);
        }
        if (elements.length > 0) {
            Language language = elements[0].getLanguage();
            RefactoringActionHandler handler2 = this.getHandler(language, elements[0]);
            return handler2 instanceof ElementsHandler && ((ElementsHandler)handler2).isEnabledOnElements(elements);
        }
        return false;
    }

    @Nullable
    protected abstract RefactoringActionHandler getRefactoringHandler(@NotNull RefactoringSupportProvider var1);

    @Nullable
    protected RefactoringActionHandler getRefactoringHandler(@NotNull RefactoringSupportProvider provider2, PsiElement element) {
        if (provider2 == null) {
            BasePlatformRefactoringAction.$$$reportNull$$$0(7);
        }
        return this.getRefactoringHandler(provider2);
    }

    @Override
    protected boolean isHidden() {
        return this.myHidden.getValue();
    }

    private boolean calcHidden() {
        ArrayList<Language> languages = new ArrayList<Language>(Language.getRegisteredLanguages());
        languages.sort((o1, o2) -> {
            if ("JAVA".equals(o1.getID())) {
                return -1;
            }
            if ("JAVA".equals(o2.getID())) {
                return 1;
            }
            return o1.getID().compareTo(o2.getID());
        });
        for (Language l : languages) {
            if (!this.isAvailableForLanguage(l)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/actions/BasePlatformRefactoringAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getHandler";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailableOnElementInEditorAndFile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabledOnElements";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getRefactoringHandler";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

