/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.actions;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.ide.IdeEventQueue;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.lang.ContextAwareActionHandler;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.DocCommandGroupId;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntheticElement;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.actions.RefactoringUsageCollector;
import com.intellij.refactoring.rename.inplace.InplaceRefactoring;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseRefactoringAction
extends AnAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            BaseRefactoringAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    protected abstract boolean isAvailableInEditorOnly();

    protected abstract boolean isEnabledOnElements(PsiElement @NotNull [] var1);

    protected boolean isAvailableOnElementInEditorAndFile(@NotNull PsiElement element, @NotNull Editor editor2, @NotNull PsiFile file2, @NotNull DataContext context2, @NotNull String place) {
        if (element == null) {
            BaseRefactoringAction.$$$reportNull$$$0(1);
        }
        if (editor2 == null) {
            BaseRefactoringAction.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            BaseRefactoringAction.$$$reportNull$$$0(3);
        }
        if (context2 == null) {
            BaseRefactoringAction.$$$reportNull$$$0(4);
        }
        if (place == null) {
            BaseRefactoringAction.$$$reportNull$$$0(5);
        }
        if (ActionPlaces.isPopupPlace((String)place)) {
            ContextAwareActionHandler contextAwareActionHandler;
            RefactoringActionHandler handler2 = this.getHandler(context2);
            if (handler2 == null) {
                return false;
            }
            if (handler2 instanceof ContextAwareActionHandler && !(contextAwareActionHandler = (ContextAwareActionHandler)handler2).isAvailableForQuickList(editor2, file2, context2)) {
                return false;
            }
        }
        return this.isAvailableOnElementInEditorAndFile(element, editor2, file2, context2);
    }

    protected boolean isAvailableOnElementInEditorAndFile(@NotNull PsiElement element, @NotNull Editor editor2, @NotNull PsiFile file2, @NotNull DataContext context2) {
        if (element == null) {
            BaseRefactoringAction.$$$reportNull$$$0(6);
        }
        if (editor2 == null) {
            BaseRefactoringAction.$$$reportNull$$$0(7);
        }
        if (file2 == null) {
            BaseRefactoringAction.$$$reportNull$$$0(8);
        }
        if (context2 == null) {
            BaseRefactoringAction.$$$reportNull$$$0(9);
        }
        return true;
    }

    protected boolean hasAvailableHandler(@NotNull DataContext dataContext2) {
        RefactoringActionHandler handler2;
        if (dataContext2 == null) {
            BaseRefactoringAction.$$$reportNull$$$0(10);
        }
        if ((handler2 = this.getHandler(dataContext2)) != null) {
            if (handler2 instanceof ContextAwareActionHandler) {
                Editor editor2 = (Editor)CommonDataKeys.EDITOR.getData(dataContext2);
                PsiFile file2 = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext2);
                if (editor2 != null && file2 != null && !((ContextAwareActionHandler)handler2).isAvailableForQuickList(editor2, file2, dataContext2)) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Nullable
    protected abstract RefactoringActionHandler getHandler(@NotNull DataContext var1);

    public final void actionPerformed(@NotNull AnActionEvent e) {
        RefactoringActionHandler handler2;
        if (e == null) {
            BaseRefactoringAction.$$$reportNull$$$0(11);
        }
        DataContext dataContext2 = e.getDataContext();
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        int eventCount = IdeEventQueue.getInstance().getEventCount();
        if (!PsiDocumentManager.getInstance(project2).commitAllDocumentsUnderProgress()) {
            return;
        }
        try {
            handler2 = this.getHandler(dataContext2);
        }
        catch (ProcessCanceledException ignored) {
            return;
        }
        IdeEventQueue.getInstance().setEventCount(eventCount);
        BaseRefactoringAction.performRefactoringAction(project2, dataContext2, handler2);
    }

    @ApiStatus.Internal
    public static void performRefactoringAction(@NotNull Project project2, @NotNull DataContext dataContext2, @Nullable RefactoringActionHandler handler2) {
        PsiFile file2;
        LookupEx lookup2;
        if (project2 == null) {
            BaseRefactoringAction.$$$reportNull$$$0(12);
        }
        if (dataContext2 == null) {
            BaseRefactoringAction.$$$reportNull$$$0(13);
        }
        Editor editor2 = (Editor)dataContext2.getData(CommonDataKeys.EDITOR);
        if (handler2 == null) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"error.wrong.caret.position.symbol.to.refactor"));
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor2, (String)message, (String)RefactoringBundle.getCannotRefactorMessage(null), null);
            return;
        }
        PsiElement[] elements = BaseRefactoringAction.getPsiElementArray(dataContext2);
        InplaceRefactoring activeInplaceRenamer = InplaceRefactoring.getActiveInplaceRenamer(editor2);
        if (activeInplaceRenamer != null && !InplaceRefactoring.canStartAnotherRefactoring(editor2, handler2, elements)) {
            InplaceRefactoring.unableToStartWarning(project2, editor2);
            return;
        }
        if (activeInplaceRenamer == null && (lookup2 = LookupManager.getActiveLookup(editor2)) instanceof LookupImpl) {
            Runnable command2 = () -> ((LookupImpl)lookup2).finishLookup('\n');
            Document doc = editor2.getDocument();
            DocCommandGroupId group2 = DocCommandGroupId.noneGroupId(doc);
            CommandProcessor.getInstance().executeCommand(editor2.getProject(), command2, ApplicationBundle.message((String)"title.code.completion", (Object[])new Object[0]), (Object)group2, UndoConfirmationPolicy.DEFAULT, doc);
        }
        PsiFile psiFile = file2 = editor2 != null ? PsiDocumentManager.getInstance(project2).getPsiFile(editor2.getDocument()) : null;
        Language language = file2 != null ? file2.getLanguage() : (elements.length > 0 ? elements[0].getLanguage() : null);
        ArrayList<EventPair> data2 = new ArrayList<EventPair>();
        data2.add(RefactoringUsageCollector.HANDLER.with(handler2.getClass()));
        data2.add(EventFields.Language.with((Object)language));
        if (elements.length > 0) {
            data2.add(RefactoringUsageCollector.ELEMENT.with(elements[0].getClass()));
        }
        RefactoringUsageCollector.HANDLER_INVOKED.log(project2, data2);
        if (editor2 != null) {
            if (file2 == null) {
                return;
            }
            DaemonCodeAnalyzer.getInstance(project2).autoImportReferenceAtCursor(editor2, file2);
            handler2.invoke(project2, editor2, file2, dataContext2);
        } else {
            handler2.invoke(project2, elements, dataContext2);
        }
    }

    protected boolean isEnabledOnDataContext(@NotNull DataContext dataContext2) {
        if (dataContext2 == null) {
            BaseRefactoringAction.$$$reportNull$$$0(14);
        }
        return false;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            BaseRefactoringAction.$$$reportNull$$$0(15);
        }
        Presentation presentation2 = e.getPresentation();
        presentation2.setEnabledAndVisible(true);
        DataContext dataContext2 = e.getDataContext();
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project2 == null || this.isHidden()) {
            BaseRefactoringAction.hideAction(e);
            return;
        }
        Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
        PsiFile file2 = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (file2 != null && (file2 instanceof PsiCompiledElement && this.disableOnCompiledElement() || !this.isAvailableForFile(file2))) {
            BaseRefactoringAction.hideAction(e);
            return;
        }
        if (editor2 == null) {
            boolean isEnabled;
            if (this.isAvailableInEditorOnly()) {
                BaseRefactoringAction.hideAction(e);
                return;
            }
            PsiElement[] elements = BaseRefactoringAction.getPsiElementArray(dataContext2);
            boolean bl = isEnabled = this.isEnabledOnDataContext(dataContext2) || elements.length != 0 && this.isEnabledOnElements(elements);
            if (!isEnabled) {
                BaseRefactoringAction.disableAction(e);
            } else {
                this.updateActionText(e);
            }
        } else {
            PsiElement element = BaseRefactoringAction.findRefactoringTargetInEditor(dataContext2, this::isAvailableForLanguage);
            if (element != null) {
                boolean isEnabled;
                boolean bl = isEnabled = file2 != null && this.isAvailableOnElementInEditorAndFile(element, editor2, file2, dataContext2, e.getPlace());
                if (!isEnabled) {
                    BaseRefactoringAction.disableAction(e);
                } else {
                    this.updateActionText(e);
                }
            } else {
                BaseRefactoringAction.hideAction(e);
            }
        }
    }

    @ApiStatus.Internal
    public static PsiElement findRefactoringTargetInEditor(@NotNull DataContext dataContext2, @NotNull Predicate<? super Language> elementLanguagePredicate) {
        if (dataContext2 == null) {
            BaseRefactoringAction.$$$reportNull$$$0(16);
        }
        if (elementLanguagePredicate == null) {
            BaseRefactoringAction.$$$reportNull$$$0(17);
        }
        Editor editor2 = (Editor)dataContext2.getData(CommonDataKeys.EDITOR);
        PsiFile file2 = (PsiFile)dataContext2.getData(CommonDataKeys.PSI_FILE);
        PsiElement element = (PsiElement)dataContext2.getData(CommonDataKeys.PSI_ELEMENT);
        Language[] languages = (Language[])dataContext2.getData(LangDataKeys.CONTEXT_LANGUAGES);
        if (element == null || element instanceof SyntheticElement || !elementLanguagePredicate.test(element.getLanguage())) {
            if (file2 == null || editor2 == null) {
                return null;
            }
            element = BaseRefactoringAction.getElementAtCaret(editor2, file2);
        }
        if (element == null || element instanceof SyntheticElement || languages == null) {
            return null;
        }
        if (ContainerUtil.find(languages, elementLanguagePredicate::test) == null) {
            return null;
        }
        return element;
    }

    private void updateActionText(AnActionEvent e) {
        String actionText = this.getActionName(e.getDataContext());
        if (actionText != null) {
            e.getPresentation().setText(actionText);
        }
    }

    @NlsActions.ActionText
    @Nullable
    protected String getActionName(@NotNull DataContext dataContext2) {
        if (dataContext2 == null) {
            BaseRefactoringAction.$$$reportNull$$$0(18);
        }
        return null;
    }

    protected boolean disableOnCompiledElement() {
        return true;
    }

    private static void hideAction(@NotNull AnActionEvent e) {
        if (e == null) {
            BaseRefactoringAction.$$$reportNull$$$0(19);
        }
        e.getPresentation().setVisible(false);
        BaseRefactoringAction.disableAction(e);
    }

    protected boolean isHidden() {
        return false;
    }

    public static PsiElement getElementAtCaret(@NotNull Editor editor2, PsiFile file2) {
        if (editor2 == null) {
            BaseRefactoringAction.$$$reportNull$$$0(20);
        }
        return CommonRefactoringUtil.getElementAtCaret((Editor)editor2, (PsiFile)file2);
    }

    private static void disableAction(@NotNull AnActionEvent e) {
        if (e == null) {
            BaseRefactoringAction.$$$reportNull$$$0(21);
        }
        e.getPresentation().setEnabled(false);
    }

    protected boolean isAvailableForLanguage(Language language) {
        return true;
    }

    protected boolean isAvailableForFile(PsiFile file2) {
        return true;
    }

    public static PsiElement @NotNull [] getPsiElementArray(@NotNull DataContext dataContext2) {
        if (dataContext2 == null) {
            BaseRefactoringAction.$$$reportNull$$$0(22);
        }
        PsiElement[] psiElementArray = CommonRefactoringUtil.getPsiElementArray((DataContext)dataContext2);
        if (psiElementArray == null) {
            BaseRefactoringAction.$$$reportNull$$$0(23);
        }
        return psiElementArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/actions/BaseRefactoringAction";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 7: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 11: 
            case 15: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementLanguagePredicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/actions/BaseRefactoringAction";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiElementArray";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableOnElementInEditorAndFile";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasAvailableHandler";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoringAction";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isEnabledOnDataContext";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findRefactoringTargetInEditor";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getActionName";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "hideAction";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getElementAtCaret";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "disableAction";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getPsiElementArray";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22 -> new IllegalArgumentException(string2);
        };
    }
}

