/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SyntheticElement;
import com.intellij.refactoring.InplaceRefactoringContinuation;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.actions.RenamerRenderer;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.Renamer;
import com.intellij.refactoring.rename.RenamerFactory;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.SlowOperations;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class RenameElementAction
extends AnAction {
    public RenameElementAction() {
        this.setInjectedContext(true);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            RenameElementAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            RenameElementAction.$$$reportNull$$$0(1);
        }
        e.getPresentation().setEnabled(this.isAvailable(e.getDataContext()));
    }

    @ApiStatus.Internal
    public boolean isAvailable(@NotNull DataContext dataContext2) {
        Project project2;
        if (dataContext2 == null) {
            RenameElementAction.$$$reportNull$$$0(2);
        }
        if ((project2 = (Project)dataContext2.getData(CommonDataKeys.PROJECT)) == null) {
            return false;
        }
        Editor editor2 = (Editor)dataContext2.getData(CommonDataKeys.EDITOR);
        if (editor2 != null && InplaceRefactoringContinuation.hasInplaceContinuation(editor2, RenameElementAction.class)) {
            return true;
        }
        return SlowOperations.allowSlowOperations(() -> RenameElementAction.getAvailableRenamers(dataContext2).findAny().isPresent());
    }

    public final void actionPerformed(@NotNull AnActionEvent e) {
        List renamers;
        DataContext dataContext2;
        Project project2;
        if (e == null) {
            RenameElementAction.$$$reportNull$$$0(3);
        }
        if ((project2 = (Project)(dataContext2 = e.getDataContext()).getData(CommonDataKeys.PROJECT)) == null) {
            return;
        }
        Editor editor2 = (Editor)dataContext2.getData(CommonDataKeys.EDITOR);
        if (editor2 != null && InplaceRefactoringContinuation.tryResumeInplaceContinuation(project2, editor2, RenameElementAction.class)) {
            return;
        }
        if (!PsiDocumentManager.getInstance(project2).commitAllDocumentsUnderProgress()) {
            return;
        }
        try (AccessToken ignored = SlowOperations.startSection("action.perform");){
            renamers = RenameElementAction.getAvailableRenamers(dataContext2).collect(Collectors.toList());
        }
        if (renamers.isEmpty()) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"error.wrong.caret.position.symbol.to.refactor"));
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)((Editor)e.getData(CommonDataKeys.EDITOR)), (String)message, (String)RefactoringBundle.getCannotRefactorMessage(null), null);
        } else if (renamers.size() == 1) {
            ((Renamer)renamers.get(0)).performRename();
        } else {
            JBPopupFactory.getInstance().createPopupChooserBuilder(renamers).setTitle(RefactoringBundle.message((String)"what.would.you.like.to.do")).setRenderer((ListCellRenderer)RenamerRenderer.INSTANCE).setItemChosenCallback(Renamer::performRename).createPopup().showInBestPositionFor(dataContext2);
        }
    }

    @NotNull
    private static Stream<Renamer> getAvailableRenamers(@NotNull DataContext dataContext2) {
        if (dataContext2 == null) {
            RenameElementAction.$$$reportNull$$$0(4);
        }
        Stream<Renamer> stream = RenamerFactory.EP_NAME.getExtensionList().stream().flatMap(factory2 -> factory2.createRenamers(dataContext2).stream());
        if (stream == null) {
            RenameElementAction.$$$reportNull$$$0(5);
        }
        return stream;
    }

    public static boolean isRenameEnabledOnElements(PsiElement @NotNull [] elements) {
        if (elements == null) {
            RenameElementAction.$$$reportNull$$$0(6);
        }
        if (elements.length != 1) {
            return false;
        }
        PsiElement element = elements[0];
        return element instanceof PsiNamedElement && !(element instanceof SyntheticElement) && !PsiElementRenameHandler.isVetoed((PsiElement)element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/actions/RenameElementAction";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/actions/RenameElementAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableRenamers";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableRenamers";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isRenameEnabledOnElements";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2, 3, 4, 6 -> new IllegalArgumentException(string2);
        };
    }
}

