/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature;

import com.intellij.diagnostic.PluginException;
import com.intellij.ide.actions.CopyReferenceAction;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import com.intellij.refactoring.changeSignature.ChangeSignatureUsageProcessor;
import com.intellij.refactoring.changeSignature.ParameterInfo;
import com.intellij.refactoring.changeSignature.PossiblyIncorrectUsage;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.listeners.UndoRefactoringElementListener;
import com.intellij.refactoring.listeners.impl.RefactoringTransaction;
import com.intellij.refactoring.rename.ResolveSnapshotProvider;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenamer;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChangeSignatureProcessorBase
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance(ChangeSignatureProcessorBase.class);
    protected static final String REFACTORING_ID = "refactoring.changeSignature";
    protected final ChangeInfo myChangeInfo;
    protected final PsiManager myManager;

    protected ChangeSignatureProcessorBase(Project project2, ChangeInfo changeInfo) {
        super(project2);
        this.myChangeInfo = changeInfo;
        this.myManager = PsiManager.getInstance(project2);
    }

    protected UsageInfo @NotNull [] findUsages() {
        return ChangeSignatureProcessorBase.findUsages(this.myChangeInfo);
    }

    public static void collectConflictsFromExtensions(@NotNull Ref<UsageInfo[]> refUsages, MultiMap<PsiElement, String> conflictDescriptions, ChangeInfo changeInfo) {
        if (refUsages == null) {
            ChangeSignatureProcessorBase.$$$reportNull$$$0(0);
        }
        for (ChangeSignatureUsageProcessor usageProcessor : (ChangeSignatureUsageProcessor[])ChangeSignatureUsageProcessor.EP_NAME.getExtensions()) {
            MultiMap conflicts = usageProcessor.findConflicts(changeInfo, refUsages);
            for (PsiElement key : conflicts.keySet()) {
                Collection<String> collection = conflictDescriptions.get(key);
                if (collection.isEmpty()) {
                    collection = new HashSet<String>();
                }
                collection.addAll(conflicts.get(key));
                conflictDescriptions.put(key, collection);
            }
        }
    }

    public static UsageInfo @NotNull [] findUsages(ChangeInfo changeInfo) {
        ChangeSignatureUsageProcessor[] processors;
        List<Object> infos = new ArrayList();
        for (ChangeSignatureUsageProcessor processor : processors = (ChangeSignatureUsageProcessor[])ChangeSignatureUsageProcessor.EP_NAME.getExtensions()) {
            for (UsageInfo info2 : processor.findUsages(changeInfo)) {
                if (info2 == null) {
                    PluginException.logPluginError(LOG, "findUsages() returns null items in " + processor.getClass().getName(), null, processor.getClass());
                    continue;
                }
                infos.add(info2);
            }
        }
        infos = ChangeSignatureProcessorBase.filterUsages(infos);
        UsageInfo[] usageInfoArray = infos.toArray(UsageInfo.EMPTY_ARRAY);
        if (usageInfoArray == null) {
            ChangeSignatureProcessorBase.$$$reportNull$$$0(1);
        }
        return usageInfoArray;
    }

    protected static List<UsageInfo> filterUsages(List<? extends UsageInfo> infos) {
        LinkedHashMap<PsiElement, MoveRenameUsageInfo> moveRenameInfos = new LinkedHashMap<PsiElement, MoveRenameUsageInfo>();
        HashSet<PsiElement> usedElements = new HashSet<PsiElement>();
        ArrayList<UsageInfo> result2 = new ArrayList<UsageInfo>(infos.size() / 2);
        for (UsageInfo usageInfo : infos) {
            LOG.assertTrue(usageInfo != null);
            PsiElement element = usageInfo.getElement();
            if (usageInfo instanceof MoveRenameUsageInfo) {
                if (usedElements.contains(element)) continue;
                moveRenameInfos.put(element, (MoveRenameUsageInfo)usageInfo);
                continue;
            }
            moveRenameInfos.remove(element);
            usedElements.add(element);
            if (usageInfo instanceof PossiblyIncorrectUsage && !((PossiblyIncorrectUsage)usageInfo).isCorrect()) continue;
            result2.add(usageInfo);
        }
        result2.addAll(moveRenameInfos.values());
        return result2;
    }

    protected boolean isPreviewUsages(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            ChangeSignatureProcessorBase.$$$reportNull$$$0(2);
        }
        for (ChangeSignatureUsageProcessor processor : (ChangeSignatureUsageProcessor[])ChangeSignatureUsageProcessor.EP_NAME.getExtensions()) {
            if (!processor.shouldPreviewUsages(this.myChangeInfo, usages)) continue;
            return true;
        }
        return super.isPreviewUsages(usages);
    }

    @Nullable
    protected String getRefactoringId() {
        return REFACTORING_ID;
    }

    @Nullable
    protected RefactoringEventData getBeforeData() {
        RefactoringEventData data2 = new RefactoringEventData();
        ChangeInfo changeInfo = this.getChangeInfo();
        data2.addElement(changeInfo.getMethod());
        ArrayList<String> defaultValues = new ArrayList<String>();
        for (ParameterInfo parameter : changeInfo.getNewParameters()) {
            if (parameter.getOldIndex() != -1) continue;
            ContainerUtil.addIfNotNull(defaultValues, parameter.getDefaultValue());
        }
        if (!defaultValues.isEmpty()) {
            data2.addStringProperties(ArrayUtil.toStringArray(defaultValues));
        }
        return data2;
    }

    @Nullable
    protected RefactoringEventData getAfterData(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            ChangeSignatureProcessorBase.$$$reportNull$$$0(3);
        }
        RefactoringEventData data2 = new RefactoringEventData();
        data2.addElement(this.getChangeInfo().getMethod());
        return data2;
    }

    protected void performRefactoring(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            ChangeSignatureProcessorBase.$$$reportNull$$$0(4);
        }
        RefactoringTransaction transaction = this.getTransaction();
        final ChangeInfo changeInfo = this.myChangeInfo;
        final RefactoringElementListener elementListener = transaction == null ? null : transaction.getElementListener(changeInfo.getMethod());
        final String fqn = CopyReferenceAction.elementToFqn(changeInfo.getMethod());
        if (fqn != null) {
            BasicUndoableAction action2 = new BasicUndoableAction(){

                @Override
                public void undo() {
                    if (elementListener instanceof UndoRefactoringElementListener) {
                        ((UndoRefactoringElementListener)((Object)elementListener)).undoElementMovedOrRenamed(changeInfo.getMethod(), fqn);
                    }
                }

                @Override
                public void redo() {
                }
            };
            UndoManager.getInstance(this.myProject).undoableActionPerformed(action2);
        }
        try {
            ChangeSignatureProcessorBase.doChangeSignature(changeInfo, usages);
            PsiElement method2 = changeInfo.getMethod();
            LOG.assertTrue(method2.isValid());
            if (elementListener != null && changeInfo.isNameChanged()) {
                elementListener.elementRenamed(method2);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error(e);
        }
    }

    public static void doChangeSignature(ChangeInfo changeInfo, UsageInfo @NotNull [] usages) {
        if (usages == null) {
            ChangeSignatureProcessorBase.$$$reportNull$$$0(5);
        }
        ChangeSignatureUsageProcessor[] processors = (ChangeSignatureUsageProcessor[])ChangeSignatureUsageProcessor.EP_NAME.getExtensions();
        ResolveSnapshotProvider resolveSnapshotProvider = changeInfo.isParameterNamesChanged() ? VariableInplaceRenamer.INSTANCE.forLanguage(changeInfo.getMethod().getLanguage()) : null;
        ArrayList snapshots = new ArrayList();
        for (ChangeSignatureUsageProcessor changeSignatureUsageProcessor : processors) {
            if (resolveSnapshotProvider == null) continue;
            changeSignatureUsageProcessor.registerConflictResolvers(snapshots, resolveSnapshotProvider, usages, changeInfo);
        }
        for (UsageInfo usageInfo : usages) {
            for (ChangeSignatureUsageProcessor processor : processors) {
                if (processor.processUsage(changeInfo, usageInfo, true, usages)) break;
            }
        }
        LOG.assertTrue(changeInfo.getMethod().isValid());
        for (ChangeSignatureUsageProcessor changeSignatureUsageProcessor : processors) {
            if (changeSignatureUsageProcessor.processPrimaryMethod(changeInfo)) break;
        }
        for (UsageInfo usageInfo : usages) {
            for (ChangeSignatureUsageProcessor processor : processors) {
                if (processor.processUsage(changeInfo, usageInfo, false, usages)) break;
            }
        }
        if (!snapshots.isEmpty()) {
            for (ParameterInfo parameterInfo : changeInfo.getNewParameters()) {
                for (ResolveSnapshotProvider.ResolveSnapshot snapshot : snapshots) {
                    snapshot.apply(parameterInfo.getName());
                }
            }
        }
    }

    @NotNull
    @NlsContexts.Command
    protected String getCommandName() {
        String string2 = RefactoringBundle.message((String)"changing.signature.of.0", (Object[])new Object[]{DescriptiveNameUtil.getDescriptiveName((PsiElement)this.myChangeInfo.getMethod())});
        if (string2 == null) {
            ChangeSignatureProcessorBase.$$$reportNull$$$0(6);
        }
        return string2;
    }

    public ChangeInfo getChangeInfo() {
        return this.myChangeInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/changeSignature/ChangeSignatureProcessorBase";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/changeSignature/ChangeSignatureProcessorBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectConflictsFromExtensions";
                break;
            }
            case 1: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isPreviewUsages";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAfterData";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doChangeSignature";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 6 -> new IllegalStateException(string2);
        };
    }
}

