/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature.inplace;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.BaseRefactoringIntentionAction;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import com.intellij.refactoring.changeSignature.inplace.InplaceChangeSignature;
import com.intellij.refactoring.changeSignature.inplace.LanguageChangeSignatureDetector;
import com.intellij.refactoring.changeSignature.inplace.LanguageChangeSignatureDetectors;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplyChangeSignatureAction
extends BaseRefactoringIntentionAction {
    private final String myMethodName;

    public ApplyChangeSignatureAction(String methodName) {
        this.myMethodName = methodName;
    }

    @Override
    @NotNull
    public String getText() {
        String string2 = RefactoringBundle.message((String)"changing.signature.of.0", (Object[])new Object[]{this.myMethodName});
        if (string2 == null) {
            ApplyChangeSignatureAction.$$$reportNull$$$0(0);
        }
        return string2;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string2 = RefactoringBundle.message((String)"intention.family.name.apply.signature.change");
        if (string2 == null) {
            ApplyChangeSignatureAction.$$$reportNull$$$0(1);
        }
        return string2;
    }

    @Override
    public boolean isAvailable(@NotNull Project project2, Editor editor2, @NotNull PsiElement element) {
        LanguageChangeSignatureDetector detector;
        if (project2 == null) {
            ApplyChangeSignatureAction.$$$reportNull$$$0(2);
        }
        if (element == null) {
            ApplyChangeSignatureAction.$$$reportNull$$$0(3);
        }
        if ((detector = (LanguageChangeSignatureDetector)LanguageChangeSignatureDetectors.INSTANCE.forLanguage(element.getLanguage())) != null) {
            ChangeInfo currentInfo;
            InplaceChangeSignature changeSignature = InplaceChangeSignature.getCurrentRefactoring(editor2);
            ChangeInfo changeInfo = currentInfo = changeSignature != null ? changeSignature.getCurrentInfo() : null;
            if (currentInfo != null && detector.isChangeSignatureAvailableOnElement(element, currentInfo)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void invoke(@NotNull Project project2, Editor editor2, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project2 == null) {
            ApplyChangeSignatureAction.$$$reportNull$$$0(4);
        }
        if (element == null) {
            ApplyChangeSignatureAction.$$$reportNull$$$0(5);
        }
        InplaceChangeSignature signatureGestureDetector = InplaceChangeSignature.getCurrentRefactoring(editor2);
        String initialSignature = signatureGestureDetector.getInitialSignature();
        ChangeInfo currentInfo = signatureGestureDetector.getCurrentInfo();
        signatureGestureDetector.detach();
        LanguageChangeSignatureDetector detector = (LanguageChangeSignatureDetector)LanguageChangeSignatureDetectors.INSTANCE.forLanguage(element.getLanguage());
        detector.performChange(currentInfo, editor2, initialSignature);
    }

    @Override
    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file2) {
        if (file2 == null) {
            ApplyChangeSignatureAction.$$$reportNull$$$0(6);
        }
        return file2;
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/changeSignature/inplace/ApplyChangeSignatureAction";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/changeSignature/inplace/ApplyChangeSignatureAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getElementToMakeWritable";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 2, 3, 4, 5, 6 -> new IllegalArgumentException(string2);
        };
    }
}

