/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature.inplace;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactoryRegistrar;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import com.intellij.refactoring.changeSignature.inplace.ApplyChangeSignatureAction;
import com.intellij.refactoring.changeSignature.inplace.InplaceChangeSignature;
import com.intellij.refactoring.changeSignature.inplace.LanguageChangeSignatureDetector;
import com.intellij.refactoring.changeSignature.inplace.LanguageChangeSignatureDetectors;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class ChangeSignaturePassFactory
implements TextEditorHighlightingPassFactory,
TextEditorHighlightingPassFactoryRegistrar {
    ChangeSignaturePassFactory() {
    }

    @Override
    public void registerHighlightingPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar, @NotNull Project project2) {
        if (registrar == null) {
            ChangeSignaturePassFactory.$$$reportNull$$$0(0);
        }
        if (project2 == null) {
            ChangeSignaturePassFactory.$$$reportNull$$$0(1);
        }
        registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, null, true, -1);
    }

    @Override
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file2, @NotNull Editor editor2) {
        LanguageChangeSignatureDetector detector;
        if (file2 == null) {
            ChangeSignaturePassFactory.$$$reportNull$$$0(2);
        }
        if (editor2 == null) {
            ChangeSignaturePassFactory.$$$reportNull$$$0(3);
        }
        if ((detector = (LanguageChangeSignatureDetector)LanguageChangeSignatureDetectors.INSTANCE.forLanguage(file2.getLanguage())) == null) {
            return null;
        }
        return new ChangeSignaturePass(file2.getProject(), file2, editor2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/changeSignature/inplace/ChangeSignaturePassFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerHighlightingPassFactory";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createHighlightingPass";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ChangeSignaturePass
    extends TextEditorHighlightingPass {
        private final PsiFile myFile;
        private final Editor myEditor;

        ChangeSignaturePass(Project project2, PsiFile file2, Editor editor2) {
            super(project2, editor2.getDocument(), true);
            this.myFile = file2;
            this.myEditor = editor2;
        }

        @Override
        public void doCollectInformation(@NotNull ProgressIndicator progress) {
            if (progress == null) {
                ChangeSignaturePass.$$$reportNull$$$0(0);
            }
        }

        @Override
        public void doApplyInformationToEditor() {
            HighlightInfo info2 = null;
            InplaceChangeSignature currentRefactoring = InplaceChangeSignature.getCurrentRefactoring(this.myEditor);
            if (currentRefactoring != null) {
                ChangeInfo changeInfo = currentRefactoring.getStableChange();
                PsiElement element = changeInfo.getMethod();
                int offset2 = this.myEditor.getCaretModel().getOffset();
                if (element == null || !element.isValid()) {
                    return;
                }
                TextRange elementTextRange = element.getTextRange();
                if (elementTextRange == null || !elementTextRange.contains(offset2)) {
                    return;
                }
                LanguageChangeSignatureDetector detector = (LanguageChangeSignatureDetector)LanguageChangeSignatureDetectors.INSTANCE.forLanguage(changeInfo.getLanguage());
                TextRange range = detector.getHighlightingRange(changeInfo);
                TextAttributes attributes = new TextAttributes(null, null, this.myEditor.getColorsScheme().getAttributes(CodeInsightColors.WEAK_WARNING_ATTRIBUTES).getEffectColor(), null, 0);
                HighlightInfo.Builder builder2 = HighlightInfo.newHighlightInfo(HighlightInfoType.INFORMATION).range(range);
                builder2.textAttributes(attributes);
                builder2.descriptionAndTooltip(RefactoringBundle.message((String)"text.signature.change.was.detected.highlight.tooltip"));
                ApplyChangeSignatureAction action2 = new ApplyChangeSignatureAction(currentRefactoring.getInitialName());
                builder2.registerFix(action2, null, null, null, null);
                info2 = builder2.createUnconditionally();
            }
            List<Object> infos = info2 != null ? Collections.singletonList(info2) : Collections.emptyList();
            UpdateHighlightersUtil.setHighlightersToEditor(this.myProject, this.myDocument, 0, this.myFile.getTextLength(), infos, this.getColorsScheme(), this.getId());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/refactoring/changeSignature/inplace/ChangeSignaturePassFactory$ChangeSignaturePass", "doCollectInformation"));
        }
    }
}

