/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.classMembers;

import com.intellij.psi.PsiElement;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractMemberInfoStorage<T extends PsiElement, C extends PsiElement, M extends MemberInfoBase<T>> {
    protected final Map<C, Set<C>> myClassToSubclassesMap = new ConcurrentHashMap<C, Set<C>>();
    private final Map<C, Set<C>> myTargetClassToExtendingMap = new ConcurrentHashMap<C, Set<C>>();
    private final Map<C, List<M>> myClassToMemberInfoMap = new ConcurrentHashMap<C, List<M>>();
    protected final C myClass;
    protected final MemberInfoBase.Filter<T> myFilter;
    private final Map<C, List<M>> myTargetClassToIntermediateMemberInfosMap = new ConcurrentHashMap<C, List<M>>();
    private final Map<C, LinkedHashSet<M>> myTargetClassToMemberInfosListMap = new ConcurrentHashMap<C, LinkedHashSet<M>>();
    private final Map<C, Set<M>> myTargetClassToDuplicatedMemberInfosMap = new ConcurrentHashMap<C, Set<M>>();

    public AbstractMemberInfoStorage(C aClass, MemberInfoBase.Filter<T> memberInfoFilter) {
        this.myClass = aClass;
        this.buildSubClassesMap(aClass);
        this.myFilter = memberInfoFilter;
    }

    private Set<C> getAllClasses() {
        return this.myClassToSubclassesMap.keySet();
    }

    public Set<C> getExtending(C baseClass) {
        Set<C> result2 = this.myTargetClassToExtendingMap.get(baseClass);
        if (result2 == null) {
            result2 = new HashSet<C>();
            result2.add(baseClass);
            Set<C> allClasses = this.getAllClasses();
            for (PsiElement aClass : allClasses) {
                if (!this.isInheritor(baseClass, aClass)) continue;
                result2.add(aClass);
            }
            this.myTargetClassToExtendingMap.put(baseClass, result2);
        }
        return result2;
    }

    protected abstract boolean isInheritor(C var1, C var2);

    protected abstract void buildSubClassesMap(C var1);

    public List<M> getClassMemberInfos(C aClass) {
        List<Object> result2 = this.myClassToMemberInfoMap.get(aClass);
        if (result2 == null) {
            ArrayList temp = new ArrayList();
            this.extractClassMembers(aClass, temp);
            result2 = Collections.unmodifiableList(temp);
            this.myClassToMemberInfoMap.put(aClass, result2);
        }
        return result2;
    }

    protected abstract void extractClassMembers(C var1, ArrayList<M> var2);

    public List<M> getIntermediateMemberInfosList(C baseClass) {
        List<M> result2 = this.myTargetClassToIntermediateMemberInfosMap.get(baseClass);
        if (result2 == null) {
            Set<M> list2 = this.getIntermediateClassesMemberInfosList(baseClass, new HashSet());
            result2 = Collections.unmodifiableList(new ArrayList<M>(list2));
            this.myTargetClassToIntermediateMemberInfosMap.put(baseClass, result2);
        }
        return result2;
    }

    private Set<M> getIntermediateClassesMemberInfosList(C targetClass, Set<? super C> visited) {
        LinkedHashSet<Object> result2 = this.myTargetClassToMemberInfosListMap.get(targetClass);
        if (result2 == null) {
            result2 = new LinkedHashSet();
            Set<C> subclasses = this.getSubclasses(targetClass);
            for (PsiElement subclass : subclasses) {
                List<M> memberInfos = this.getClassMemberInfos(subclass);
                result2.addAll(memberInfos);
            }
            for (PsiElement subclass : subclasses) {
                if (!visited.add(subclass)) continue;
                result2.addAll(this.getIntermediateClassesMemberInfosList(subclass, visited));
            }
            this.myTargetClassToMemberInfosListMap.put(targetClass, result2);
        }
        return result2;
    }

    protected Set<C> getSubclasses(C aClass) {
        return this.myClassToSubclassesMap.computeIfAbsent(aClass, k -> Collections.synchronizedSet(new LinkedHashSet()));
    }

    public Set<M> getDuplicatedMemberInfos(C baseClass) {
        return this.myTargetClassToDuplicatedMemberInfosMap.computeIfAbsent(baseClass, k -> this.buildDuplicatedMemberInfos(baseClass));
    }

    private Set<M> buildDuplicatedMemberInfos(C baseClass) {
        Set result2 = ContainerUtil.newConcurrentSet();
        List<M> memberInfos = this.getIntermediateMemberInfosList(baseClass);
        for (int i2 = 0; i2 < memberInfos.size(); ++i2) {
            MemberInfoBase memberInfo = (MemberInfoBase)memberInfos.get(i2);
            PsiElement member = memberInfo.getMember();
            for (int j = 0; j < i2; ++j) {
                MemberInfoBase memberInfo1 = (MemberInfoBase)memberInfos.get(j);
                PsiElement member1 = memberInfo1.getMember();
                if (!this.memberConflict(member1, member)) continue;
                result2.add(memberInfo);
            }
        }
        return result2;
    }

    protected abstract boolean memberConflict(T var1, T var2);
}

