/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.classMembers;

import com.intellij.lang.LanguageDependentMembersRefactoringSupport;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.ClassMembersRefactoringSupport;
import com.intellij.refactoring.classMembers.MemberDependenciesStorage;
import com.intellij.refactoring.classMembers.MemberDependencyGraph;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class UsedByMemberDependencyGraph<T extends NavigatablePsiElement, C extends PsiElement, M extends MemberInfoBase<T>>
implements MemberDependencyGraph<T, M> {
    private final HashSet<T> mySelectedNormal;
    private final HashSet<T> mySelectedAbstract;
    private final HashSet<T> myMembers;
    private HashSet<T> myDependencies = null;
    private HashMap<T, HashSet<T>> myDependenciesToDependent = null;
    private final MemberDependenciesStorage<T, C> myMemberDependenciesStorage;

    public UsedByMemberDependencyGraph(C aClass) {
        this.myMemberDependenciesStorage = new MemberDependenciesStorage(aClass, null);
        this.mySelectedNormal = new HashSet();
        this.mySelectedAbstract = new HashSet();
        this.myMembers = new HashSet();
    }

    @Override
    public synchronized void memberChanged(M memberInfo) {
        ClassMembersRefactoringSupport support = (ClassMembersRefactoringSupport)LanguageDependentMembersRefactoringSupport.INSTANCE.forLanguage(((NavigatablePsiElement)memberInfo.getMember()).getLanguage());
        if (support != null && support.isProperMember((MemberInfoBase)memberInfo)) {
            this.myDependencies = null;
            this.myDependenciesToDependent = null;
            NavigatablePsiElement member = (NavigatablePsiElement)memberInfo.getMember();
            this.myMembers.add(member);
            if (!memberInfo.isChecked()) {
                this.mySelectedNormal.remove(member);
                this.mySelectedAbstract.remove(member);
            } else if (memberInfo.isToAbstract()) {
                this.mySelectedNormal.remove(member);
                this.mySelectedAbstract.add(member);
            } else {
                this.mySelectedNormal.add(member);
                this.mySelectedAbstract.remove(member);
            }
        }
    }

    @Override
    public synchronized Set<? extends T> getDependent() {
        if (this.myDependencies == null) {
            HashSet<NavigatablePsiElement> dependencies = new HashSet<NavigatablePsiElement>();
            HashMap<NavigatablePsiElement, HashSet<NavigatablePsiElement>> dependenciesToDependent = new HashMap<NavigatablePsiElement, HashSet<NavigatablePsiElement>>();
            for (NavigatablePsiElement member : this.myMembers) {
                Set<NavigatablePsiElement> dependent = this.myMemberDependenciesStorage.getMemberDependencies(member);
                if (dependent == null) continue;
                for (NavigatablePsiElement aDependent : dependent) {
                    if (!this.mySelectedNormal.contains(aDependent) || this.mySelectedAbstract.contains(aDependent)) continue;
                    dependencies.add(member);
                    HashSet<NavigatablePsiElement> deps = (HashSet<NavigatablePsiElement>)dependenciesToDependent.get(member);
                    if (deps == null) {
                        deps = new HashSet<NavigatablePsiElement>();
                        dependenciesToDependent.put(member, deps);
                    }
                    deps.add(aDependent);
                }
            }
            this.myDependencies = dependencies;
            this.myDependenciesToDependent = dependenciesToDependent;
        }
        return this.myDependencies;
    }

    @Override
    public synchronized Set<? extends T> getDependenciesOf(T member) {
        Set<T> dependent = this.getDependent();
        if (!dependent.contains(member)) {
            return null;
        }
        return this.myDependenciesToDependent.get(member);
    }

    @NlsContexts.Tooltip
    public String getElementTooltip(T element) {
        Set<T> dependencies = this.getDependenciesOf(element);
        if (dependencies == null || dependencies.size() == 0) {
            return null;
        }
        ArrayList<String> strings2 = new ArrayList<String>();
        for (NavigatablePsiElement dep : dependencies) {
            if (!(dep instanceof PsiNamedElement)) continue;
            strings2.add(dep.getName());
        }
        if (strings2.isEmpty()) {
            return null;
        }
        return RefactoringBundle.message((String)"uses.0", (Object[])new Object[]{StringUtil.join(strings2, ", ")});
    }
}

