/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.classMembers;

import com.intellij.ide.nls.NlsMessages;
import com.intellij.lang.LanguageDependentMembersRefactoringSupport;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.ClassMembersRefactoringSupport;
import com.intellij.refactoring.classMembers.MemberDependenciesStorage;
import com.intellij.refactoring.classMembers.MemberDependencyGraph;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class UsesMemberDependencyGraph<T extends NavigatablePsiElement, C extends PsiElement, M extends MemberInfoBase<T>>
implements MemberDependencyGraph<T, M> {
    private static final Logger LOG = Logger.getInstance(UsesMemberDependencyGraph.class);
    private final HashSet<T> mySelectedNormal;
    private final HashSet<T> mySelectedAbstract;
    private HashSet<T> myDependencies = null;
    private HashMap<T, HashSet<T>> myDependenciesToDependentMap = null;
    private final boolean myRecursive;
    private final MemberDependenciesStorage<T, C> myMemberDependenciesStorage;

    public UsesMemberDependencyGraph(C aClass, C superClass, boolean recursive) {
        this.myRecursive = recursive;
        this.mySelectedNormal = new HashSet();
        this.mySelectedAbstract = new HashSet();
        this.myMemberDependenciesStorage = new MemberDependenciesStorage(aClass, superClass);
    }

    @Override
    public synchronized Set<? extends T> getDependent() {
        if (this.myDependencies == null) {
            HashSet dependencies = new HashSet();
            HashMap dependenciesToDependentMap = new HashMap();
            this.buildDeps(this.mySelectedNormal, dependencies, dependenciesToDependentMap);
            this.myDependencies = dependencies;
            this.myDependenciesToDependentMap = dependenciesToDependentMap;
        }
        return this.myDependencies;
    }

    @Override
    public synchronized Set<? extends T> getDependenciesOf(T member) {
        Set<T> dependent = this.getDependent();
        if (!dependent.contains(member)) {
            return null;
        }
        return this.myDependenciesToDependentMap.get(member);
    }

    @NlsContexts.Tooltip
    public String getElementTooltip(T element) {
        Set<T> dependencies = this.getDependenciesOf(element);
        if (dependencies == null || dependencies.size() == 0) {
            return null;
        }
        String strings2 = (String)dependencies.stream().map(NavigationItem::getName).collect(NlsMessages.joiningAnd());
        return RefactoringBundle.message((String)"used.by.0", (Object[])new Object[]{strings2});
    }

    private void buildDeps(Set<? extends T> members, HashSet<T> allDependencies, HashMap<T, HashSet<T>> dependenciesToDependentMap) {
        if (this.myRecursive) {
            this.buildDepsRecursively(null, members, this.myDependencies, this.myDependenciesToDependentMap);
        } else {
            for (NavigatablePsiElement member : members) {
                Set<NavigatablePsiElement> dependencies = this.myMemberDependenciesStorage.getMemberDependencies(member);
                if (dependencies == null) continue;
                for (NavigatablePsiElement dependency : dependencies) {
                    this.addDependency(dependency, member, allDependencies, dependenciesToDependentMap);
                }
            }
        }
    }

    private void buildDepsRecursively(T sourceElement, @Nullable Set<? extends T> members, HashSet<T> dependencies, HashMap<T, HashSet<T>> dependenciesToDependentMap) {
        if (members != null) {
            for (NavigatablePsiElement member : members) {
                if (dependencies.contains(member)) continue;
                this.addDependency(member, sourceElement, dependencies, dependenciesToDependentMap);
                if (this.mySelectedAbstract.contains(member)) continue;
                this.buildDepsRecursively(member, this.myMemberDependenciesStorage.getMemberDependencies(member), dependencies, dependenciesToDependentMap);
            }
        }
    }

    private void addDependency(T member, T sourceElement, HashSet<T> dependencies, HashMap<T, HashSet<T>> dependenciesToDependentMap) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(member.toString());
        }
        dependencies.add(member);
        if (sourceElement != null) {
            HashSet<Object> relations = dependenciesToDependentMap.get(member);
            if (relations == null) {
                relations = new HashSet();
                dependenciesToDependentMap.put(member, relations);
            }
            relations.add(sourceElement);
        }
    }

    @Override
    public synchronized void memberChanged(M memberInfo) {
        ClassMembersRefactoringSupport support = (ClassMembersRefactoringSupport)LanguageDependentMembersRefactoringSupport.INSTANCE.forLanguage(((NavigatablePsiElement)memberInfo.getMember()).getLanguage());
        if (support != null && support.isProperMember((MemberInfoBase)memberInfo)) {
            this.myDependencies = null;
            this.myDependenciesToDependentMap = null;
            NavigatablePsiElement member = (NavigatablePsiElement)memberInfo.getMember();
            if (!memberInfo.isChecked()) {
                this.mySelectedNormal.remove(member);
                this.mySelectedAbstract.remove(member);
            } else if (memberInfo.isToAbstract()) {
                this.mySelectedNormal.remove(member);
                this.mySelectedAbstract.add(member);
            } else {
                this.mySelectedNormal.add(member);
                this.mySelectedAbstract.remove(member);
            }
        }
    }
}

