/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.copy;

import com.intellij.CommonBundle;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.ide.CopyPasteDelegator;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.ide.util.EditorHelper;
import com.intellij.ide.util.PlatformPackageUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.impl.FileChooserUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingRegistry;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.psi.impl.file.PsiDirectoryImpl;
import com.intellij.psi.impl.file.UpdateAddedFileProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.SkipOverwriteChoice;
import com.intellij.refactoring.copy.CopyFilesOrDirectoriesDialog;
import com.intellij.refactoring.copy.CopyHandler;
import com.intellij.refactoring.copy.CopyHandlerDelegateBase;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopyFilesOrDirectoriesHandler
extends CopyHandlerDelegateBase {
    private static final Logger LOG = Logger.getInstance(CopyFilesOrDirectoriesHandler.class);

    @Override
    public boolean canCopy(PsiElement[] elements, boolean fromUpdate) {
        HashSet<String> names = new HashSet<String>();
        for (PsiElement element : elements) {
            if (!(element instanceof PsiDirectory) && !(element instanceof PsiFile)) {
                return false;
            }
            if (!element.isValid()) {
                return false;
            }
            if (element instanceof PsiCompiledFile) {
                return false;
            }
            String name = ((PsiFileSystemItem)element).getName();
            if (names.contains(name)) {
                return false;
            }
            names.add(name);
        }
        if (fromUpdate) {
            return elements.length > 0;
        }
        PsiElement[] filteredElements = PsiTreeUtil.filterAncestors(elements);
        return filteredElements.length == elements.length;
    }

    @Override
    public void doCopy(PsiElement[] elements, PsiDirectory defaultTargetDirectory) {
        Project project2;
        PsiDirectory commonParent;
        if (defaultTargetDirectory == null && (commonParent = CopyFilesOrDirectoriesHandler.getCommonParentDirectory(elements)) != null && !ScratchUtil.isScratch(commonParent.getVirtualFile())) {
            defaultTargetDirectory = commonParent;
        }
        Project project3 = project2 = defaultTargetDirectory != null ? defaultTargetDirectory.getProject() : elements[0].getProject();
        if (defaultTargetDirectory != null && (defaultTargetDirectory = CopyFilesOrDirectoriesHandler.resolveDirectory(defaultTargetDirectory)) == null) {
            return;
        }
        defaultTargetDirectory = CopyFilesOrDirectoriesHandler.tryNotNullizeDirectory(project2, defaultTargetDirectory);
        CopyFilesOrDirectoriesHandler.copyAsFiles(elements, defaultTargetDirectory, project2);
    }

    @Nullable
    private static PsiDirectory tryNotNullizeDirectory(@NotNull Project project2, @Nullable PsiDirectory defaultTargetDirectory) {
        if (project2 == null) {
            CopyFilesOrDirectoriesHandler.$$$reportNull$$$0(0);
        }
        if (defaultTargetDirectory == null) {
            VirtualFile root = FileChooserUtil.getLastOpenedFile((Project)project2);
            if (root == null) {
                VirtualFile virtualFile2 = root = project2.isDefault() ? null : ProjectUtil.guessProjectDir((Project)project2);
            }
            if (root == null) {
                root = VfsUtil.getUserHomeDir();
            }
            PsiDirectory psiDirectory = root == null ? null : (defaultTargetDirectory = root.isDirectory() ? PsiManager.getInstance(project2).findDirectory(root) : PsiManager.getInstance(project2).findDirectory(root.getParent()));
            if (defaultTargetDirectory == null) {
                LOG.warn("No directory found for project: " + project2.getName() + ", root: " + root);
            }
        }
        return defaultTargetDirectory;
    }

    public static void copyAsFiles(PsiElement[] elements, @Nullable PsiDirectory defaultTargetDirectory, Project project2) {
        CopyFilesOrDirectoriesHandler.doCopyAsFiles(elements, defaultTargetDirectory, project2);
    }

    private static void doCopyAsFiles(PsiElement[] elements, @Nullable PsiDirectory defaultTargetDirectory, Project project2) {
        boolean openInEditor;
        String newName2;
        PsiDirectory targetDirectory;
        VirtualFile[] files2 = (VirtualFile[])Arrays.stream(elements).map(el -> ((PsiFileSystemItem)el).getVirtualFile()).toArray(VirtualFile[]::new);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            targetDirectory = defaultTargetDirectory;
            newName2 = null;
            openInEditor = true;
        } else {
            CopyFilesOrDirectoriesDialog dialog = new CopyFilesOrDirectoriesDialog(elements, defaultTargetDirectory, project2, false);
            if (dialog.showAndGet()) {
                newName2 = elements.length == 1 ? dialog.getNewName() : null;
                targetDirectory = dialog.getTargetDirectory();
                openInEditor = dialog.isOpenInEditor();
            } else {
                return;
            }
        }
        if (targetDirectory != null) {
            PsiManager manager = PsiManager.getInstance(project2);
            try {
                for (VirtualFile file2 : files2) {
                    if (!file2.isDirectory()) continue;
                    PsiDirectory psiElement = manager.findDirectory(file2);
                    MoveFilesOrDirectoriesUtil.checkIfMoveIntoSelf(psiElement, targetDirectory);
                }
            }
            catch (IncorrectOperationException e) {
                CommonRefactoringUtil.showErrorHint((Project)project2, null, (String)e.getMessage(), (String)CommonBundle.getErrorTitle(), null);
                return;
            }
            CommandProcessor.getInstance().executeCommand(project2, () -> CopyFilesOrDirectoriesHandler.copyImpl(files2, newName2, targetDirectory, false, openInEditor), RefactoringBundle.message((String)"copy.handler.copy.files.directories"), null);
        }
    }

    @Override
    public void doClone(PsiElement element) {
        CopyFilesOrDirectoriesHandler.doCloneFile(element);
    }

    public static void doCloneFile(PsiElement element) {
        PsiDirectory targetDirectory = element instanceof PsiDirectory ? ((PsiDirectory)element).getParentDirectory() : PlatformPackageUtil.getDirectory(element);
        targetDirectory = CopyFilesOrDirectoriesHandler.tryNotNullizeDirectory(element.getProject(), targetDirectory);
        if (targetDirectory == null) {
            return;
        }
        PsiElement[] elements = new PsiElement[]{element};
        VirtualFile file2 = ((PsiFileSystemItem)element).getVirtualFile();
        CopyFilesOrDirectoriesDialog dialog = new CopyFilesOrDirectoriesDialog(elements, null, element.getProject(), true);
        if (dialog.showAndGet()) {
            String newName2 = dialog.getNewName();
            CopyFilesOrDirectoriesHandler.copyImpl(new VirtualFile[]{file2}, newName2, targetDirectory, true, true);
        }
    }

    @Nullable
    private static PsiDirectory getCommonParentDirectory(PsiElement[] elements) {
        PsiDirectory result2 = null;
        for (PsiElement element : elements) {
            PsiDirectory directory;
            if (element instanceof PsiDirectory) {
                directory = (PsiDirectory)element;
                directory = directory.getParentDirectory();
            } else if (element instanceof PsiFile) {
                directory = PlatformPackageUtil.getDirectory(element);
            } else {
                throw new IllegalArgumentException("unexpected element " + element);
            }
            if (directory == null) continue;
            if (result2 == null) {
                result2 = directory;
                continue;
            }
            if (!PsiTreeUtil.isAncestor(directory, result2, true)) continue;
            result2 = directory;
        }
        return result2;
    }

    private static void copyImpl(VirtualFile @NotNull [] files2, @Nullable String newName2, @NotNull PsiDirectory targetDirectory, boolean doClone, boolean openInEditor) {
        if (targetDirectory == null) {
            CopyFilesOrDirectoriesHandler.$$$reportNull$$$0(1);
        }
        if (files2 == null) {
            CopyFilesOrDirectoriesHandler.$$$reportNull$$$0(2);
        }
        if (doClone && files2.length != 1) {
            throw new IllegalArgumentException("invalid number of elements to clone:" + files2.length);
        }
        if (newName2 != null && files2.length != 1) {
            throw new IllegalArgumentException("no new name should be set; number of elements is: " + files2.length);
        }
        Project project2 = targetDirectory.getProject();
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project2, Collections.singleton(targetDirectory), (boolean)true)) {
            return;
        }
        String title = RefactoringBundle.message((String)(doClone ? "copy.handler.clone.files.directories" : "copy.handler.copy.files.directories"));
        try {
            int[] nArray;
            if (files2.length > 1 || files2[0].isDirectory()) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = -1;
            } else {
                nArray = null;
            }
            int[] choice = nArray;
            ArrayList added = new ArrayList();
            PsiManager manager = PsiManager.getInstance(project2);
            ArrayList<PsiDirectory> items2 = new ArrayList<PsiDirectory>(files2.length);
            for (VirtualFile file2 : files2) {
                PsiFileSystemItem item;
                PsiFileSystemItem psiFileSystemItem = item = file2.isDirectory() ? manager.findDirectory(file2) : manager.findFile(file2);
                if (item == null) {
                    LOG.info("invalid file: " + file2.getExtension());
                    continue;
                }
                items2.add((PsiDirectory)item);
            }
            CopyFilesOrDirectoriesHandler.copyToDirectory(items2, newName2, targetDirectory, choice, title, added);
            if (!added.isEmpty()) {
                DumbService.getInstance(project2).completeJustSubmittedTasks();
                CopyFilesOrDirectoriesHandler.updateAddedFiles(added);
                if (openInEditor) {
                    PsiFile firstFile = (PsiFile)added.get(0);
                    CopyHandler.updateSelectionInActiveProjectView(firstFile, project2, doClone);
                    if (!(firstFile instanceof PsiBinaryFile)) {
                        EditorHelper.openInEditor(firstFile, true, true);
                    }
                }
            }
        }
        catch (IncorrectOperationException | IOException ex) {
            Messages.showErrorDialog((Project)project2, (String)ex.getMessage(), (String)RefactoringBundle.message((String)"error.title"));
        }
    }

    public static void updateAddedFiles(List<? extends PsiFile> added) {
        if (added.isEmpty()) {
            return;
        }
        Project project2 = added.get(0).getProject();
        if (Registry.is("run.refactorings.under.progress")) {
            ApplicationManagerEx.getApplicationEx().runWriteActionWithNonCancellableProgressInDispatchThread(RefactoringBundle.message((String)"progress.title.update.added.files"), project2, null, pi -> UpdateAddedFileProcessor.updateAddedFiles(added));
        } else {
            WriteAction.run(() -> UpdateAddedFileProcessor.updateAddedFiles(added));
        }
    }

    @Nullable
    public static PsiFile copyToDirectory(@NotNull PsiFileSystemItem elementToCopy, @Nullable String newName2, @NotNull PsiDirectory targetDirectory) throws IncorrectOperationException, IOException {
        if (elementToCopy == null) {
            CopyFilesOrDirectoriesHandler.$$$reportNull$$$0(3);
        }
        if (targetDirectory == null) {
            CopyFilesOrDirectoriesHandler.$$$reportNull$$$0(4);
        }
        return CopyFilesOrDirectoriesHandler.copyToDirectory(elementToCopy, newName2, targetDirectory, null, null);
    }

    @Nullable
    public static PsiFile copyToDirectory(@NotNull PsiFileSystemItem elementToCopy, @Nullable String newName2, @NotNull PsiDirectory targetDirectory, int @Nullable [] choice, @Nullable @NlsContexts.Command String title) throws IncorrectOperationException, IOException {
        if (elementToCopy == null) {
            CopyFilesOrDirectoriesHandler.$$$reportNull$$$0(5);
        }
        if (targetDirectory == null) {
            CopyFilesOrDirectoriesHandler.$$$reportNull$$$0(6);
        }
        ArrayList added = new ArrayList();
        CopyFilesOrDirectoriesHandler.copyToDirectory(Collections.singletonList(elementToCopy), newName2, targetDirectory, choice, title, added);
        if (added.isEmpty()) {
            return null;
        }
        DumbService.getInstance(elementToCopy.getProject()).completeJustSubmittedTasks();
        CopyFilesOrDirectoriesHandler.updateAddedFiles(added);
        return (PsiFile)added.get(0);
    }

    private static void copyToDirectory(List<? extends PsiFileSystemItem> elementsToCopy, @Nullable String newName2, @NotNull PsiDirectory targetDirectory, int @Nullable [] choice, @Nullable @NlsContexts.Command String title, @NotNull List<? super PsiFile> added) throws IncorrectOperationException, IOException {
        if (targetDirectory == null) {
            CopyFilesOrDirectoriesHandler.$$$reportNull$$$0(7);
        }
        if (added == null) {
            CopyFilesOrDirectoriesHandler.$$$reportNull$$$0(8);
        }
        MultiMap<PsiDirectory, PsiFile> existingFiles = new MultiMap<PsiDirectory, PsiFile>();
        ApplicationEx app = ApplicationManagerEx.getApplicationEx();
        if (Registry.is("run.refactorings.under.progress")) {
            AtomicReference thrown = new AtomicReference();
            Consumer<ProgressIndicator> copyAction = pi -> {
                try {
                    for (PsiFileSystemItem elementToCopy : elementsToCopy) {
                        CopyFilesOrDirectoriesHandler.copyToDirectoryUnderProgress(elementToCopy, newName2, targetDirectory, added, existingFiles, pi);
                    }
                }
                catch (Throwable e) {
                    thrown.set(e);
                }
            };
            CommandProcessor.getInstance().executeCommand(targetDirectory.getProject(), () -> app.runWriteActionWithCancellableProgressInDispatchThread(ObjectUtils.notNull(title, RefactoringBundle.message((String)"command.name.copy")), targetDirectory.getProject(), null, copyAction), title, null);
            Throwable throwable = (Throwable)thrown.get();
            if (throwable instanceof ProcessCanceledException) {
                return;
            }
            CopyFilesOrDirectoriesHandler.rethrow(throwable);
        } else {
            WriteCommandAction.writeCommandAction(targetDirectory.getProject()).withName(title).run(() -> {
                for (PsiFileSystemItem elementToCopy : elementsToCopy) {
                    CopyFilesOrDirectoriesHandler.copyToDirectoryUnderProgress(elementToCopy, newName2, targetDirectory, added, existingFiles, null);
                }
            });
        }
        CopyFilesOrDirectoriesHandler.handleExistingFiles(newName2, targetDirectory, choice, title, existingFiles, added);
    }

    private static void rethrow(Throwable throwable) throws IOException {
        if (throwable instanceof IOException) {
            throw (IOException)throwable;
        }
        if (throwable instanceof IncorrectOperationException) {
            throw (IncorrectOperationException)throwable;
        }
        if (throwable != null) {
            throw new IncorrectOperationException(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleExistingFiles(String newName2, PsiDirectory targetDirectory, int @Nullable [] choice, @NlsContexts.DialogTitle String title, @NotNull MultiMap<PsiDirectory, PsiFile> existingFiles, @NotNull List<? super PsiFile> added) {
        if (existingFiles == null) {
            CopyFilesOrDirectoriesHandler.$$$reportNull$$$0(9);
        }
        if (added == null) {
            CopyFilesOrDirectoriesHandler.$$$reportNull$$$0(10);
        }
        SkipOverwriteChoice defaultChoice = choice != null && choice[0] > -1 ? SkipOverwriteChoice.values()[choice[0]] : null;
        try {
            defaultChoice = CopyFilesOrDirectoriesHandler.handleExistingFiles(defaultChoice, choice, newName2, targetDirectory, title, existingFiles, added, null);
        }
        finally {
            if (choice != null && defaultChoice != null) {
                choice[0] = defaultChoice.ordinal() % 2;
            }
        }
    }

    private static SkipOverwriteChoice handleExistingFiles(SkipOverwriteChoice defaultChoice, int @Nullable [] choice, String newName2, PsiDirectory targetDirectory, @NlsContexts.DialogTitle String title, @NotNull MultiMap<PsiDirectory, PsiFile> existingFiles, @NotNull List<? super PsiFile> added, ProgressIndicator progressIndicator) {
        if (existingFiles == null) {
            CopyFilesOrDirectoriesHandler.$$$reportNull$$$0(11);
        }
        if (added == null) {
            CopyFilesOrDirectoriesHandler.$$$reportNull$$$0(12);
        }
        for (PsiDirectory tDirectory : existingFiles.keySet()) {
            Collection<PsiFile> replacementFiles = existingFiles.get(tDirectory);
            Iterator<PsiFile> iterator2 = replacementFiles.iterator();
            while (iterator2.hasNext()) {
                PsiFile replacement = iterator2.next();
                String name = newName2 == null || tDirectory != targetDirectory ? replacement.getName() : newName2;
                PsiFile existing = tDirectory.findFile(name);
                if (existing == null) continue;
                SkipOverwriteChoice userChoice = defaultChoice;
                Project project2 = targetDirectory.getProject();
                if (userChoice == null) {
                    userChoice = SkipOverwriteChoice.askUser(targetDirectory, name, title, choice != null);
                    if (userChoice == SkipOverwriteChoice.SKIP_ALL) {
                        return userChoice;
                    }
                    if (userChoice == SkipOverwriteChoice.OVERWRITE_ALL) {
                        Consumer<ProgressIndicator> r = pi -> CopyFilesOrDirectoriesHandler.handleExistingFiles(SkipOverwriteChoice.OVERWRITE_ALL, choice, newName2, targetDirectory, title, existingFiles, added, pi);
                        if (Registry.is("run.refactorings.under.progress")) {
                            CommandProcessor.getInstance().executeCommand(project2, () -> ApplicationManagerEx.getApplicationEx().runWriteActionWithCancellableProgressInDispatchThread(title, project2, null, r), title, null);
                        } else {
                            r.accept(null);
                        }
                        return SkipOverwriteChoice.OVERWRITE_ALL;
                    }
                }
                iterator2.remove();
                ThrowableRunnable doCopy = () -> {
                    if (progressIndicator != null) {
                        progressIndicator.setText2(InspectionsBundle.message("processing.progress.text", existing.getName()));
                    }
                    existing.delete();
                    ((PsiDirectoryImpl)targetDirectory).executeWithUpdatingAddedFilesDisabled(() -> ContainerUtil.addIfNotNull(added, tDirectory.copyFileFrom(name, replacement)));
                };
                if (userChoice == SkipOverwriteChoice.OVERWRITE || userChoice == SkipOverwriteChoice.OVERWRITE_ALL && !Registry.is("run.refactorings.under.progress")) {
                    WriteCommandAction.writeCommandAction(project2).withName(title).run(doCopy);
                    continue;
                }
                if (userChoice != SkipOverwriteChoice.OVERWRITE_ALL) continue;
                doCopy.run();
            }
        }
        return defaultChoice;
    }

    private static void copyToDirectoryUnderProgress(PsiFileSystemItem elementToCopy, @Nullable String newName2, @NotNull PsiDirectory targetDirectory, @NotNull List<? super PsiFile> added, MultiMap<PsiDirectory, PsiFile> existingFiles, @Nullable ProgressIndicator pi) throws IncorrectOperationException, IOException {
        if (targetDirectory == null) {
            CopyFilesOrDirectoriesHandler.$$$reportNull$$$0(13);
        }
        if (added == null) {
            CopyFilesOrDirectoriesHandler.$$$reportNull$$$0(14);
        }
        if (pi != null) {
            pi.setText2(InspectionsBundle.message("processing.progress.text", elementToCopy.getName()));
        }
        if (elementToCopy instanceof PsiFile) {
            PsiFile file2 = (PsiFile)elementToCopy;
            String name = newName2 == null ? file2.getName() : newName2;
            PsiFile existing = targetDirectory.findFile(name);
            if (existing != null && !existing.equals(file2)) {
                existingFiles.putValue(targetDirectory, file2);
                return;
            }
            ((PsiDirectoryImpl)targetDirectory).executeWithUpdatingAddedFilesDisabled(() -> ContainerUtil.addIfNotNull(added, targetDirectory.copyFileFrom(name, file2)));
        } else if (elementToCopy instanceof PsiDirectory) {
            PsiDirectory existing;
            PsiDirectory directory = (PsiDirectory)elementToCopy;
            if (directory.equals(targetDirectory)) {
                return;
            }
            if (newName2 == null) {
                newName2 = directory.getName();
            }
            PsiDirectory subdirectory = (existing = targetDirectory.findSubdirectory(newName2)) == null ? targetDirectory.createSubdirectory(newName2) : existing;
            EncodingRegistry.doActionAndRestoreEncoding(directory.getVirtualFile(), () -> subdirectory.getVirtualFile());
            VirtualFile[] children2 = directory.getVirtualFile().getChildren();
            Project project2 = subdirectory.getProject();
            PsiManager manager = PsiManager.getInstance(project2);
            for (VirtualFile file3 : children2) {
                PsiFileSystemItem item;
                PsiFileSystemItem psiFileSystemItem = item = file3.isDirectory() ? manager.findDirectory(file3) : manager.findFile(file3);
                if (item == null) {
                    LOG.info("invalid file: " + file3.getExtension());
                    continue;
                }
                CopyFilesOrDirectoriesHandler.copyToDirectoryUnderProgress(item, null, subdirectory, added, existingFiles, pi);
            }
        } else {
            throw new IllegalArgumentException("unexpected elementToCopy: " + elementToCopy);
        }
    }

    public static boolean checkFileExist(@Nullable PsiDirectory targetDirectory, int[] choice, PsiFile file2, @NlsSafe String name, @NlsContexts.Command String title) {
        if (targetDirectory == null) {
            return false;
        }
        PsiFile existing = targetDirectory.findFile(name);
        if (existing != null && !existing.equals(file2)) {
            int selection = choice == null || choice[0] == -1 ? SkipOverwriteChoice.askUser(targetDirectory, name, title, choice != null).ordinal() : choice[0];
            if (choice != null && selection > 1) {
                choice[0] = selection % 2;
                selection = choice[0];
            }
            if (selection == 0) {
                WriteCommandAction.writeCommandAction(targetDirectory.getProject()).withName(title).run(() -> existing.delete());
            } else {
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static PsiDirectory resolveDirectory(@NotNull PsiDirectory defaultTargetDirectory) {
        if (defaultTargetDirectory == null) {
            CopyFilesOrDirectoriesHandler.$$$reportNull$$$0(15);
        }
        Project project2 = defaultTargetDirectory.getProject();
        Boolean showDirsChooser = defaultTargetDirectory.getCopyableUserData(CopyPasteDelegator.SHOW_CHOOSER_KEY);
        if (showDirsChooser != null && showDirsChooser.booleanValue()) {
            PsiDirectoryContainer directoryContainer = PsiDirectoryFactory.getInstance(project2).getDirectoryContainer(defaultTargetDirectory);
            if (directoryContainer == null) {
                return defaultTargetDirectory;
            }
            return MoveFilesOrDirectoriesUtil.resolveToDirectory(project2, directoryContainer);
        }
        return defaultTargetDirectory;
    }

    @Override
    @Nullable
    public String getActionName(PsiElement[] elements) {
        int fileCount = 0;
        int directoryCount = 0;
        for (PsiElement element : elements) {
            if (element instanceof PsiFile) {
                ++fileCount;
                continue;
            }
            if (!(element instanceof PsiDirectory)) continue;
            ++directoryCount;
        }
        if (directoryCount == 0) {
            return fileCount == 1 ? RefactoringBundle.message((String)"copy.file") : RefactoringBundle.message((String)"copy.files");
        }
        if (fileCount == 0) {
            return directoryCount == 1 ? RefactoringBundle.message((String)"copy.directory") : RefactoringBundle.message((String)"copy.directories");
        }
        return RefactoringBundle.message((String)"copy.files.and.directories");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDirectory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToCopy";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "added";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingFiles";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultTargetDirectory";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/copy/CopyFilesOrDirectoriesHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "tryNotNullizeDirectory";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "copyImpl";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "copyToDirectory";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "handleExistingFiles";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "copyToDirectoryUnderProgress";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveDirectory";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

