/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.copy;

import com.intellij.ide.TwoPaneIdeView;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.structureView.StructureViewFactoryEx;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.copy.CopyHandlerDelegate;
import com.intellij.refactoring.copy.CopyHandlerDelegateBase;
import com.intellij.ui.content.Content;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CopyHandler {
    private CopyHandler() {
    }

    public static boolean canCopy(PsiElement[] elements) {
        return CopyHandler.canCopy(elements, null);
    }

    public static boolean canCopy(PsiElement[] elements, @Nullable Ref<? super @NlsActions.ActionText String> actionName) {
        if (elements.length > 0) {
            for (CopyHandlerDelegate delegate2 : CopyHandlerDelegate.EP_NAME.getExtensionList()) {
                if (!(delegate2 instanceof CopyHandlerDelegateBase ? ((CopyHandlerDelegateBase)delegate2).canCopy(elements, true) : delegate2.canCopy(elements))) continue;
                if (actionName != null) {
                    actionName.set(delegate2.getActionName(elements));
                }
                return true;
            }
        }
        return false;
    }

    public static void doCopy(PsiElement[] elements, PsiDirectory defaultTargetDirectory) {
        if (elements.length == 0) {
            return;
        }
        for (CopyHandlerDelegate delegate2 : CopyHandlerDelegate.EP_NAME.getExtensionList()) {
            if (!delegate2.canCopy(elements)) continue;
            delegate2.doCopy(elements, defaultTargetDirectory);
            break;
        }
    }

    public static boolean canClone(PsiElement[] elements) {
        if (elements.length > 0) {
            for (CopyHandlerDelegate delegate2 : CopyHandlerDelegate.EP_NAME.getExtensionList()) {
                if (!(delegate2 instanceof CopyHandlerDelegateBase ? ((CopyHandlerDelegateBase)delegate2).canCopy(elements, true) : delegate2.canCopy(elements))) continue;
                return !(delegate2 instanceof CopyHandlerDelegateBase) || !((CopyHandlerDelegateBase)delegate2).forbidToClone(elements, true);
            }
        }
        return false;
    }

    public static void doClone(PsiElement element) {
        PsiElement[] elements = new PsiElement[]{element};
        for (CopyHandlerDelegate delegate2 : CopyHandlerDelegate.EP_NAME.getExtensionList()) {
            if (!delegate2.canCopy(elements)) continue;
            if (delegate2 instanceof CopyHandlerDelegateBase && ((CopyHandlerDelegateBase)delegate2).forbidToClone(elements, false)) {
                return;
            }
            delegate2.doClone(element);
            break;
        }
    }

    public static void updateSelectionInActiveProjectView(@NotNull PsiElement newElement, Project project2, boolean selectInActivePanel) {
        JComponent component2;
        ToolWindow window;
        Content selectedContent;
        String id;
        if (newElement == null) {
            CopyHandler.$$$reportNull$$$0(0);
        }
        if ((id = ToolWindowManager.getInstance((Project)project2).getActiveToolWindowId()) != null && (selectedContent = (window = ToolWindowManager.getInstance((Project)project2).getToolWindow(id)).getContentManager().getSelectedContent()) != null && (component2 = selectedContent.getComponent()) instanceof TwoPaneIdeView) {
            ((TwoPaneIdeView)((Object)component2)).selectElement(newElement, selectInActivePanel);
            return;
        }
        if ("Project".equals(id)) {
            ProjectView.getInstance(project2).selectPsiElement(newElement, true);
        } else if ("Structure".equals(id)) {
            VirtualFile virtualFile2 = newElement.getContainingFile().getVirtualFile();
            FileEditor editor2 = FileEditorManager.getInstance(newElement.getProject()).getSelectedEditor(virtualFile2);
            StructureViewFactoryEx.getInstanceEx((Project)project2).getStructureViewWrapper().selectCurrentElement(editor2, virtualFile2, true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/refactoring/copy/CopyHandler", "updateSelectionInActiveProjectView"));
    }
}

