/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractSuperclass;

import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.ui.DocCommentPanel;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.RecentsManager;
import com.intellij.util.IncorrectOperationException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ExtractSuperBaseDialog<ClassType extends PsiElement, MemberInfoType extends MemberInfoBase>
extends RefactoringDialog {
    @NlsContexts.DialogTitle
    private final String myRefactoringName;
    protected final ClassType mySourceClass;
    protected PsiDirectory myTargetDirectory;
    protected final List<MemberInfoType> myMemberInfos;
    private JRadioButton myRbExtractSuperclass;
    private JRadioButton myRbExtractSubclass;
    private JTextField mySourceClassField;
    private JLabel myClassNameLabel;
    private JTextField myExtractedSuperNameField;
    protected JLabel myPackageNameLabel;
    protected ComponentWithBrowseButton myPackageNameField;
    protected DocCommentPanel myDocCommentPanel;
    private JPanel myDestinationRootPanel;

    protected abstract ComponentWithBrowseButton createPackageNameField();

    protected JPanel createDestinationRootPanel() {
        return null;
    }

    protected abstract JTextField createSourceClassField();

    @NlsContexts.BorderTitle
    protected abstract String getDocCommentPanelName();

    protected abstract String getExtractedSuperNameNotSpecifiedMessage();

    protected abstract BaseRefactoringProcessor createProcessor();

    protected abstract int getDocCommentPolicySetting();

    protected abstract void setDocCommentPolicySetting(int var1);

    @Nullable
    protected abstract String validateName(String var1);

    @Nullable
    @NlsContexts.DialogMessage
    protected String validateQualifiedName(String packageName, @NotNull String extractedSuperName) {
        if (extractedSuperName == null) {
            ExtractSuperBaseDialog.$$$reportNull$$$0(0);
        }
        return null;
    }

    @NlsContexts.Label
    protected abstract String getTopLabelText();

    @NlsContexts.Label
    protected abstract String getClassNameLabelText();

    @NlsContexts.Label
    protected abstract String getPackageNameLabelText();

    @NotNull
    protected abstract String getEntityName();

    protected abstract void preparePackage() throws OperationFailedException;

    protected abstract String getDestinationPackageRecentKey();

    public ExtractSuperBaseDialog(Project project2, ClassType sourceClass, List<MemberInfoType> members, @NlsContexts.DialogTitle String refactoringName) {
        super(project2, true);
        this.myRefactoringName = refactoringName;
        this.mySourceClass = sourceClass;
        this.myMemberInfos = members;
        this.myTargetDirectory = this.mySourceClass.getContainingFile().getContainingDirectory();
    }

    protected void init() {
        this.setTitle(this.myRefactoringName);
        this.myPackageNameField = this.createPackageNameField();
        this.myDestinationRootPanel = this.createDestinationRootPanel();
        this.mySourceClassField = this.createSourceClassField();
        this.myExtractedSuperNameField = this.createExtractedSuperNameField();
        this.myDocCommentPanel = new DocCommentPanel(this.getDocCommentPanelName());
        this.myDocCommentPanel.setPolicy(this.getDocCommentPolicySetting());
        super.init();
        this.updateDialog();
    }

    protected JTextField createExtractedSuperNameField() {
        return new JTextField();
    }

    protected JComponent createActionComponent() {
        Box box2 = Box.createHorizontalBox();
        String s = StringUtil.decapitalize(this.getEntityName());
        this.myRbExtractSuperclass = new JRadioButton();
        this.myRbExtractSuperclass.setText(RefactoringBundle.message((String)"extractSuper.extract", (Object[])new Object[]{s}));
        this.myRbExtractSubclass = new JRadioButton();
        this.myRbExtractSubclass.setText(RefactoringBundle.message((String)"extractSuper.rename.original.class", (Object[])new Object[]{s}));
        this.myRbExtractSubclass.setEnabled(this.isPossibleToRenameOriginal());
        box2.add(this.myRbExtractSuperclass);
        box2.add(this.myRbExtractSubclass);
        box2.add(Box.createHorizontalGlue());
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.myRbExtractSuperclass);
        buttonGroup.add(this.myRbExtractSubclass);
        this.customizeRadiobuttons(box2, buttonGroup);
        this.myRbExtractSuperclass.setSelected(true);
        ItemListener listener2 = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ExtractSuperBaseDialog.this.updateDialog();
            }
        };
        this.myRbExtractSuperclass.addItemListener(listener2);
        this.myRbExtractSubclass.addItemListener(listener2);
        return box2;
    }

    protected boolean isPossibleToRenameOriginal() {
        return true;
    }

    protected void customizeRadiobuttons(Box box2, ButtonGroup buttonGroup) {
    }

    protected JComponent createNorthPanel() {
        Box box2 = Box.createVerticalBox();
        JPanel _panel = new JPanel(new BorderLayout());
        _panel.add((Component)new JLabel(this.getTopLabelText()), "North");
        _panel.add((Component)this.mySourceClassField, "Center");
        box2.add(_panel);
        box2.add(Box.createVerticalStrut(10));
        box2.add(this.createActionComponent());
        box2.add(Box.createVerticalStrut(10));
        this.myClassNameLabel = new JLabel();
        _panel = new JPanel(new BorderLayout());
        _panel.add((Component)this.myClassNameLabel, "North");
        _panel.add((Component)this.myExtractedSuperNameField, "Center");
        box2.add(_panel);
        box2.add(Box.createVerticalStrut(5));
        _panel = new JPanel(new BorderLayout());
        this.myPackageNameLabel = new JLabel();
        _panel.add((Component)this.myPackageNameLabel, "North");
        _panel.add((Component)this.myPackageNameField, "Center");
        if (this.myDestinationRootPanel != null) {
            _panel.add((Component)this.myDestinationRootPanel, "South");
        }
        box2.add(_panel);
        box2.add(Box.createVerticalStrut(10));
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)box2, "Center");
        return panel2;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myExtractedSuperNameField;
    }

    protected void updateDialog() {
        this.myClassNameLabel.setText(this.getClassNameLabelText());
        this.myPackageNameLabel.setText(this.getPackageNameLabelText());
        this.getPreviewAction().setEnabled(!this.isExtractSuperclass());
    }

    @NotNull
    public String getExtractedSuperName() {
        String string2 = this.myExtractedSuperNameField.getText().trim();
        if (string2 == null) {
            ExtractSuperBaseDialog.$$$reportNull$$$0(1);
        }
        return string2;
    }

    protected abstract String getTargetPackageName();

    public PsiDirectory getTargetDirectory() {
        return this.myTargetDirectory;
    }

    public int getDocCommentPolicy() {
        return this.myDocCommentPanel.getPolicy();
    }

    public boolean isExtractSuperclass() {
        return this.myRbExtractSuperclass != null && this.myRbExtractSuperclass.isSelected();
    }

    @Override
    protected void doAction() {
        String[] errorString = new String[]{null};
        String extractedSuperName = this.getExtractedSuperName();
        String packageName = this.getTargetPackageName();
        RecentsManager.getInstance((Project)this.myProject).registerRecentEntry(this.getDestinationPackageRecentKey(), packageName);
        if (extractedSuperName.isEmpty()) {
            errorString[0] = this.getExtractedSuperNameNotSpecifiedMessage();
            this.myExtractedSuperNameField.requestFocusInWindow();
        } else {
            String nameError = this.validateName(extractedSuperName);
            if (nameError == null) {
                nameError = this.validateQualifiedName(packageName, extractedSuperName);
            }
            if (nameError != null) {
                errorString[0] = nameError;
                this.myExtractedSuperNameField.requestFocusInWindow();
            } else {
                CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
                    try {
                        this.preparePackage();
                    }
                    catch (OperationFailedException | IncorrectOperationException e) {
                        errorString[0] = e.getMessage();
                        this.myPackageNameField.requestFocusInWindow();
                    }
                }, RefactoringBundle.message((String)"create.directory"), null);
            }
        }
        if (errorString[0] != null) {
            if (errorString[0].length() > 0) {
                CommonRefactoringUtil.showErrorMessage((String)this.myRefactoringName, (String)errorString[0], (String)this.getHelpId(), (Project)this.myProject);
            }
            return;
        }
        if (!this.checkConflicts()) {
            return;
        }
        this.executeRefactoring();
        this.setDocCommentPolicySetting(this.getDocCommentPolicy());
        this.closeOKAction();
    }

    protected void executeRefactoring() {
        if (!this.isExtractSuperclass()) {
            this.invokeRefactoring(this.createProcessor());
        }
    }

    protected boolean checkConflicts() {
        return true;
    }

    public Collection<MemberInfoType> getSelectedMemberInfos() {
        ArrayList<MemberInfoBase> result2 = new ArrayList<MemberInfoBase>(this.myMemberInfos.size());
        for (MemberInfoBase info2 : this.myMemberInfos) {
            if (!info2.isChecked()) continue;
            result2.add(info2);
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extractedSuperName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/extractSuperclass/ExtractSuperBaseDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/extractSuperclass/ExtractSuperBaseDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtractedSuperName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "validateQualifiedName";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1 -> new IllegalStateException(string2);
        };
    }

    protected static class OperationFailedException
    extends Exception {
        public OperationFailedException(@NlsContexts.DialogMessage String message) {
            super(message);
        }
    }
}

