/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.ide.DataManager;
import com.intellij.lang.Language;
import com.intellij.lang.refactoring.InlineActionHandler;
import com.intellij.lang.refactoring.InlineHandler;
import com.intellij.lang.refactoring.InlineHandlers;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import com.intellij.refactoring.inline.GenericInlineHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InlineRefactoringActionHandler
implements RefactoringActionHandler {
    private static final Logger LOG = Logger.getInstance(InlineRefactoringActionHandler.class);

    public void invoke(@NotNull Project project2, PsiElement @NotNull [] elements, DataContext dataContext2) {
        if (project2 == null) {
            InlineRefactoringActionHandler.$$$reportNull$$$0(0);
        }
        if (elements == null) {
            InlineRefactoringActionHandler.$$$reportNull$$$0(1);
        }
        LOG.assertTrue(elements.length == 1);
        if (dataContext2 == null) {
            dataContext2 = DataManager.getInstance().getDataContext();
        }
        Editor editor2 = (Editor)CommonDataKeys.EDITOR.getData(dataContext2);
        for (InlineActionHandler handler2 : InlineActionHandler.EP_NAME.getExtensionList()) {
            if (!handler2.canInlineElement(elements[0])) continue;
            handler2.inlineElement(project2, editor2, elements[0]);
            return;
        }
        InlineRefactoringActionHandler.invokeInliner(editor2, elements[0]);
    }

    public void invoke(@NotNull Project project2, Editor editor2, PsiFile file2, DataContext dataContext2) {
        if (project2 == null) {
            InlineRefactoringActionHandler.$$$reportNull$$$0(2);
        }
        editor2.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext2);
        if (element == null) {
            element = BaseRefactoringAction.getElementAtCaret(editor2, file2);
        }
        if (element != null) {
            for (InlineActionHandler handler2 : InlineActionHandler.EP_NAME.getExtensionList()) {
                if (!handler2.canInlineElementInEditor(element, editor2)) continue;
                handler2.inlineElement(project2, editor2, element);
                return;
            }
            if (InlineRefactoringActionHandler.invokeInliner(editor2, element)) {
                return;
            }
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"error.wrong.caret.position.method.or.local.name"));
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor2, (String)message, (String)InlineRefactoringActionHandler.getRefactoringName(), null);
        }
    }

    public static boolean invokeInliner(@Nullable Editor editor2, PsiElement element) {
        List handlers2 = InlineHandlers.getInlineHandlers((Language)element.getLanguage());
        for (InlineHandler handler2 : handlers2) {
            if (!GenericInlineHandler.invoke(element, editor2, handler2)) continue;
            return true;
        }
        return false;
    }

    @NlsContexts.DialogTitle
    private static String getRefactoringName() {
        return RefactoringBundle.message((String)"inline.title");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "elements";
                break;
            }
        }
        objectArray[1] = "com/intellij/refactoring/inline/InlineRefactoringActionHandler";
        objectArray[2] = "invoke";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

