/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.invertBoolean;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.invertBoolean.InvertBooleanDelegate;
import com.intellij.refactoring.invertBoolean.InvertBooleanHandler;
import com.intellij.refactoring.invertBoolean.InvertBooleanUsageViewDescriptor;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InvertBooleanProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance(InvertBooleanProcessor.class);
    private final InvertBooleanDelegate myDelegate;
    private PsiElement myElement;
    private final String myNewName;
    private final RenameProcessor myRenameProcessor;
    private final Map<UsageInfo, SmartPsiElementPointer> myToInvert = new HashMap<UsageInfo, SmartPsiElementPointer>();
    private final SmartPointerManager mySmartPointerManager;

    public InvertBooleanProcessor(PsiElement namedElement, String newName2) {
        super(namedElement.getProject());
        this.myElement = namedElement;
        this.myNewName = newName2;
        Project project2 = namedElement.getProject();
        boolean canRename = namedElement instanceof PsiNamedElement && !Objects.equals(((PsiNamedElement)namedElement).getName(), this.myNewName);
        this.myRenameProcessor = canRename ? new RenameProcessor(project2, namedElement, newName2, false, false){

            @NotNull
            protected ConflictsDialog createConflictsDialog(@NotNull MultiMap<PsiElement, String> conflicts, UsageInfo @Nullable [] usages) {
                if (conflicts == null) {
                    1.$$$reportNull$$$0(0);
                }
                return new ConflictsDialog(this.myProject, conflicts, usages == null ? null : () -> InvertBooleanProcessor.this.execute(usages), false, true);
            }

            protected void prepareSuccessful() {
                InvertBooleanProcessor.this.prepareSuccessful();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflicts", "com/intellij/refactoring/invertBoolean/InvertBooleanProcessor$1", "createConflictsDialog"));
            }
        } : null;
        this.mySmartPointerManager = SmartPointerManager.getInstance(project2);
        this.myDelegate = InvertBooleanDelegate.findInvertBooleanDelegate(this.myElement);
        LOG.assertTrue(this.myDelegate != null, this.myElement);
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            InvertBooleanProcessor.$$$reportNull$$$0(0);
        }
        return new InvertBooleanUsageViewDescriptor(this.myElement);
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            InvertBooleanProcessor.$$$reportNull$$$0(1);
        }
        MultiMap<PsiElement, String> conflicts = new MultiMap<PsiElement, String>();
        UsageInfo[] usageInfos2 = refUsages.get();
        this.myDelegate.findConflicts(usageInfos2, conflicts);
        if (!conflicts.isEmpty()) {
            return this.showConflicts(conflicts, usageInfos2);
        }
        if (this.myRenameProcessor == null || this.myRenameProcessor.preprocessUsages(refUsages)) {
            this.prepareSuccessful();
            return true;
        }
        return false;
    }

    protected UsageInfo @NotNull [] findUsages() {
        ArrayList<SmartPsiElementPointer<PsiElement>> toInvert = new ArrayList<SmartPsiElementPointer<PsiElement>>();
        LinkedHashSet elementsToInvert = new LinkedHashSet();
        this.myDelegate.collectRefElements(this.myElement, this.myRenameProcessor, this.myNewName, elementsToInvert);
        for (PsiElement element : elementsToInvert) {
            toInvert.add(this.mySmartPointerManager.createSmartPsiElementPointer(element));
        }
        UsageInfo[] renameUsages = this.myRenameProcessor != null ? this.myRenameProcessor.findUsages() : UsageInfo.EMPTY_ARRAY;
        SmartPsiElementPointer[] usagesToInvert = toInvert.toArray(new SmartPsiElementPointer[0]);
        HashMap<PsiElement, UsageInfo> expressionsToUsages = new HashMap<PsiElement, UsageInfo>();
        ArrayList<UsageInfo> result2 = new ArrayList<UsageInfo>();
        for (UsageInfo renameUsage : renameUsages) {
            expressionsToUsages.put(renameUsage.getElement(), renameUsage);
            result2.add(renameUsage);
        }
        for (SmartPsiElementPointer pointer : usagesToInvert) {
            Object expression = pointer.getElement();
            if (!expressionsToUsages.containsKey(expression)) {
                UsageInfo usageInfo = new UsageInfo((PsiElement)expression);
                expressionsToUsages.put((PsiElement)expression, usageInfo);
                result2.add(usageInfo);
                this.myToInvert.put(usageInfo, pointer);
                continue;
            }
            this.myToInvert.put((UsageInfo)expressionsToUsages.get(expression), pointer);
        }
        UsageInfo[] usageInfoArray = result2.toArray(UsageInfo.EMPTY_ARRAY);
        if (usageInfoArray == null) {
            InvertBooleanProcessor.$$$reportNull$$$0(2);
        }
        return usageInfoArray;
    }

    protected void refreshElements(PsiElement @NotNull [] elements) {
        if (elements == null) {
            InvertBooleanProcessor.$$$reportNull$$$0(3);
        }
        this.myElement = elements[0];
    }

    private static UsageInfo[] extractUsagesForElement(PsiElement element, UsageInfo[] usages) {
        ArrayList<MoveRenameUsageInfo> extractedUsages = new ArrayList<MoveRenameUsageInfo>(usages.length);
        for (UsageInfo usage2 : usages) {
            MoveRenameUsageInfo usageInfo;
            if (!(usage2 instanceof MoveRenameUsageInfo) || !element.equals((usageInfo = (MoveRenameUsageInfo)usage2).getReferencedElement())) continue;
            extractedUsages.add(usageInfo);
        }
        return extractedUsages.toArray(UsageInfo.EMPTY_ARRAY);
    }

    protected void performRefactoring(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            InvertBooleanProcessor.$$$reportNull$$$0(4);
        }
        if (this.myRenameProcessor != null) {
            for (PsiElement element : this.myRenameProcessor.getElements()) {
                try {
                    RenameUtil.doRename((PsiElement)element, (String)this.myRenameProcessor.getNewName(element), (UsageInfo[])InvertBooleanProcessor.extractUsagesForElement(element, usages), (Project)this.myProject, null);
                }
                catch (IncorrectOperationException e) {
                    RenameUtil.showErrorMessage((IncorrectOperationException)e, (PsiElement)element, (Project)this.myProject);
                    return;
                }
            }
        }
        for (UsageInfo usage2 : usages) {
            SmartPsiElementPointer pointerToInvert = this.myToInvert.get(usage2);
            if (pointerToInvert == null) continue;
            Object element = pointerToInvert.getElement();
            LOG.assertTrue(element != null);
            InvertBooleanDelegate delegate2 = InvertBooleanDelegate.findInvertBooleanDelegate(element);
            try {
                (delegate2 != null ? delegate2 : this.myDelegate).replaceWithNegatedExpression((PsiElement)element);
            }
            catch (IncorrectOperationException e) {
                LOG.error(e);
            }
        }
        this.myDelegate.invertElementInitializer(this.myElement);
    }

    @NotNull
    protected String getCommandName() {
        String string2 = InvertBooleanHandler.getRefactoringName();
        if (string2 == null) {
            InvertBooleanProcessor.$$$reportNull$$$0(5);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/invertBoolean/InvertBooleanProcessor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/invertBoolean/InvertBooleanProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "refreshElements";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 5 -> new IllegalStateException(string2);
        };
    }
}

