/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.memberPushDown;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.memberPushDown.NewSubClassData;
import com.intellij.refactoring.memberPushDown.PushDownData;
import com.intellij.refactoring.memberPushDown.PushDownDelegate;
import com.intellij.refactoring.memberPushDown.PushDownUsageViewDescriptor;
import com.intellij.refactoring.util.DocCommentPolicy;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PushDownProcessor<MemberInfo extends MemberInfoBase<Member>, Member extends PsiElement, Klass extends PsiElement>
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance(PushDownProcessor.class);
    private NewSubClassData mySubClassData;
    private final PushDownDelegate<MemberInfo, Member> myDelegate;
    private final PushDownData<MemberInfo, Member> myPushDownData;

    public PushDownProcessor(@NotNull Klass sourceClass, @NotNull List<MemberInfo> memberInfos, @NotNull DocCommentPolicy javaDocPolicy) {
        if (sourceClass == null) {
            PushDownProcessor.$$$reportNull$$$0(0);
        }
        if (memberInfos == null) {
            PushDownProcessor.$$$reportNull$$$0(1);
        }
        if (javaDocPolicy == null) {
            PushDownProcessor.$$$reportNull$$$0(2);
        }
        this(sourceClass, memberInfos, javaDocPolicy, false);
    }

    @ApiStatus.Experimental
    public PushDownProcessor(@NotNull Klass sourceClass, @NotNull List<MemberInfo> memberInfos, @NotNull DocCommentPolicy javaDocPolicy, boolean preserveExternalLinks) {
        if (sourceClass == null) {
            PushDownProcessor.$$$reportNull$$$0(3);
        }
        if (memberInfos == null) {
            PushDownProcessor.$$$reportNull$$$0(4);
        }
        if (javaDocPolicy == null) {
            PushDownProcessor.$$$reportNull$$$0(5);
        }
        super(sourceClass.getProject());
        this.myDelegate = PushDownDelegate.findDelegate(sourceClass);
        LOG.assertTrue(this.myDelegate != null);
        this.myPushDownData = new PushDownData((PsiElement)sourceClass, memberInfos, javaDocPolicy, preserveExternalLinks);
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            PushDownProcessor.$$$reportNull$$$0(6);
        }
        return new PushDownUsageViewDescriptor(this.myPushDownData.getSourceClass(), this.myPushDownData.getMembersToMove());
    }

    @NotNull
    protected Collection<? extends PsiElement> getElementsToWrite(@NotNull UsageViewDescriptor descriptor2) {
        if (descriptor2 == null) {
            PushDownProcessor.$$$reportNull$$$0(7);
        }
        List<PsiElement> list2 = Collections.singletonList(this.myPushDownData.getSourceClass());
        if (list2 == null) {
            PushDownProcessor.$$$reportNull$$$0(8);
        }
        return list2;
    }

    @Nullable
    protected RefactoringEventData getBeforeData() {
        RefactoringEventData data2 = new RefactoringEventData();
        data2.addElement(this.myPushDownData.getSourceClass());
        data2.addElements(ContainerUtil.map(this.myPushDownData.getMembersToMove(), MemberInfoBase::getMember));
        return data2;
    }

    @Nullable
    protected RefactoringEventData getAfterData(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            PushDownProcessor.$$$reportNull$$$0(9);
        }
        ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
        for (UsageInfo usage2 : usages) {
            elements.add(usage2.getElement());
        }
        RefactoringEventData data2 = new RefactoringEventData();
        data2.addElements(elements);
        return data2;
    }

    protected UsageInfo @NotNull [] findUsages() {
        List<PsiElement> inheritors = this.myDelegate.findInheritors(this.myPushDownData);
        UsageInfo[] usageInfoArray = ContainerUtil.map2Array(inheritors, UsageInfo.EMPTY_ARRAY, this.myDelegate::createUsageInfo);
        if (usageInfoArray == null) {
            PushDownProcessor.$$$reportNull$$$0(10);
        }
        return usageInfoArray;
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            PushDownProcessor.$$$reportNull$$$0(11);
        }
        MultiMap<PsiElement, String> conflicts = new MultiMap<PsiElement, String>();
        this.myDelegate.checkSourceClassConflicts(this.myPushDownData, conflicts);
        UsageInfo[] usagesIn = refUsages.get();
        if (usagesIn.length == 0) {
            this.mySubClassData = this.myDelegate.preprocessNoInheritorsFound(this.myPushDownData.getSourceClass(), this.getCommandName());
            if (this.mySubClassData == NewSubClassData.ABORT_REFACTORING) {
                return false;
            }
        }
        Runnable runnable = () -> ApplicationManager.getApplication().runReadAction(() -> {
            if (this.mySubClassData != null) {
                this.myDelegate.checkTargetClassConflicts(null, this.myPushDownData, conflicts, this.mySubClassData);
            } else {
                for (UsageInfo usage2 : usagesIn) {
                    PsiElement element = usage2.getElement();
                    if (element == null) continue;
                    PushDownDelegate delegate2 = PushDownDelegate.findDelegateForTarget(this.myPushDownData.getSourceClass(), element);
                    if (delegate2 != null) {
                        delegate2.checkTargetClassConflicts(element, this.myPushDownData, conflicts, null);
                        continue;
                    }
                    conflicts.putValue(element, "Not supported source/target pair detected");
                }
            }
        });
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(runnable, RefactoringBundle.message((String)"detecting.possible.conflicts"), true, this.myProject)) {
            return false;
        }
        return this.showConflicts(conflicts, usagesIn);
    }

    protected void refreshElements(PsiElement @NotNull [] elements) {
        if (elements == null) {
            PushDownProcessor.$$$reportNull$$$0(12);
        }
        if (elements.length == 1) {
            this.myPushDownData.setSourceClass(elements[0]);
        } else {
            LOG.assertTrue(false);
        }
    }

    protected void performRefactoring(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            PushDownProcessor.$$$reportNull$$$0(13);
        }
        try {
            this.pushDownToClasses(usages);
            this.myDelegate.removeFromSourceClass(this.myPushDownData);
        }
        catch (IncorrectOperationException e) {
            LOG.error(e);
        }
    }

    public void pushDownToClasses(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            PushDownProcessor.$$$reportNull$$$0(14);
        }
        this.myDelegate.prepareToPush(this.myPushDownData);
        PsiElement sourceClass = this.myPushDownData.getSourceClass();
        if (this.mySubClassData != null) {
            PsiElement subClass = this.myDelegate.createSubClass(sourceClass, this.mySubClassData);
            if (subClass != null) {
                this.myDelegate.pushDownToClass(subClass, this.myPushDownData);
            }
        } else {
            for (UsageInfo usage2 : usages) {
                PushDownDelegate targetDelegate;
                PsiElement element = usage2.getElement();
                if (element == null || (targetDelegate = PushDownDelegate.findDelegateForTarget(sourceClass, element)) == null) continue;
                targetDelegate.pushDownToClass(element, this.myPushDownData);
            }
        }
    }

    @NotNull
    @NlsContexts.DialogTitle
    protected String getCommandName() {
        String string2 = RefactoringBundle.message((String)"push.members.down.title");
        if (string2 == null) {
            PushDownProcessor.$$$reportNull$$$0(15);
        }
        return string2;
    }

    @Nullable
    protected String getRefactoringId() {
        return "refactoring.push.down";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 10, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceClass";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberInfos";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaDocPolicy";
                break;
            }
            case 6: 
            case 9: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 8: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/memberPushDown/PushDownProcessor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/memberPushDown/PushDownProcessor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsToWrite";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getElementsToWrite";
                break;
            }
            case 8: 
            case 10: 
            case 15: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAfterData";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "refreshElements";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "pushDownToClasses";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 8, 10, 15 -> new IllegalStateException(string2);
        };
    }
}

