/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceOwner;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileReference;
import com.intellij.util.IncorrectOperationException;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileReferenceContextUtil {
    private static final Logger LOG = Logger.getInstance(FileReferenceContextUtil.class);
    private static final Key<Pair<PsiFileSystemItem, Integer>> REF_FILE_SYSTEM_ITEM_KEY = Key.create("REF_FILE_SYSTEM_ITEM_KEY");

    private FileReferenceContextUtil() {
    }

    public static Map<String, PsiFileSystemItem> encodeFileReferences(PsiElement element) {
        final HashMap<String, PsiFileSystemItem> map2 = new HashMap<String, PsiFileSystemItem>();
        if (element == null || element instanceof PsiCompiledElement || FileReferenceContextUtil.isBinary(element)) {
            return map2;
        }
        element.accept(new PsiRecursiveElementWalkingVisitor(true){

            @Override
            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (element instanceof PsiLanguageInjectionHost && element.isValid()) {
                    InjectedLanguageManager.getInstance(element.getProject()).enumerate(element, (injectedPsi, places) -> FileReferenceContextUtil.encodeFileReferences(injectedPsi));
                }
                PsiReference[] refs = element.getReferences();
                for (int refIndex = 0; refIndex < refs.length; ++refIndex) {
                    PsiFileReference ref;
                    PsiReference reference2 = refs[refIndex];
                    PsiFileReference psiFileReference = ref = reference2 instanceof FileReferenceOwner ? ((FileReferenceOwner)((Object)reference2)).getLastFileReference() : null;
                    if (ref != null && FileReferenceContextUtil.encodeFileReference(element, ref, map2, refIndex)) break;
                }
                super.visitElement(element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/move/FileReferenceContextUtil$1", "visitElement"));
            }
        });
        return map2;
    }

    private static boolean encodeFileReference(PsiElement element, PsiFileReference ref, Map<String, PsiFileSystemItem> map2, int refIndex) {
        ResolveResult[] results;
        for (ResolveResult result2 : results = ref.multiResolve(false)) {
            PsiElement psiElement = result2.getElement();
            if (!(psiElement instanceof PsiFileSystemItem)) continue;
            PsiFileSystemItem fileSystemItem = (PsiFileSystemItem)psiElement;
            element.putCopyableUserData(REF_FILE_SYSTEM_ITEM_KEY, Pair.create(fileSystemItem, refIndex));
            map2.put(element.getText(), fileSystemItem);
            return true;
        }
        return false;
    }

    private static boolean isBinary(PsiElement element) {
        PsiFile containingFile = element.getContainingFile();
        return containingFile == null || containingFile.getFileType().isBinary();
    }

    public static void decodeFileReferences(PsiElement element) {
        if (element == null || element instanceof PsiCompiledElement || FileReferenceContextUtil.isBinary(element)) {
            return;
        }
        element.accept(new PsiRecursiveElementVisitor(true){

            @Override
            public void visitElement(@NotNull PsiElement element) {
                Pair<PsiFileSystemItem, Integer> pair;
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                PsiFileSystemItem item = (pair = element.getCopyableUserData(REF_FILE_SYSTEM_ITEM_KEY)) != null ? (PsiFileSystemItem)pair.first : null;
                element.putCopyableUserData(REF_FILE_SYSTEM_ITEM_KEY, null);
                element = FileReferenceContextUtil.bindElement(element, item, pair != null ? (Integer)pair.second : -1);
                if (element != null) {
                    element.acceptChildren(this);
                }
                if (element instanceof PsiLanguageInjectionHost) {
                    InjectedLanguageManager.getInstance(element.getProject()).enumerate(element, (injectedPsi, places) -> FileReferenceContextUtil.decodeFileReferences(injectedPsi));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/move/FileReferenceContextUtil$2", "visitElement"));
            }
        });
    }

    public static void decodeFileReferences(PsiElement element, final Map<String, PsiFileSystemItem> map2, final TextRange range) {
        if (element == null || element instanceof PsiCompiledElement || FileReferenceContextUtil.isBinary(element)) {
            return;
        }
        element.accept(new PsiRecursiveElementVisitor(true){

            @Override
            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (!range.intersects(element.getTextRange())) {
                    return;
                }
                String text2 = element.getText();
                PsiFileSystemItem item = (PsiFileSystemItem)map2.get(text2);
                element.putCopyableUserData(REF_FILE_SYSTEM_ITEM_KEY, Pair.create(item, -1));
                element.acceptChildren(this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/move/FileReferenceContextUtil$3", "visitElement"));
            }
        });
        FileReferenceContextUtil.decodeFileReferences(element);
    }

    private static PsiElement bindElement(PsiElement element, PsiFileSystemItem item, int refIndex) {
        if (item != null && item.isValid() && item.getVirtualFile() != null) {
            PsiElement result2;
            PsiReference ref;
            PsiReference[] refs = element.getReferences();
            if (refIndex >= 0 && refs.length > refIndex && (ref = refs[refIndex]) instanceof FileReferenceOwner && (result2 = FileReferenceContextUtil.bindAndCheckElement(ref, element, item)) != null) {
                return result2;
            }
            for (PsiReference ref2 : refs) {
                if (!(ref2 instanceof FileReferenceOwner)) continue;
                PsiElement result3 = FileReferenceContextUtil.bindAndCheckElement(ref2, element, item);
                if (result3 == null) break;
                return result3;
            }
        }
        return element;
    }

    @Nullable
    private static PsiElement bindAndCheckElement(@NotNull PsiReference ref, @NotNull PsiElement element, @NotNull PsiFileSystemItem item) {
        PsiFileReference fileReference;
        if (ref == null) {
            FileReferenceContextUtil.$$$reportNull$$$0(0);
        }
        if (element == null) {
            FileReferenceContextUtil.$$$reportNull$$$0(1);
        }
        if (item == null) {
            FileReferenceContextUtil.$$$reportNull$$$0(2);
        }
        if ((fileReference = ((FileReferenceOwner)((Object)ref)).getLastFileReference()) != null) {
            try {
                PsiElement newElement = fileReference.bindToElement(item);
                if (newElement != null) {
                    LOG.assertTrue(element.getClass() == newElement.getClass(), "Reference " + ref + " violated contract of bindToElement()");
                }
                return newElement;
            }
            catch (IncorrectOperationException e) {
                LOG.error(e);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "ref";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "item";
                break;
            }
        }
        objectArray[1] = "com/intellij/refactoring/move/FileReferenceContextUtil";
        objectArray[2] = "bindAndCheckElement";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

