/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move;

import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class MoveMultipleElementsViewDescriptor
implements UsageViewDescriptor {
    private final PsiElement[] myPsiElements;
    private @NlsContexts.ListItem String myProcessedElementsHeader;
    @Nls
    private final String myCodeReferencesText;

    public MoveMultipleElementsViewDescriptor(PsiElement @NotNull [] psiElements, @NotNull String targetName) {
        if (targetName == null) {
            MoveMultipleElementsViewDescriptor.$$$reportNull$$$0(0);
        }
        if (psiElements == null) {
            MoveMultipleElementsViewDescriptor.$$$reportNull$$$0(1);
        }
        this.myPsiElements = psiElements;
        if (psiElements.length == 1) {
            this.myProcessedElementsHeader = StringUtil.capitalize(RefactoringBundle.message((String)"move.single.element.elements.header", (Object[])new Object[]{UsageViewUtil.getType((PsiElement)psiElements[0]), targetName}));
            this.myCodeReferencesText = RefactoringBundle.message((String)"references.in.code.to.0.1", (Object[])new Object[]{UsageViewUtil.getType((PsiElement)psiElements[0]), UsageViewUtil.getLongName((PsiElement)psiElements[0])});
        } else {
            if (psiElements.length > 0) {
                this.myProcessedElementsHeader = StringUtil.capitalize(RefactoringBundle.message((String)"move.single.element.elements.header", (Object[])new Object[]{StringUtil.pluralize(UsageViewUtil.getType((PsiElement)psiElements[0])), targetName}));
            }
            this.myCodeReferencesText = RefactoringBundle.message((String)"references.found.in.code");
        }
    }

    public PsiElement @NotNull [] getElements() {
        if (this.myPsiElements == null) {
            MoveMultipleElementsViewDescriptor.$$$reportNull$$$0(2);
        }
        return this.myPsiElements;
    }

    public String getProcessedElementsHeader() {
        return this.myProcessedElementsHeader;
    }

    @NotNull
    public String getCodeReferencesText(int usagesCount, int filesCount) {
        String string2 = this.myCodeReferencesText + UsageViewBundle.getReferencesString((int)usagesCount, (int)filesCount);
        if (string2 == null) {
            MoveMultipleElementsViewDescriptor.$$$reportNull$$$0(3);
        }
        return string2;
    }

    public String getCommentReferencesText(int usagesCount, int filesCount) {
        return RefactoringBundle.message((String)"comments.elements.header", (Object[])new Object[]{UsageViewBundle.getOccurencesString((int)usagesCount, (int)filesCount)});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElements";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/move/MoveMultipleElementsViewDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/move/MoveMultipleElementsViewDescriptor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getElements";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCodeReferencesText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 3 -> new IllegalStateException(string2);
        };
    }
}

