/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveClassesOrPackages;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;

public final class CommonMoveUtil {
    static final Comparator<UsageInfo> USAGE_INFO_COMPARATOR = (o1, o2) -> {
        VirtualFile file2;
        VirtualFile file1 = o1.getVirtualFile();
        if (Comparing.equal(file1, file2 = o2.getVirtualFile())) {
            ProperTextRange rangeInElement1 = o1.getRangeInElement();
            ProperTextRange rangeInElement2 = o2.getRangeInElement();
            if (rangeInElement1 != null && rangeInElement2 != null) {
                return rangeInElement2.getStartOffset() - rangeInElement1.getStartOffset();
            }
            return 0;
        }
        if (file1 == null) {
            return -1;
        }
        if (file2 == null) {
            return 1;
        }
        return Comparing.compare(file1.getPath(), file2.getPath());
    };
    private static final Logger LOG = Logger.getInstance(CommonMoveUtil.class);

    public static NonCodeUsageInfo[] retargetUsages(UsageInfo[] usages, Map<PsiElement, PsiElement> oldToNewElementsMapping) {
        Arrays.sort(usages, USAGE_INFO_COMPARATOR);
        ArrayList<NonCodeUsageInfo> nonCodeUsages = new ArrayList<NonCodeUsageInfo>();
        for (UsageInfo usage2 : usages) {
            if (usage2 instanceof NonCodeUsageInfo) {
                nonCodeUsages.add((NonCodeUsageInfo)usage2);
                continue;
            }
            if (!(usage2 instanceof MoveRenameUsageInfo)) continue;
            MoveRenameUsageInfo moveRenameUsage = (MoveRenameUsageInfo)usage2;
            PsiElement oldElement = moveRenameUsage.getReferencedElement();
            PsiElement newElement = oldToNewElementsMapping.get(oldElement);
            LOG.assertTrue(newElement != null, oldElement);
            PsiReference reference2 = moveRenameUsage.getReference();
            if (reference2 == null) continue;
            try {
                reference2.bindToElement(newElement);
            }
            catch (IncorrectOperationException incorrectOperationException) {
                // empty catch block
            }
        }
        return nonCodeUsages.toArray(new NonCodeUsageInfo[0]);
    }
}

