/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveFilesOrDirectories;

import com.intellij.ide.util.DirectoryChooserUtil;
import com.intellij.ide.util.EditorHelper;
import com.intellij.model.ModelBranch;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.refactoring.copy.CopyFilesOrDirectoriesHandler;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveHandler;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesDialog;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesProcessor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MoveFilesOrDirectoriesUtil {
    private MoveFilesOrDirectoriesUtil() {
    }

    public static void doMoveDirectory(PsiDirectory aDirectory, PsiDirectory destDirectory) throws IncorrectOperationException {
        PsiManager manager = aDirectory.getManager();
        MoveFilesOrDirectoriesUtil.doJustMoveDirectory(aDirectory, destDirectory, manager);
        if (ModelBranch.getPsiBranch(destDirectory) == null) {
            DumbService.getInstance(manager.getProject()).completeJustSubmittedTasks();
        }
    }

    private static void doJustMoveDirectory(@NotNull PsiDirectory aDirectory, @NotNull PsiDirectory destDirectory, @Nullable Object requestor) {
        if (aDirectory == null) {
            MoveFilesOrDirectoriesUtil.$$$reportNull$$$0(0);
        }
        if (destDirectory == null) {
            MoveFilesOrDirectoriesUtil.$$$reportNull$$$0(1);
        }
        MoveFilesOrDirectoriesUtil.checkMove(aDirectory, destDirectory);
        try {
            aDirectory.getVirtualFile().move(requestor, destDirectory.getVirtualFile());
        }
        catch (IOException e) {
            throw new IncorrectOperationException(e);
        }
    }

    public static void doMoveFile(@NotNull PsiFile file2, @NotNull PsiDirectory newDirectory) throws IncorrectOperationException {
        if (file2 == null) {
            MoveFilesOrDirectoriesUtil.$$$reportNull$$$0(2);
        }
        if (newDirectory == null) {
            MoveFilesOrDirectoriesUtil.$$$reportNull$$$0(3);
        }
        if (!newDirectory.equals(file2.getContainingDirectory())) {
            MoveFilesOrDirectoriesUtil.checkMove(file2, newDirectory);
            VirtualFile vFile = file2.getViewProvider().getVirtualFile();
            try {
                vFile.move(file2.getManager(), newDirectory.getVirtualFile());
            }
            catch (IOException e) {
                throw new IncorrectOperationException(e);
            }
        }
    }

    public static void doMove(Project project2, PsiElement[] elements, PsiElement[] targetElement, MoveCallback moveCallback) {
        MoveFilesOrDirectoriesUtil.doMove(project2, elements, targetElement, moveCallback, null);
    }

    public static void doMove(final Project project2, final PsiElement[] elements, PsiElement[] targetElement, final MoveCallback moveCallback, Function<? super PsiElement[], ? extends PsiElement[]> adjustElements) {
        if (adjustElements == null) {
            for (PsiElement element : elements) {
                if (element instanceof PsiFile || element instanceof PsiDirectory) continue;
                throw new IllegalArgumentException("unexpected element type: " + element);
            }
        }
        PsiDirectory targetDirectory = MoveFilesOrDirectoriesUtil.resolveToDirectory(project2, targetElement[0]);
        if (targetElement[0] != null && targetDirectory == null) {
            return;
        }
        final PsiElement[] adjustedElements = adjustElements != null ? adjustElements.fun((PsiElement[])elements) : elements;
        PsiDirectory initialTargetDirectory = MoveFilesOrDirectoriesUtil.getInitialTargetDirectory(targetDirectory, elements);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            Objects.requireNonNull(initialTargetDirectory, "It is null! The target directory, it is null!");
            MoveFilesOrDirectoriesUtil.doMove(project2, elements, adjustedElements, initialTargetDirectory, moveCallback, EmptyRunnable.INSTANCE);
        } else {
            new MoveFilesOrDirectoriesDialog(project2, adjustedElements, initialTargetDirectory){

                @Override
                protected void performMove(@NotNull PsiDirectory targetDirectory) {
                    if (targetDirectory == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    Runnable doneCallback = () -> this.closeOKAction();
                    MoveFilesOrDirectoriesUtil.doMove(project2, elements, adjustedElements, targetDirectory, moveCallback, doneCallback);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetDirectory", "com/intellij/refactoring/move/moveFilesOrDirectories/MoveFilesOrDirectoriesUtil$1", "performMove"));
                }
            }.show();
        }
    }

    private static void doMove(Project project2, PsiElement[] elements, PsiElement[] adjustedElements, PsiDirectory targetDirectory, MoveCallback moveCallback, Runnable doneCallback) {
        CommandProcessor.getInstance().executeCommand(project2, () -> {
            SmartList<PsiDirectory> toCheck = new SmartList<PsiDirectory>(targetDirectory);
            for (PsiElement e : adjustedElements) {
                toCheck.add((PsiDirectory)(e instanceof PsiFileSystemItem && e.getParent() != null ? e.getParent() : e));
            }
            if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project2, toCheck, (boolean)false)) {
                return;
            }
            try {
                int[] nArray;
                if (elements.length > 1 || elements[0] instanceof PsiDirectory) {
                    int[] nArray2 = new int[1];
                    nArray = nArray2;
                    nArray2[0] = -1;
                } else {
                    nArray = null;
                }
                int[] choice = nArray;
                ArrayList<PsiElement> els = new ArrayList<PsiElement>();
                for (PsiElement psiElement : adjustedElements) {
                    PsiFile file2;
                    if (psiElement instanceof PsiFile && CopyFilesOrDirectoriesHandler.checkFileExist(targetDirectory, choice, file2 = (PsiFile)psiElement, file2.getName(), RefactoringBundle.message((String)"command.name.move"))) continue;
                    MoveFilesOrDirectoriesUtil.checkMove(psiElement, targetDirectory);
                    els.add(psiElement);
                }
                if (els.isEmpty()) {
                    doneCallback.run();
                } else if (DumbService.isDumb(project2)) {
                    if (doneCallback != null) {
                        ApplicationManager.getApplication().invokeAndWait(doneCallback);
                    }
                    HashSet filePointers = new HashSet();
                    if (MoveFilesOrDirectoriesDialog.isOpenInEditorProperty()) {
                        SmartPointerManager manager = SmartPointerManager.getInstance(project2);
                        for (PsiElement element : elements) {
                            MoveFilesOrDirectoriesUtil.addFilePointers(filePointers, element, manager);
                        }
                    }
                    WriteCommandAction.runWriteCommandAction(project2, RefactoringBundle.message((String)"move.title"), null, () -> {
                        try {
                            for (PsiElement element : elements) {
                                PsiFile movedFile;
                                PsiFile moving;
                                if (element instanceof PsiDirectory) {
                                    MoveFilesOrDirectoriesUtil.doJustMoveDirectory((PsiDirectory)element, targetDirectory, MoveFilesOrDirectoriesUtil.class);
                                    continue;
                                }
                                if (!(element instanceof PsiFile) || (moving = targetDirectory.findFile((movedFile = (PsiFile)element).getName())) != null) continue;
                                MoveFilesOrDirectoriesUtil.doMoveFile(movedFile, targetDirectory);
                            }
                        }
                        finally {
                            if (moveCallback != null) {
                                moveCallback.refactoringCompleted();
                            }
                            if (MoveFilesOrDirectoriesDialog.isOpenInEditorProperty()) {
                                ApplicationManager.getApplication().invokeLater(() -> EditorHelper.openFilesInEditor((PsiElement[])((PsiFile[])filePointers.stream().map(SmartPsiElementPointer::getContainingFile).filter(file2 -> file2 != null && file2.isValid()).toArray(PsiFile[]::new))), project2.getDisposed());
                            }
                        }
                    }, new PsiFile[0]);
                } else {
                    new MoveFilesOrDirectoriesProcessor(project2, els.toArray(PsiElement.EMPTY_ARRAY), targetDirectory, RefactoringSettings.getInstance().MOVE_SEARCH_FOR_REFERENCES_FOR_FILE, false, false, moveCallback, doneCallback).run();
                }
            }
            catch (IncorrectOperationException e) {
                CommonRefactoringUtil.showErrorMessage((String)RefactoringBundle.message((String)"error.title"), (String)e.getMessage(), (String)"refactoring.moveFile", (Project)project2);
            }
        }, MoveHandler.getRefactoringName(), null);
    }

    private static void addFilePointers(@NotNull Set<? super SmartPsiElementPointer<PsiFile>> pointers2, @NotNull PsiElement element, @NotNull SmartPointerManager manager) {
        if (pointers2 == null) {
            MoveFilesOrDirectoriesUtil.$$$reportNull$$$0(4);
        }
        if (element == null) {
            MoveFilesOrDirectoriesUtil.$$$reportNull$$$0(5);
        }
        if (manager == null) {
            MoveFilesOrDirectoriesUtil.$$$reportNull$$$0(6);
        }
        if (element instanceof PsiFile) {
            pointers2.add(manager.createSmartPsiElementPointer((PsiFile)element, (PsiFile)element));
        } else if (element instanceof PsiDirectory) {
            for (PsiElement child : element.getChildren()) {
                MoveFilesOrDirectoriesUtil.addFilePointers(pointers2, child, manager);
            }
        }
    }

    @Nullable
    public static PsiDirectory resolveToDirectory(Project project2, PsiElement element) {
        if (!(element instanceof PsiDirectoryContainer)) {
            return (PsiDirectory)element;
        }
        PsiDirectory[] directories = ((PsiDirectoryContainer)element).getDirectories();
        return switch (directories.length) {
            case 0 -> null;
            case 1 -> directories[0];
            default -> DirectoryChooserUtil.chooseDirectory(directories, directories[0], project2, new HashMap<PsiDirectory, String>());
        };
    }

    @Nullable
    private static PsiDirectory getCommonDirectory(PsiElement[] movedElements) {
        PsiDirectory commonDirectory = null;
        for (PsiElement movedElement : movedElements) {
            PsiDirectory containingDirectory;
            if (movedElement instanceof PsiDirectory) {
                containingDirectory = ((PsiDirectory)movedElement).getParentDirectory();
            } else {
                PsiFile containingFile = movedElement.getContainingFile();
                PsiDirectory psiDirectory = containingDirectory = containingFile == null ? null : containingFile.getContainingDirectory();
            }
            if (containingDirectory == null) continue;
            if (commonDirectory == null) {
                commonDirectory = containingDirectory;
                continue;
            }
            if (commonDirectory == containingDirectory) continue;
            return null;
        }
        return commonDirectory;
    }

    @Nullable
    public static PsiDirectory getInitialTargetDirectory(PsiDirectory initialTargetElement, PsiElement[] movedElements) {
        PsiDirectory initialTargetDirectory = initialTargetElement;
        if (initialTargetDirectory == null && movedElements != null) {
            PsiDirectory commonDirectory = MoveFilesOrDirectoriesUtil.getCommonDirectory(movedElements);
            initialTargetDirectory = commonDirectory != null ? commonDirectory : MoveFilesOrDirectoriesUtil.getContainerDirectory(movedElements[0]);
        }
        return initialTargetDirectory;
    }

    @Nullable
    private static PsiDirectory getContainerDirectory(PsiElement psiElement) {
        PsiFile containingFile;
        if (psiElement instanceof PsiDirectory) {
            return (PsiDirectory)psiElement;
        }
        if (psiElement != null && (containingFile = psiElement.getContainingFile()) != null) {
            return containingFile.getContainingDirectory();
        }
        return null;
    }

    public static void checkMove(@NotNull PsiElement element, @NotNull PsiElement newContainer) throws IncorrectOperationException {
        if (element == null) {
            MoveFilesOrDirectoriesUtil.$$$reportNull$$$0(7);
        }
        if (newContainer == null) {
            MoveFilesOrDirectoriesUtil.$$$reportNull$$$0(8);
        }
        if (element instanceof PsiDirectoryContainer) {
            PsiDirectory[] dirs = ((PsiDirectoryContainer)element).getDirectories();
            if (dirs.length == 0) {
                throw new IncorrectOperationException();
            }
            if (dirs.length > 1) {
                throw new IncorrectOperationException("Moving of packages represented by more than one physical directory is not supported.");
            }
            MoveFilesOrDirectoriesUtil.checkMove(dirs[0], newContainer);
            return;
        }
        newContainer.checkAdd(element);
        MoveFilesOrDirectoriesUtil.checkIfMoveIntoSelf(element, newContainer);
    }

    public static void checkIfMoveIntoSelf(PsiElement element, PsiElement newContainer) throws IncorrectOperationException {
        for (PsiElement container = newContainer; container != null; container = container.getParent()) {
            if (container != element) continue;
            if (element instanceof PsiDirectory) {
                if (element == newContainer) {
                    throw new IncorrectOperationException("Cannot place directory into itself.");
                }
                throw new IncorrectOperationException("Cannot place directory into its subdirectory.");
            }
            throw new IncorrectOperationException();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aDirectory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destDirectory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newDirectory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointers";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newContainer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/move/moveFilesOrDirectories/MoveFilesOrDirectoriesUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doJustMoveDirectory";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "doMoveFile";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "addFilePointers";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "checkMove";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

