/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveFilesOrDirectories;

import com.intellij.ide.projectView.impl.NestingTreeStructureProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesHandler;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MoveRelatedFilesHandler
extends MoveFilesOrDirectoriesHandler {
    @Override
    public boolean canMove(PsiElement[] elements, PsiElement targetContainer, @Nullable PsiReference reference2) {
        if (!super.canMove(elements, targetContainer, reference2)) {
            return false;
        }
        for (PsiElement element : elements) {
            if (!(element instanceof PsiFile) || ((PsiFile)element).getVirtualFile() == null || NestingTreeStructureProvider.getFilesShownAsChildrenInProjectView(element.getProject(), ((PsiFile)element).getVirtualFile()).isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public PsiElement @Nullable [] adjustForMove(@NotNull Project project2, PsiElement @NotNull [] sourceElements, @Nullable PsiElement targetElement) {
        if (project2 == null) {
            MoveRelatedFilesHandler.$$$reportNull$$$0(0);
        }
        if (sourceElements == null) {
            MoveRelatedFilesHandler.$$$reportNull$$$0(1);
        }
        if ((sourceElements = super.adjustForMove(project2, sourceElements, targetElement)) == null) {
            return null;
        }
        HashSet<PsiFile> relatedFilesToMove = new HashSet<PsiFile>();
        for (PsiElement element : sourceElements) {
            VirtualFile file2;
            if (!(element instanceof PsiFile) || (file2 = ((PsiFile)element).getVirtualFile()) == null) continue;
            Collection<NestingTreeStructureProvider.ChildFileInfo> relatedFileInfos = NestingTreeStructureProvider.getFilesShownAsChildrenInProjectView(element.getProject(), file2);
            for (NestingTreeStructureProvider.ChildFileInfo info2 : relatedFileInfos) {
                PsiFile psiFile = element.getManager().findFile(info2.file());
                if (psiFile == null || ArrayUtil.contains(psiFile, sourceElements)) continue;
                relatedFilesToMove.add(psiFile);
            }
        }
        if (!relatedFilesToMove.isEmpty()) {
            int ok2;
            String message = relatedFilesToMove.size() == 1 ? RefactoringBundle.message((String)"ask.to.move.related.file", (Object[])new Object[]{((PsiFile)relatedFilesToMove.iterator().next()).getName()}) : RefactoringBundle.message((String)"ask.to.move.related.files", (Object[])new Object[]{StringUtil.join(relatedFilesToMove, PsiFileSystemItem::getName, ", ")});
            int n = ok2 = ApplicationManager.getApplication().isUnitTestMode() ? 0 : Messages.showYesNoDialog((Project)project2, (String)message, (String)RefactoringBundle.message((String)"move.title"), (Icon)Messages.getQuestionIcon());
            if (ok2 == 0) {
                PsiElement[] result2 = Arrays.copyOf(sourceElements, sourceElements.length + relatedFilesToMove.size());
                ArrayUtil.copy(relatedFilesToMove, result2, sourceElements.length);
                return result2;
            }
        }
        return sourceElements;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "sourceElements";
                break;
            }
        }
        objectArray[1] = "com/intellij/refactoring/move/moveFilesOrDirectories/MoveRelatedFilesHandler";
        objectArray[2] = "adjustForMove";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

