/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.CommonBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.DirectoryRenameHandlerBase;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DirectoryAsPackageRenameHandlerBase<T extends PsiDirectoryContainer>
extends DirectoryRenameHandlerBase {
    private static final Logger LOG = Logger.getInstance(DirectoryAsPackageRenameHandlerBase.class);

    protected abstract VirtualFile[] occursInPackagePrefixes(T var1);

    protected abstract boolean isIdentifier(String var1, Project var2);

    protected abstract String getQualifiedName(T var1);

    @Nullable
    protected abstract T getPackage(PsiDirectory var1);

    protected abstract BaseRefactoringProcessor createProcessor(String var1, Project var2, PsiDirectory[] var3, boolean var4, boolean var5);

    @Override
    protected boolean isSuitableDirectory(PsiDirectory directory) {
        return this.getPackage(directory) != null;
    }

    @Override
    protected void doRename(PsiElement element, Project project2, PsiElement nameSuggestionContext, Editor editor2) {
        String qualifiedName;
        PsiDirectory psiDirectory = (PsiDirectory)element;
        T aPackage = this.getPackage(psiDirectory);
        String string2 = qualifiedName = aPackage != null ? this.getQualifiedName(aPackage) : "";
        if (aPackage == null || qualifiedName.length() == 0 || !this.isIdentifier(psiDirectory.getName(), project2)) {
            PsiElementRenameHandler.rename((PsiElement)element, (Project)project2, (PsiElement)nameSuggestionContext, (Editor)editor2);
        } else {
            PsiDirectory[] directories = aPackage.getDirectories();
            VirtualFile[] virtualFiles = this.occursInPackagePrefixes(aPackage);
            if (virtualFiles.length == 0 && directories.length == 1) {
                PsiElementRenameHandler.rename(aPackage, (Project)project2, (PsiElement)nameSuggestionContext, (Editor)editor2);
            } else {
                PsiDirectory[] projectDirectories = aPackage.getDirectories(GlobalSearchScope.projectScope(project2));
                if (virtualFiles.length == 0 && projectDirectories.length == 1) {
                    this.renameDirs(project2, nameSuggestionContext, editor2, psiDirectory, aPackage, psiDirectory);
                    return;
                }
                @Nls StringBuffer message = new StringBuffer();
                RenameUtil.buildPackagePrefixChangedMessage((VirtualFile[])virtualFiles, (StringBuffer)message, (String)qualifiedName);
                Module module2 = Objects.requireNonNull(ModuleUtilCore.findModuleForFile(psiDirectory.getVirtualFile(), project2));
                DirectoryAsPackageRenameHandlerBase.buildMultipleDirectoriesInPackageMessage(message, this.getQualifiedName(aPackage), projectDirectories, psiDirectory);
                PsiDirectory[] moduleDirectories = aPackage.getDirectories(GlobalSearchScope.moduleScope(module2));
                message.append(RefactoringBundle.message((String)"directories.and.all.references.to.package.will.be.renamed"));
                ArrayList<String> options2 = new ArrayList<String>();
                options2.add(RefactoringBundle.message((String)"rename.package.button.text"));
                if (projectDirectories.length > moduleDirectories.length) {
                    options2.add(RefactoringBundle.message((String)"rename.directory.button.text"));
                }
                if (moduleDirectories.length > 1) {
                    options2.add(RefactoringBundle.message((String)"rename.source.root.button.text"));
                }
                options2.add(CommonBundle.getCancelButtonText());
                int ret = Messages.showDialog((Project)project2, (String)message.toString(), (String)RefactoringBundle.message((String)"dialog.title.rename.package.directories"), (String[])ArrayUtil.toStringArray(options2), (int)0, (Icon)Messages.getQuestionIcon());
                if (ret == 0) {
                    if (directories.length > projectDirectories.length) {
                        this.renameDirs(project2, nameSuggestionContext, editor2, psiDirectory, aPackage, projectDirectories);
                    } else {
                        PsiElementRenameHandler.rename(aPackage, (Project)project2, (PsiElement)nameSuggestionContext, (Editor)editor2);
                    }
                } else if (ret == 1) {
                    PsiDirectory[] psiDirectoryArray;
                    if (projectDirectories.length > moduleDirectories.length) {
                        psiDirectoryArray = moduleDirectories;
                    } else {
                        PsiDirectory[] psiDirectoryArray2 = new PsiDirectory[1];
                        psiDirectoryArray = psiDirectoryArray2;
                        psiDirectoryArray2[0] = psiDirectory;
                    }
                    PsiDirectory[] dirsToRename = psiDirectoryArray;
                    this.renameDirs(project2, nameSuggestionContext, editor2, psiDirectory, aPackage, dirsToRename);
                } else if (ret == 2 && options2.size() > 3) {
                    this.renameDirs(project2, nameSuggestionContext, editor2, psiDirectory, aPackage, psiDirectory);
                }
            }
        }
    }

    private void renameDirs(Project project2, PsiElement nameSuggestionContext, Editor editor2, PsiDirectory contextDirectory, T aPackage, PsiDirectory ... dirsToRename) {
        RenameDialog dialog = new RenameDialog(project2, contextDirectory, nameSuggestionContext, editor2, (PsiDirectoryContainer)aPackage, project2, dirsToRename){
            final /* synthetic */ PsiDirectoryContainer val$aPackage;
            final /* synthetic */ Project val$project;
            final /* synthetic */ PsiDirectory[] val$dirsToRename;
            {
                this.val$aPackage = psiDirectoryContainer;
                this.val$project = project3;
                this.val$dirsToRename = psiDirectoryArray;
                super(project2, psiElement, nameSuggestionContext, editor2);
            }

            @Override
            protected void doAction() {
                String newQName = StringUtil.getQualifiedName(StringUtil.getPackageName(DirectoryAsPackageRenameHandlerBase.this.getQualifiedName(this.val$aPackage)), this.getNewName());
                BaseRefactoringProcessor moveProcessor = DirectoryAsPackageRenameHandlerBase.this.createProcessor(newQName, this.val$project, this.val$dirsToRename, this.isSearchInComments(), this.isSearchInNonJavaFiles());
                this.invokeRefactoring(moveProcessor);
            }
        };
        dialog.show();
    }

    public static void buildMultipleDirectoriesInPackageMessage(StringBuffer message, String packageQname, PsiDirectory[] directories, @Nullable PsiDirectory currentVDirectory) {
        message.append(RefactoringBundle.message((String)"multiple.directories.correspond.to.package", (Object[])new Object[]{packageQname}));
        ArrayList<PsiDirectory> generated = new ArrayList<PsiDirectory>();
        ArrayList<PsiDirectory> source = new ArrayList<PsiDirectory>();
        for (PsiDirectory directory2 : directories) {
            VirtualFile virtualFile2 = directory2.getVirtualFile();
            if (GeneratedSourcesFilter.isGeneratedSourceByAnyFilter(virtualFile2, directory2.getProject())) {
                generated.add(directory2);
                continue;
            }
            source.add(directory2);
        }
        if (currentVDirectory != null && source.indexOf(currentVDirectory) > 0) {
            source.remove(currentVDirectory);
            source.add(0, currentVDirectory);
        }
        Function<PsiDirectory, String> directoryPresentation = directory -> DirectoryAsPackageRenameHandlerBase.presentableUrl(currentVDirectory, directory);
        DirectoryAsPackageRenameHandlerBase.appendRoots(message, source, directoryPresentation);
        if (!generated.isEmpty()) {
            message.append("\n\n").append(RefactoringBundle.message((String)"also.generated")).append("\n");
            DirectoryAsPackageRenameHandlerBase.appendRoots(message, generated, directoryPresentation);
        }
    }

    @NotNull
    @Nls
    private static String presentableUrl(@Nullable PsiDirectory currentVDirectory, PsiDirectory directory) {
        String presentableUrl = SymbolPresentationUtil.getFilePathPresentation(directory);
        if (directory.equals(currentVDirectory)) {
            String string2 = presentableUrl + " (" + RefactoringBundle.message((String)"multiple.directories.correspond.to.package.current.marker") + ")";
            if (string2 == null) {
                DirectoryAsPackageRenameHandlerBase.$$$reportNull$$$0(0);
            }
            return string2;
        }
        String string3 = presentableUrl;
        if (string3 == null) {
            DirectoryAsPackageRenameHandlerBase.$$$reportNull$$$0(1);
        }
        return string3;
    }

    private static void appendRoots(StringBuffer message, List<? extends PsiDirectory> source, Function<? super PsiDirectory, String> directoryPresentation) {
        int limit2 = Math.min(source.size(), 10);
        message.append(StringUtil.join(source.subList(0, limit2), directoryPresentation, "\n"));
        if (limit2 < source.size()) {
            message.append("\n...\n");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/rename/DirectoryAsPackageRenameHandlerBase", "presentableUrl"));
    }
}

