/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.ide.TitledHandler;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameHandler;
import java.util.Arrays;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public abstract class DirectoryRenameHandlerBase
implements RenameHandler,
TitledHandler {
    private static final Logger LOG = Logger.getInstance(DirectoryRenameHandlerBase.class);

    @Override
    public String getActionTitle() {
        return RefactoringBundle.message((String)"rename.directory.title");
    }

    public boolean isAvailableOnDataContext(@NotNull DataContext dataContext2) {
        PsiDirectory directory;
        if (dataContext2 == null) {
            DirectoryRenameHandlerBase.$$$reportNull$$$0(0);
        }
        if ((directory = this.adjustForRename(dataContext2, PsiElementRenameHandler.getElement((DataContext)dataContext2))) != null) {
            VirtualFile virtualFile2 = directory.getVirtualFile();
            Project project2 = directory.getProject();
            if (Comparing.equal(project2.getBaseDir(), virtualFile2)) {
                return false;
            }
            if (ProjectRootManager.getInstance(project2).getFileIndex().isInContent(virtualFile2)) {
                return true;
            }
        }
        return false;
    }

    protected PsiDirectory adjustForRename(DataContext dataContext2, PsiElement element) {
        Module module2;
        if (element instanceof PsiDirectoryContainer && (module2 = (Module)PlatformCoreDataKeys.MODULE.getData(dataContext2)) != null) {
            PsiDirectory[] directories = ((PsiDirectoryContainer)element).getDirectories(GlobalSearchScope.moduleScope(module2));
            Optional<PsiDirectory> directoryWithPackage = Arrays.stream(directories).filter(this::isSuitableDirectory).findFirst();
            return directoryWithPackage.orElse(null);
        }
        return element instanceof PsiDirectory && this.isSuitableDirectory((PsiDirectory)element) ? (PsiDirectory)element : null;
    }

    protected abstract boolean isSuitableDirectory(PsiDirectory var1);

    public void invoke(@NotNull Project project2, Editor editor2, PsiFile file2, DataContext dataContext2) {
        if (project2 == null) {
            DirectoryRenameHandlerBase.$$$reportNull$$$0(1);
        }
        PsiDirectory element = this.adjustForRename(dataContext2, PsiElementRenameHandler.getElement((DataContext)dataContext2));
        editor2.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement nameSuggestionContext = file2.findElementAt(editor2.getCaretModel().getOffset());
        this.doRename(element, project2, nameSuggestionContext, editor2);
    }

    public void invoke(@NotNull Project project2, PsiElement @NotNull [] elements, DataContext dataContext2) {
        PsiElement element;
        if (project2 == null) {
            DirectoryRenameHandlerBase.$$$reportNull$$$0(2);
        }
        if (elements == null) {
            DirectoryRenameHandlerBase.$$$reportNull$$$0(3);
        }
        PsiElement psiElement = element = elements.length == 1 ? elements[0] : null;
        if (element == null) {
            element = PsiElementRenameHandler.getElement((DataContext)dataContext2);
        }
        PsiElement nameSuggestionContext = element;
        LOG.assertTrue((element = this.adjustForRename(dataContext2, element)) != null);
        Editor editor2 = (Editor)CommonDataKeys.EDITOR.getData(dataContext2);
        this.doRename(element, project2, nameSuggestionContext, editor2);
    }

    protected abstract void doRename(PsiElement var1, Project var2, PsiElement var3, Editor var4);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/rename/DirectoryRenameHandlerBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailableOnDataContext";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

