/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.ide.projectView.impl.NestingTreeStructureProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class RelatedFilesRenamer
extends AutomaticRenamer {
    private static final Logger LOG = Logger.getInstance(RelatedFilesRenamer.class.getName());

    public RelatedFilesRenamer(@NotNull PsiFile psiFile, @NotNull String newName2) {
        if (psiFile == null) {
            RelatedFilesRenamer.$$$reportNull$$$0(0);
        }
        if (newName2 == null) {
            RelatedFilesRenamer.$$$reportNull$$$0(1);
        }
        Collection<NestingTreeStructureProvider.ChildFileInfo> relatedFileInfos = NestingTreeStructureProvider.getFilesShownAsChildrenInProjectView(psiFile.getProject(), psiFile.getVirtualFile());
        for (NestingTreeStructureProvider.ChildFileInfo info2 : relatedFileInfos) {
            PsiFile relatedPsiFile = psiFile.getManager().findFile(info2.file());
            if (relatedPsiFile == null) continue;
            LOG.assertTrue(psiFile.getName().startsWith(info2.namePartCommonWithParentFile()) && relatedPsiFile.getName().startsWith(info2.namePartCommonWithParentFile()), psiFile.getName() + "," + relatedPsiFile.getName() + "," + info2.namePartCommonWithParentFile());
            String suffix = psiFile.getName().substring(info2.namePartCommonWithParentFile().length());
            LOG.assertTrue(suffix.length() > 0, psiFile.getName() + "," + info2.namePartCommonWithParentFile());
            if (!newName2.endsWith(suffix)) continue;
            String newRelatedFileName = newName2.substring(0, newName2.length() - suffix.length()) + relatedPsiFile.getName().substring(info2.namePartCommonWithParentFile().length());
            this.myElements.add(relatedPsiFile);
            this.suggestAllNames(relatedPsiFile.getName(), newRelatedFileName);
        }
    }

    public boolean isSelectedByDefault() {
        return true;
    }

    public String getDialogTitle() {
        return RefactoringBundle.message((String)"rename.title");
    }

    public String getDialogDescription() {
        return RefactoringBundle.message((String)"rename.related.file.dialog.description");
    }

    public String entityName() {
        return RefactoringBundle.message((String)"related.file");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "psiFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "newName";
                break;
            }
        }
        objectArray[1] = "com/intellij/refactoring/rename/RelatedFilesRenamer";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

