/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.find.FindBundle;
import com.intellij.ide.util.scopeChooser.ScopeChooserCombo;
import com.intellij.lang.LangBundle;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.NameSuggestionProvider;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameInputValidatorRegistry;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.RenameRefactoringDialog;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenameHandler;
import com.intellij.refactoring.rename.naming.AutomaticRenamerFactory;
import com.intellij.refactoring.ui.NameSuggestionsField;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.TextOccurrencesUtil;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.ui.SeparatorFactory;
import com.intellij.ui.TitledSeparator;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import com.intellij.util.ui.JBUI;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenameDialog
extends RefactoringDialog
implements RenameRefactoringDialog {
    private SuggestedNameInfo mySuggestedNameInfo;
    private JLabel myNameLabel;
    private NameSuggestionsField myNameSuggestionsField;
    private JCheckBox myCbSearchInComments;
    private JCheckBox myCbSearchTextOccurrences;
    private final JLabel myNewNamePrefix;
    private final String myHelpID;
    private final PsiElement myPsiElement;
    private final PsiElement myNameSuggestionContext;
    private final Editor myEditor;
    private NameSuggestionsField.DataChanged myNameChangedListener;
    private final Map<AutomaticRenamerFactory, JCheckBox> myAutoRenamerFactories;
    private String myOldName;
    private ScopeChooserCombo myScopeCombo;

    public RenameDialog(@NotNull Project project2, @NotNull PsiElement psiElement, @Nullable PsiElement nameSuggestionContext, Editor editor2) {
        if (project2 == null) {
            RenameDialog.$$$reportNull$$$0(0);
        }
        if (psiElement == null) {
            RenameDialog.$$$reportNull$$$0(1);
        }
        super(project2, true);
        this.myNewNamePrefix = new JLabel("");
        this.myAutoRenamerFactories = new HashMap<AutomaticRenamerFactory, JCheckBox>();
        PsiUtilCore.ensureValid(psiElement);
        this.myPsiElement = psiElement;
        this.myNameSuggestionContext = nameSuggestionContext;
        this.myEditor = editor2;
        this.setTitle(RenameDialog.getRefactoringName());
        this.createNewNameComponent();
        this.init();
        this.myNameLabel.setText(XmlStringUtil.wrapInHtml(XmlStringUtil.escapeString(this.getLabelText(), false)));
        boolean toSearchInComments = this.isToSearchInCommentsForRename();
        this.myCbSearchInComments.setSelected(toSearchInComments);
        if (this.isSearchForTextOccurrencesEnabled()) {
            boolean toSearchForTextOccurrences = this.isToSearchForTextOccurrencesForRename();
            this.myCbSearchTextOccurrences.setSelected(toSearchForTextOccurrences);
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.validateButtons();
        }
        this.myHelpID = RenamePsiElementProcessor.forElement(psiElement).getHelpID(psiElement);
    }

    public static void showRenameDialog(DataContext dataContext2, RenameDialog dialog) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            String name = (String)PsiElementRenameHandler.DEFAULT_NAME.getData(dataContext2);
            dialog.performRename(name);
            dialog.close(0);
        } else {
            dialog.show();
        }
    }

    @NotNull
    @NlsContexts.Label
    protected String getLabelText() {
        String string2 = RefactoringBundle.message((String)"rename.0.and.its.usages.to", (Object[])new Object[]{this.getFullName()});
        if (string2 == null) {
            RenameDialog.$$$reportNull$$$0(2);
        }
        return string2;
    }

    @NotNull
    public PsiElement getPsiElement() {
        PsiElement psiElement = this.myPsiElement;
        if (psiElement == null) {
            RenameDialog.$$$reportNull$$$0(3);
        }
        return psiElement;
    }

    @Override
    protected boolean hasPreviewButton() {
        return RenamePsiElementProcessor.forElement(this.myPsiElement).showRenamePreviewButton(this.myPsiElement);
    }

    protected void dispose() {
        this.myNameSuggestionsField.removeDataChangedListener(this.myNameChangedListener);
        super.dispose();
    }

    protected boolean isToSearchForTextOccurrencesForRename() {
        return RenamePsiElementProcessor.forElement(this.myPsiElement).isToSearchForTextOccurrences(this.myPsiElement);
    }

    protected boolean isToSearchInCommentsForRename() {
        return RenamePsiElementProcessor.forElement(this.myPsiElement).isToSearchInComments(this.myPsiElement);
    }

    protected String getFullName() {
        String name = DescriptiveNameUtil.getDescriptiveName((PsiElement)this.myPsiElement);
        String type = UsageViewUtil.getType((PsiElement)this.myPsiElement);
        return StringUtil.isEmpty(name) ? type : type + " '" + name + "'";
    }

    protected void createNewNameComponent() {
        String[] suggestedNames = this.getSuggestedNames();
        this.myOldName = UsageViewUtil.getShortName((PsiElement)this.myPsiElement);
        this.myNameSuggestionsField = new NameSuggestionsField(suggestedNames, this.myProject, FileTypes.PLAIN_TEXT, this.myEditor){

            @Override
            protected boolean shouldSelectAll() {
                return RenameDialog.this.myEditor == null || RenameDialog.this.myEditor.getSettings().isPreselectRename();
            }
        };
        if (this.myPsiElement instanceof PsiFile && this.myEditor == null) {
            this.myNameSuggestionsField.selectNameWithoutExtension();
        }
        this.myNameChangedListener = () -> this.processNewNameChanged();
        this.myNameSuggestionsField.addDataChangedListener(this.myNameChangedListener);
    }

    protected void preselectExtension(int start, int end) {
        this.myNameSuggestionsField.select(start, end);
    }

    protected void processNewNameChanged() {
        this.validateButtons();
    }

    public String[] getSuggestedNames() {
        LinkedHashSet<String> result2 = new LinkedHashSet<String>();
        String initialName = VariableInplaceRenameHandler.getInitialName();
        if (initialName != null) {
            result2.add(initialName);
        }
        result2.add(UsageViewUtil.getShortName((PsiElement)this.myPsiElement));
        this.mySuggestedNameInfo = NameSuggestionProvider.suggestNames((PsiElement)this.myPsiElement, (PsiElement)this.myNameSuggestionContext, result2);
        return ArrayUtilRt.toStringArray(result2);
    }

    @NotNull
    public String getNewName() {
        String string2 = this.myNameSuggestionsField.getEnteredName().trim();
        if (string2 == null) {
            RenameDialog.$$$reportNull$$$0(4);
        }
        return string2;
    }

    @NotNull
    public SearchScope getRefactoringScope() {
        SearchScope scope = this.myScopeCombo.getSelectedScope();
        SearchScope searchScope2 = scope != null ? scope : GlobalSearchScope.projectScope(this.myProject);
        if (searchScope2 == null) {
            RenameDialog.$$$reportNull$$$0(5);
        }
        return searchScope2;
    }

    public boolean isSearchInComments() {
        return this.myCbSearchInComments.isSelected();
    }

    public boolean isSearchInNonJavaFiles() {
        return this.myCbSearchTextOccurrences.isSelected();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameSuggestionsField.getFocusableComponent();
    }

    protected JComponent createCenterPanel() {
        return null;
    }

    protected JComponent createNorthPanel() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.insets = JBUI.insetsBottom(4);
        gbConstraints.weighty = 0.0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridwidth = 0;
        gbConstraints.fill = 1;
        this.myNameLabel = new JLabel();
        panel2.add((Component)this.myNameLabel, gbConstraints);
        gbConstraints.insets = JBUI.insets(0, 0, 4, StringUtil.isEmpty(this.myNewNamePrefix.getText()) ? 0 : 1);
        gbConstraints.gridwidth = 1;
        gbConstraints.fill = 0;
        gbConstraints.weightx = 0.0;
        gbConstraints.gridx = 0;
        gbConstraints.anchor = 17;
        panel2.add((Component)this.myNewNamePrefix, gbConstraints);
        gbConstraints.insets = JBUI.insetsBottom(8);
        gbConstraints.gridwidth = 2;
        gbConstraints.fill = 1;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridx = 0;
        gbConstraints.weighty = 1.0;
        panel2.add((Component)this.myNameSuggestionsField.getComponent(), gbConstraints);
        this.createCheckboxes(panel2, gbConstraints);
        JComponent scopePanel = this.createSearchScopePanel();
        if (scopePanel != null) {
            gbConstraints.insets = JBUI.insetsBottom(8);
            gbConstraints.gridx = 0;
            gbConstraints.gridy = -1;
            gbConstraints.gridwidth = 2;
            gbConstraints.fill = 1;
            panel2.add((Component)scopePanel, gbConstraints);
        }
        return panel2;
    }

    protected void createCheckboxes(JPanel panel2, GridBagConstraints gbConstraints) {
        gbConstraints.insets = JBUI.insetsBottom(4);
        gbConstraints.gridwidth = 1;
        gbConstraints.gridx = 0;
        gbConstraints.weighty = 0.0;
        gbConstraints.weightx = 1.0;
        gbConstraints.fill = 1;
        this.myCbSearchInComments = new NonFocusableCheckBox();
        this.myCbSearchInComments.setText(RefactoringBundle.getSearchInCommentsAndStringsText());
        this.myCbSearchInComments.setSelected(true);
        panel2.add((Component)this.myCbSearchInComments, gbConstraints);
        gbConstraints.insets = JBUI.insets(0, 10, 4, 0);
        gbConstraints.gridwidth = 0;
        gbConstraints.gridx = 1;
        gbConstraints.weightx = 1.0;
        gbConstraints.fill = 1;
        this.myCbSearchTextOccurrences = new NonFocusableCheckBox();
        this.myCbSearchTextOccurrences.setText(RefactoringBundle.getSearchForTextOccurrencesText());
        this.myCbSearchTextOccurrences.setSelected(true);
        panel2.add((Component)this.myCbSearchTextOccurrences, gbConstraints);
        if (!TextOccurrencesUtil.isSearchTextOccurrencesEnabled(this.myPsiElement)) {
            this.myCbSearchTextOccurrences.setEnabled(false);
            this.myCbSearchTextOccurrences.setSelected(false);
            this.myCbSearchTextOccurrences.setVisible(false);
        }
        for (AutomaticRenamerFactory factory2 : AutomaticRenamerFactory.EP_NAME.getExtensionList()) {
            if (!factory2.isApplicable(this.myPsiElement) || factory2.getOptionName() == null) continue;
            gbConstraints.gridwidth = this.myAutoRenamerFactories.size() % 2 == 0 ? 1 : 0;
            gbConstraints.gridx = this.myAutoRenamerFactories.size() % 2;
            gbConstraints.insets = gbConstraints.gridx == 0 ? JBUI.insetsBottom(4) : JBUI.insets(0, 10, 4, 0);
            gbConstraints.weightx = 1.0;
            gbConstraints.fill = 1;
            NonFocusableCheckBox checkBox = new NonFocusableCheckBox();
            checkBox.setText(factory2.getOptionName());
            checkBox.setSelected(factory2.isEnabled());
            panel2.add((Component)checkBox, gbConstraints);
            this.myAutoRenamerFactories.put(factory2, (JCheckBox)checkBox);
        }
    }

    @Nullable
    protected JComponent createSearchScopePanel() {
        this.myScopeCombo = new ScopeChooserCombo(this.myProject, false, true, ProjectScope.getProjectFilesScopeName());
        Disposer.register(this.myDisposable, this.myScopeCombo);
        SearchScope useScope = PsiSearchHelper.getInstance((Project)this.myProject).getUseScope(this.myPsiElement);
        if (useScope instanceof LocalSearchScope) {
            return null;
        }
        JPanel optionsPanel = new JPanel(new BorderLayout());
        optionsPanel.add((Component)((Object)this.myScopeCombo), "Center");
        TitledSeparator separator = SeparatorFactory.createSeparator((String)FindBundle.message("find.scope.label", new Object[0]), this.myScopeCombo.getComboBox());
        optionsPanel.add((Component)separator, "North");
        return optionsPanel;
    }

    protected String getHelpId() {
        return this.myHelpID;
    }

    @Override
    protected void doAction() {
        PsiUtilCore.ensureValid(this.myPsiElement);
        String newName2 = this.getNewName();
        this.performRename(newName2);
    }

    public void performRename(@NotNull String newName2) {
        if (newName2 == null) {
            RenameDialog.$$$reportNull$$$0(6);
        }
        RenamePsiElementProcessor elementProcessor = RenamePsiElementProcessor.forElement(this.myPsiElement);
        elementProcessor.setToSearchInComments(this.myPsiElement, this.isSearchInComments());
        if (this.isSearchForTextOccurrencesEnabled()) {
            elementProcessor.setToSearchForTextOccurrences(this.myPsiElement, this.isSearchInNonJavaFiles());
        }
        if (this.mySuggestedNameInfo != null) {
            this.mySuggestedNameInfo.nameChosen(newName2);
        }
        RenameProcessor processor = this.createRenameProcessor(newName2);
        for (Map.Entry<AutomaticRenamerFactory, JCheckBox> e : this.myAutoRenamerFactories.entrySet()) {
            e.getKey().setEnabled(e.getValue().isSelected());
            if (!e.getValue().isSelected()) continue;
            processor.addRenamerFactory(e.getKey());
        }
        this.invokeRefactoring(processor);
    }

    protected boolean isSearchForTextOccurrencesEnabled() {
        return this.myCbSearchTextOccurrences.isEnabled();
    }

    public RenameProcessor createRenameProcessorEx(@NotNull String newName2) {
        if (newName2 == null) {
            RenameDialog.$$$reportNull$$$0(7);
        }
        return this.createRenameProcessor(newName2);
    }

    protected RenameProcessor createRenameProcessor(@NotNull String newName2) {
        if (newName2 == null) {
            RenameDialog.$$$reportNull$$$0(8);
        }
        return new RenameProcessor(this.getProject(), this.myPsiElement, newName2, this.getRefactoringScope(), this.isSearchInComments(), this.isSearchInNonJavaFiles());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    protected void canRun() throws ConfigurationException {
        if (Comparing.strEqual(this.getNewName(), this.myOldName)) {
            throw new ConfigurationException(null);
        }
        if (!this.areButtonsValid()) {
            throw new ConfigurationException(LangBundle.message("dialog.message.valid.identifier", this.getNewName()));
        }
        @NlsContexts.DialogMessage Function inputValidator = RenameInputValidatorRegistry.getInputErrorValidator((PsiElement)this.myPsiElement);
        if (inputValidator != null) {
            this.setErrorText((String)inputValidator.fun(this.getNewName()));
        }
    }

    @Override
    protected boolean areButtonsValid() {
        String newName2 = this.getNewName();
        return RenameUtil.isValidName((Project)this.myProject, (PsiElement)this.myPsiElement, (String)newName2);
    }

    protected NameSuggestionsField getNameSuggestionsField() {
        return this.myNameSuggestionsField;
    }

    public JCheckBox getCbSearchInComments() {
        return this.myCbSearchInComments;
    }

    @NlsContexts.DialogTitle
    private static String getRefactoringName() {
        return RefactoringBundle.message((String)"rename.title");
    }

    public void close() {
        this.close(1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/rename/RenameDialog";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/rename/RenameDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabelText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefactoringScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "performRename";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createRenameProcessorEx";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createRenameProcessor";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 3, 4, 5 -> new IllegalStateException(string2);
        };
    }
}

