/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.api;

import com.intellij.refactoring.RefactoringBundle;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u0000 \u00022\u00020\u0001:\u0001\u0002\u0082\u0001\u0002\u0003\u0004\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0005\u00c0\u0006\u0001"}, d2={"Lcom/intellij/refactoring/rename/api/RenameValidationResult;", "", "Companion", "Lcom/intellij/refactoring/rename/api/RenameValidationResult$Companion$OK;", "Lcom/intellij/refactoring/rename/api/RenameValidationResult$Companion$RenameValidationResultData;", "intellij.platform.lang.impl"})
public interface RenameValidationResult {
    @NotNull
    public static final Companion Companion = com.intellij.refactoring.rename.api.RenameValidationResult$Companion.$$INSTANCE;

    @JvmStatic
    @NotNull
    public static RenameValidationResult ok() {
        return Companion.ok();
    }

    @JvmStatic
    @NotNull
    public static RenameValidationResult warn(@NotNull String message) {
        return Companion.warn(message);
    }

    @JvmStatic
    @NotNull
    public static RenameValidationResult invalid() {
        return Companion.invalid();
    }

    @JvmStatic
    @NotNull
    public static RenameValidationResult invalid(@NotNull String message) {
        return Companion.invalid(message);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0003\n\u000b\fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\u0015\u0010\u0003\u001a\u00020\u00042\u000b\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007H\u0007J\b\u0010\b\u001a\u00020\u0004H\u0007J\u0015\u0010\t\u001a\u00020\u00042\u000b\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007H\u0007\u00a8\u0006\r"}, d2={"Lcom/intellij/refactoring/rename/api/RenameValidationResult$Companion;", "", "()V", "invalid", "Lcom/intellij/refactoring/rename/api/RenameValidationResult;", "message", "", "Lcom/intellij/openapi/util/NlsContexts$DialogMessage;", "ok", "warn", "OK", "RenameValidationResultData", "RenameValidationResultProblemLevel", "intellij.platform.lang.impl"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final RenameValidationResult ok() {
            return OK.INSTANCE;
        }

        @JvmStatic
        @NotNull
        public final RenameValidationResult warn(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            return new RenameValidationResultData(message, RenameValidationResultProblemLevel.WARNING);
        }

        @JvmStatic
        @NotNull
        public final RenameValidationResult invalid() {
            return new RenameValidationResultData(null, RenameValidationResultProblemLevel.ERROR);
        }

        @JvmStatic
        @NotNull
        public final RenameValidationResult invalid(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            return new RenameValidationResultData(message, RenameValidationResultProblemLevel.ERROR);
        }

        static {
            $$INSTANCE = new Companion();
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/refactoring/rename/api/RenameValidationResult$Companion$OK;", "Lcom/intellij/refactoring/rename/api/RenameValidationResult;", "()V", "intellij.platform.lang.impl"})
        public static final class OK
        implements RenameValidationResult {
            @NotNull
            public static final OK INSTANCE = new OK();

            private OK() {
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0080\b\u0018\u00002\u00020\u0001B\u001c\u0012\r\u0010\u0002\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\n\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0004H\u00c2\u0003J\t\u0010\u000b\u001a\u00020\u0006H\u00c6\u0003J$\u0010\f\u001a\u00020\u00002\u000f\b\u0002\u0010\u0002\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\u0013\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u00042\u0006\u0010\u0013\u001a\u00020\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0015\u0010\u0002\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/refactoring/rename/api/RenameValidationResult$Companion$RenameValidationResultData;", "Lcom/intellij/refactoring/rename/api/RenameValidationResult;", "message", "", "Lcom/intellij/openapi/util/NlsContexts$DialogMessage;", "level", "Lcom/intellij/refactoring/rename/api/RenameValidationResult$Companion$RenameValidationResultProblemLevel;", "(Ljava/lang/String;Lcom/intellij/refactoring/rename/api/RenameValidationResult$Companion$RenameValidationResultProblemLevel;)V", "getLevel", "()Lcom/intellij/refactoring/rename/api/RenameValidationResult$Companion$RenameValidationResultProblemLevel;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "newName", "toString", "intellij.platform.lang.impl"})
        public static final class RenameValidationResultData
        implements RenameValidationResult {
            @Nullable
            private final String message;
            @NotNull
            private final RenameValidationResultProblemLevel level;

            public RenameValidationResultData(@Nullable String message, @NotNull RenameValidationResultProblemLevel level) {
                Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
                this.message = message;
                this.level = level;
            }

            @NotNull
            public final RenameValidationResultProblemLevel getLevel() {
                return this.level;
            }

            @NotNull
            public final String message(@NotNull String newName2) {
                Intrinsics.checkNotNullParameter((Object)newName2, (String)"newName");
                String string2 = this.message;
                if (string2 == null) {
                    Object[] objectArray = new Object[]{newName2};
                    String string3 = RefactoringBundle.message((String)"automatic.renaming.dialog.identifier.invalid.error", (Object[])objectArray);
                    string2 = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"automatic.renam\u2026.invalid.error\", newName)");
                }
                return string2;
            }

            private final String component1() {
                return this.message;
            }

            @NotNull
            public final RenameValidationResultProblemLevel component2() {
                return this.level;
            }

            @NotNull
            public final RenameValidationResultData copy(@Nullable String message, @NotNull RenameValidationResultProblemLevel level) {
                Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
                return new RenameValidationResultData(message, level);
            }

            public static /* synthetic */ RenameValidationResultData copy$default(RenameValidationResultData renameValidationResultData, String string2, RenameValidationResultProblemLevel renameValidationResultProblemLevel, int n, Object object) {
                if ((n & 1) != 0) {
                    string2 = renameValidationResultData.message;
                }
                if ((n & 2) != 0) {
                    renameValidationResultProblemLevel = renameValidationResultData.level;
                }
                return renameValidationResultData.copy(string2, renameValidationResultProblemLevel);
            }

            @NotNull
            public String toString() {
                return "RenameValidationResultData(message=" + this.message + ", level=" + this.level + ")";
            }

            public int hashCode() {
                int result2 = this.message == null ? 0 : this.message.hashCode();
                result2 = result2 * 31 + this.level.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof RenameValidationResultData)) {
                    return false;
                }
                RenameValidationResultData renameValidationResultData = (RenameValidationResultData)other;
                if (!Intrinsics.areEqual((Object)this.message, (Object)renameValidationResultData.message)) {
                    return false;
                }
                return this.level == renameValidationResultData.level;
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/refactoring/rename/api/RenameValidationResult$Companion$RenameValidationResultProblemLevel;", "", "(Ljava/lang/String;I)V", "WARNING", "ERROR", "intellij.platform.lang.impl"})
        public static final class RenameValidationResultProblemLevel
        extends Enum<RenameValidationResultProblemLevel> {
            public static final /* enum */ RenameValidationResultProblemLevel WARNING = new RenameValidationResultProblemLevel();
            public static final /* enum */ RenameValidationResultProblemLevel ERROR = new RenameValidationResultProblemLevel();
            private static final /* synthetic */ RenameValidationResultProblemLevel[] $VALUES;

            public static RenameValidationResultProblemLevel[] values() {
                return (RenameValidationResultProblemLevel[])$VALUES.clone();
            }

            public static RenameValidationResultProblemLevel valueOf(String value) {
                return Enum.valueOf(RenameValidationResultProblemLevel.class, value);
            }

            static {
                $VALUES = renameValidationResultProblemLevelArray = new RenameValidationResultProblemLevel[]{RenameValidationResultProblemLevel.WARNING, RenameValidationResultProblemLevel.ERROR};
            }
        }
    }
}

