/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.impl;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.refactoring.rename.api.FileOperation;
import com.intellij.refactoring.suggested.UtilsKt;
import com.intellij.util.DocumentUtil;
import com.intellij.util.io.PathKt;
import com.intellij.util.text.StringOperation;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B{\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003\u0012\u0018\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u0012\u0018\u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b0\u00040\u0003\u0012\u0018\u0010\f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00060\u00040\u0003\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010\u0015\u001a\u00020\u0016J\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00060\u0018R#\u0010\f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00060\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R#\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R#\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R#\u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b0\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lcom/intellij/refactoring/rename/impl/FileUpdates;", "", "filesToAdd", "", "Lkotlin/Pair;", "Ljava/nio/file/Path;", "", "filesToMove", "Lcom/intellij/openapi/vfs/VirtualFile;", "filesToRemove", "filesToRename", "", "documentModifications", "Lcom/intellij/openapi/editor/RangeMarker;", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getDocumentModifications", "()Ljava/util/List;", "getFilesToAdd", "getFilesToMove", "getFilesToRemove", "getFilesToRename", "doUpdate", "", "preview", "", "Companion", "intellij.platform.lang.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nFileUpdates.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileUpdates.kt\ncom/intellij/refactoring/rename/impl/FileUpdates\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,162:1\n1477#2:163\n1502#2,3:164\n1505#2,3:174\n1477#2:177\n1502#2,3:178\n1505#2,3:188\n1603#2,9:191\n1855#2:200\n1856#2:202\n1612#2:203\n1360#2:211\n1446#2,5:212\n361#3,7:167\n361#3,7:181\n361#3,7:204\n361#3,7:217\n1#4:201\n*S KotlinDebug\n*F\n+ 1 FileUpdates.kt\ncom/intellij/refactoring/rename/impl/FileUpdates\n*L\n39#1:163\n39#1:164,3\n39#1:174,3\n86#1:177\n86#1:178,3\n86#1:188,3\n91#1:191,9\n91#1:200\n91#1:202\n91#1:203\n97#1:211\n97#1:212,5\n39#1:167,7\n86#1:181,7\n97#1:204,7\n103#1:217,7\n91#1:201\n*E\n"})
public final class FileUpdates {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Pair<Path, CharSequence>> filesToAdd;
    @NotNull
    private final List<Pair<VirtualFile, Path>> filesToMove;
    @NotNull
    private final List<VirtualFile> filesToRemove;
    @NotNull
    private final List<Pair<VirtualFile, String>> filesToRename;
    @NotNull
    private final List<Pair<RangeMarker, CharSequence>> documentModifications;
    @NotNull
    private static final Logger LOG;

    public FileUpdates(@NotNull List<? extends Pair<? extends Path, ? extends CharSequence>> filesToAdd, @NotNull List<? extends Pair<? extends VirtualFile, ? extends Path>> filesToMove, @NotNull List<? extends VirtualFile> filesToRemove, @NotNull List<? extends Pair<? extends VirtualFile, String>> filesToRename, @NotNull List<? extends Pair<? extends RangeMarker, ? extends CharSequence>> documentModifications) {
        Intrinsics.checkNotNullParameter(filesToAdd, (String)"filesToAdd");
        Intrinsics.checkNotNullParameter(filesToMove, (String)"filesToMove");
        Intrinsics.checkNotNullParameter(filesToRemove, (String)"filesToRemove");
        Intrinsics.checkNotNullParameter(filesToRename, (String)"filesToRename");
        Intrinsics.checkNotNullParameter(documentModifications, (String)"documentModifications");
        this.filesToAdd = filesToAdd;
        this.filesToMove = filesToMove;
        this.filesToRemove = filesToRemove;
        this.filesToRename = filesToRename;
        this.documentModifications = documentModifications;
    }

    @NotNull
    public final List<Pair<Path, CharSequence>> getFilesToAdd() {
        return this.filesToAdd;
    }

    @NotNull
    public final List<Pair<VirtualFile, Path>> getFilesToMove() {
        return this.filesToMove;
    }

    @NotNull
    public final List<VirtualFile> getFilesToRemove() {
        return this.filesToRemove;
    }

    @NotNull
    public final List<Pair<VirtualFile, String>> getFilesToRename() {
        return this.filesToRename;
    }

    @NotNull
    public final List<Pair<RangeMarker, CharSequence>> getDocumentModifications() {
        return this.documentModifications;
    }

    /*
     * WARNING - void declaration
     */
    public final void doUpdate() {
        void $this$groupByTo$iv$iv;
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        for (VirtualFile virtualFile3 : this.filesToRemove) {
            if (!virtualFile3.isValid()) {
                LOG.warn("Cannot apply rename patch: invalid file to remove. File: " + virtualFile3);
                continue;
            }
            virtualFile3.delete(this);
        }
        Iterable $this$groupBy$iv = this.documentModifications;
        boolean bl = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            Pair pair = (Pair)element$iv$iv;
            boolean bl2 = false;
            RangeMarker rangeMarker = (RangeMarker)pair.component1();
            Document key$iv$iv = rangeMarker.getDocument();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl22 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map byDocument = destination$iv$iv;
        for (Map.Entry entry : byDocument.entrySet()) {
            Document document = (Document)entry.getKey();
            List modifications = (List)entry.getValue();
            DocumentUtil.executeInBulk(document, () -> FileUpdates.doUpdate$lambda$1(modifications, document));
        }
        for (Pair pair : this.filesToMove) {
            VirtualFile parentFile;
            Path parentPath;
            VirtualFile virtualFile2 = (VirtualFile)pair.component1();
            Path path2 = (Path)pair.component2();
            if (!virtualFile2.isValid()) {
                LOG.warn("Cannot apply rename patch: invalid file to move. File: " + virtualFile2);
                continue;
            }
            if (path2.getParent() == null || VfsUtil.findFile(parentPath, false) == null) continue;
            if (!Intrinsics.areEqual((Object)parentFile, (Object)virtualFile2.getParent())) {
                virtualFile2.move(this, parentFile);
            }
            String newFileName = ((Object)path2.getFileName()).toString();
            if (Intrinsics.areEqual((Object)virtualFile2.getName(), (Object)newFileName)) continue;
            virtualFile2.rename(this, newFileName);
        }
        for (Pair pair : this.filesToRename) {
            VirtualFile virtualFile2 = (VirtualFile)pair.component1();
            String newName2 = (String)pair.component2();
            if (!virtualFile2.isValid()) {
                LOG.warn("Cannot apply rename patch: invalid file to rename. File: " + virtualFile2);
                continue;
            }
            virtualFile2.rename(this, newName2);
        }
        for (Pair pair : this.filesToAdd) {
            Path path3 = (Path)pair.component1();
            CharSequence content2 = (CharSequence)pair.component2();
            PathKt.write$default(path3, content2, null, false, 6, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<VirtualFile, CharSequence> preview() {
        List operations;
        Object value$iv$iv$iv;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Iterable $this$groupBy$iv = this.documentModifications;
        boolean $i$f$groupBy = false;
        Iterable iterator22 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : iterator22) {
            Object object;
            Pair pair = (Pair)element$iv$iv;
            boolean bl = false;
            RangeMarker rangeMarker = (RangeMarker)pair.component1();
            Document key$iv$iv = rangeMarker.getDocument();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map byDocument = destination$iv$iv;
        HashMap documentOperations = new HashMap(byDocument.size());
        for (Map.Entry entry : byDocument.entrySet()) {
            Object object;
            Object $this$getOrPut$iv;
            void $this$mapNotNullTo$iv$iv;
            Document document = (Document)entry.getKey();
            List modifications = (List)entry.getValue();
            Object $this$mapNotNull$iv = modifications;
            boolean $i$f$mapNotNull = false;
            Iterable bl = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            value$iv$iv$iv = $this$forEach$iv$iv$iv.iterator();
            while (value$iv$iv$iv.hasNext()) {
                StringOperation stringOperation;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = value$iv$iv$iv.next();
                boolean bl3 = false;
                Pair pair = (Pair)element$iv$iv;
                boolean bl4 = false;
                RangeMarker rangeMarker = (RangeMarker)pair.component1();
                CharSequence replacement = (CharSequence)pair.component2();
                if (UtilsKt.getRange(rangeMarker) != null) {
                    TextRange range;
                    boolean bl5 = false;
                    stringOperation = StringOperation.replace(range, replacement);
                } else {
                    stringOperation = null;
                }
                if (stringOperation == null) continue;
                StringOperation it$iv$iv = stringOperation;
                boolean bl6 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            operations = (List)destination$iv$iv2;
            if (document instanceof DocumentWindow) {
                void $this$flatMapTo$iv$iv;
                Object object2;
                Document key$iv;
                $this$mapNotNull$iv = documentOperations;
                Intrinsics.checkNotNullExpressionValue((Object)((DocumentWindow)document).getDelegate(), (String)"document.delegate");
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl7 = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object2 = answer$iv;
                } else {
                    object2 = value$iv;
                }
                $this$getOrPut$iv = (Collection)object2;
                Iterable $this$flatMap$iv = operations;
                boolean $i$f$flatMap = false;
                value$iv = $this$flatMap$iv;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    TextRange range;
                    StringOperation operation = (StringOperation)element$iv$iv;
                    boolean bl8 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)operation.getRange(), (String)"operation.range");
                    Collection<StringOperation> collection = ((DocumentWindow)document).prepareReplaceString(range.getStartOffset(), range.getEndOffset(), operation.getReplacement());
                    Intrinsics.checkNotNullExpressionValue(collection, (String)"document.prepareReplaceS\u2026t, operation.replacement)");
                    Iterable list$iv$iv = collection;
                    CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
                }
                $this$flatMap$iv = (List)destination$iv$iv3;
                CollectionsKt.addAll((Collection)$this$getOrPut$iv, (Iterable)$this$flatMap$iv);
                continue;
            }
            $this$getOrPut$iv = documentOperations;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(document);
            if (value$iv == null) {
                boolean bl9 = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(document, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            CollectionsKt.addAll((Collection)((Collection)object), (Iterable)operations);
        }
        HashMap fileText = new HashMap(byDocument.size());
        for (Map.Entry entry : ((Map)documentOperations).entrySet()) {
            CharSequence charSequence;
            VirtualFile virtualFile2;
            Document document = (Document)entry.getKey();
            operations = (List)entry.getValue();
            if (!(!(document instanceof DocumentWindow))) {
                String string2 = "Check failed.";
                throw new IllegalStateException(string2.toString());
            }
            if (FileDocumentManager.getInstance().getFile(document) == null) {
                String string3 = "Required value was null.";
                throw new IllegalArgumentException(string3.toString());
            }
            Map map2 = fileText;
            Intrinsics.checkNotNullExpressionValue((Object)StringOperation.applyOperations(document.getCharsSequence(), operations), (String)"applyOperations(document\u2026harsSequence, operations)");
            map2.put(virtualFile2, charSequence);
        }
        return fileText;
    }

    private static final void doUpdate$lambda$1(List $modifications, Document $document) {
        Intrinsics.checkNotNullParameter((Object)$modifications, (String)"$modifications");
        Intrinsics.checkNotNullParameter((Object)$document, (String)"$document");
        for (Pair pair : $modifications) {
            RangeMarker rangeMarker = (RangeMarker)pair.component1();
            CharSequence replacement = (CharSequence)pair.component2();
            if (!rangeMarker.isValid()) {
                LOG.warn("Cannot apply rename patch: invalid range marker. Document: " + $document + ", marker: " + rangeMarker);
                continue;
            }
            $document.replaceString(rangeMarker.getStartOffset(), rangeMarker.getEndOffset(), replacement);
            rangeMarker.dispose();
        }
    }

    static {
        Logger logger = Logger.getInstance(FileUpdates.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(FileUpdates::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u001c\u0010\f\u001a\u0004\u0018\u00010\b2\b\u0010\r\u001a\u0004\u0018\u00010\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\bR\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lcom/intellij/refactoring/rename/impl/FileUpdates$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG$intellij_platform_lang_impl", "()Lcom/intellij/openapi/diagnostic/Logger;", "createFileUpdates", "Lcom/intellij/refactoring/rename/impl/FileUpdates;", "fileOperations", "", "Lcom/intellij/refactoring/rename/api/FileOperation;", "merge", "left", "right", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG$intellij_platform_lang_impl() {
            return LOG;
        }

        @Nullable
        public final FileUpdates merge(@Nullable FileUpdates left, @Nullable FileUpdates right) {
            return left == null ? right : (right == null ? left : new FileUpdates(CollectionsKt.plus((Collection)left.getFilesToAdd(), (Iterable)right.getFilesToAdd()), CollectionsKt.plus((Collection)left.getFilesToMove(), (Iterable)right.getFilesToMove()), CollectionsKt.plus((Collection)left.getFilesToRemove(), (Iterable)right.getFilesToRemove()), CollectionsKt.plus((Collection)left.getFilesToRename(), (Iterable)right.getFilesToRename()), CollectionsKt.plus((Collection)left.getDocumentModifications(), (Iterable)right.getDocumentModifications())));
        }

        @NotNull
        public final FileUpdates createFileUpdates(@NotNull Collection<? extends FileOperation> fileOperations) {
            Intrinsics.checkNotNullParameter(fileOperations, (String)"fileOperations");
            ApplicationManager.getApplication().assertReadAccessAllowed();
            ArrayList filesToAdd = new ArrayList();
            ArrayList filesToMove = new ArrayList();
            ArrayList filesToRemove = new ArrayList();
            ArrayList filesToRename = new ArrayList();
            ArrayList fileModifications = new ArrayList();
            for (FileOperation fileOperation : fileOperations) {
                FileOperation fileOperation2 = fileOperation;
                if (fileOperation2 instanceof FileOperation.Add) {
                    ((Collection)filesToAdd).add(new Pair((Object)((FileOperation.Add)fileOperation).getPath(), (Object)((FileOperation.Add)fileOperation).getContent()));
                    continue;
                }
                if (fileOperation2 instanceof FileOperation.Move) {
                    ((Collection)filesToMove).add(new Pair((Object)((FileOperation.Move)fileOperation).getFile(), (Object)((FileOperation.Move)fileOperation).getPath()));
                    continue;
                }
                if (fileOperation2 instanceof FileOperation.Remove) {
                    ((Collection)filesToRemove).add(((FileOperation.Remove)fileOperation).getFile());
                    continue;
                }
                if (fileOperation2 instanceof FileOperation.Rename) {
                    ((Collection)filesToRename).add(new Pair((Object)((FileOperation.Rename)fileOperation).getFile(), (Object)((FileOperation.Rename)fileOperation).getNewName()));
                    continue;
                }
                if (!(fileOperation2 instanceof FileOperation.Modify) || FileDocumentManager.getInstance().getDocument(((FileOperation.Modify)fileOperation).getFile().getVirtualFile()) == null) continue;
                for (StringOperation stringOperation : ((FileOperation.Modify)fileOperation).getModifications()) {
                    RangeMarker rangeMarker;
                    Document document;
                    Intrinsics.checkNotNullExpressionValue((Object)document.createRangeMarker(stringOperation.getRange()), (String)"document.createRangeMarker(stringOperation.range)");
                    ((Collection)fileModifications).add(new Pair((Object)rangeMarker, (Object)stringOperation.getReplacement()));
                }
            }
            return new FileUpdates(filesToAdd, filesToMove, filesToRemove, filesToRename, fileModifications);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

