/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.impl;

import com.intellij.model.Symbol;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.refactoring.rename.Renamer;
import com.intellij.refactoring.rename.RenamerFactory;
import com.intellij.refactoring.rename.api.RenameTarget;
import com.intellij.refactoring.rename.impl.RenameTargetRenamer;
import com.intellij.refactoring.rename.symbol.RenameableSymbol;
import com.intellij.refactoring.rename.symbol.SymbolRenameTargetFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/intellij/refactoring/rename/impl/SymbolRenameTargetRenamerFactory;", "Lcom/intellij/refactoring/rename/RenamerFactory;", "()V", "createRenamers", "", "Lcom/intellij/refactoring/rename/Renamer;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "renameTarget", "Lcom/intellij/refactoring/rename/api/RenameTarget;", "project", "Lcom/intellij/openapi/project/Project;", "symbol", "Lcom/intellij/model/Symbol;", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nSymbolRenameTargetRenamerFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SymbolRenameTargetRenamerFactory.kt\ncom/intellij/refactoring/rename/impl/SymbolRenameTargetRenamerFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,51:1\n1603#2,9:52\n1855#2:61\n1856#2:63\n1612#2:64\n1549#2:65\n1620#2,3:66\n1#3:62\n*S KotlinDebug\n*F\n+ 1 SymbolRenameTargetRenamerFactory.kt\ncom/intellij/refactoring/rename/impl/SymbolRenameTargetRenamerFactory\n*L\n28#1:52,9\n28#1:61\n28#1:63\n28#1:64\n33#1:65\n33#1:66,3\n28#1:62\n*E\n"})
public final class SymbolRenameTargetRenamerFactory
implements RenamerFactory {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<Renamer> createRenamers(@NotNull DataContext dataContext2) {
        void $this$mapTo$iv$iv;
        Object element$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)dataContext2, (String)"dataContext");
        Project project2 = (Project)dataContext2.getData(CommonDataKeys.PROJECT);
        if (project2 == null) {
            return CollectionsKt.emptyList();
        }
        Project project3 = project2;
        List list2 = (List)dataContext2.getData(CommonDataKeys.SYMBOLS);
        if (list2 == null) {
            return CollectionsKt.emptyList();
        }
        Collection symbols = list2;
        if (symbols.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$mapNotNull$iv = symbols;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo22 = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            RenameTarget it$iv$iv;
            Object element$iv$iv$iv;
            element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Symbol symbol = (Symbol)element$iv$iv;
            boolean bl2 = false;
            if (this.renameTarget(project3, symbol) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Collection allRenameTargets = (List)destination$iv$iv;
        Collection distinctRenameTargets = CollectionsKt.toSet((Iterable)allRenameTargets);
        Editor editor2 = (Editor)dataContext2.getData(CommonDataKeys.EDITOR);
        Iterable $this$map$iv = distinctRenameTargets;
        boolean $i$f$map = false;
        Iterable $i$f$mapNotNullTo22 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void target2;
            element$iv$iv = (RenameTarget)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(new RenameTargetRenamer(project3, editor2, (RenameTarget)target2));
        }
        return (List)destination$iv$iv2;
    }

    private final RenameTarget renameTarget(Project project2, Symbol symbol) {
        SymbolRenameTargetFactory[] symbolRenameTargetFactoryArray = SymbolRenameTargetFactory.EP_NAME.getExtensions();
        int n = symbolRenameTargetFactoryArray.length;
        for (int j = 0; j < n; ++j) {
            SymbolRenameTargetFactory factory2;
            Intrinsics.checkNotNullExpressionValue((Object)symbolRenameTargetFactoryArray[j], (String)"SymbolRenameTargetFactory.EP_NAME.extensions");
            RenameTarget renameTarget = factory2.renameTarget(project2, symbol);
            if (renameTarget == null) continue;
            return renameTarget;
        }
        if (symbol instanceof RenameableSymbol) {
            return ((RenameableSymbol)symbol).getRenameTarget();
        }
        if (symbol instanceof RenameTarget) {
            return (RenameTarget)((Object)symbol);
        }
        return null;
    }
}

