/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.inplace;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.lookup.LookupFocusDegree;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.LangBundle;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.impl.FinishMarkAction;
import com.intellij.openapi.command.impl.StartMarkAction;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.ImaginaryEditor;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageEditorUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.inplace.MyLookupExpression;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenamer;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.DottedBorder;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Query;
import com.intellij.util.containers.NotNullList;
import com.intellij.util.ui.PositionTracker;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InplaceRefactoring {
    protected static final Logger LOG = Logger.getInstance(VariableInplaceRenamer.class);
    @NonNls
    protected static final String PRIMARY_VARIABLE_NAME = "PrimaryVariable";
    @NonNls
    protected static final String OTHER_VARIABLE_NAME = "OtherVariable";
    public static final Key<Boolean> INPLACE_RENAME_ALLOWED = Key.create("EditorInplaceRenameAllowed");
    public static final Key<InplaceRefactoring> INPLACE_RENAMER = Key.create("EditorInplaceRenamer");
    public static final Key<Boolean> INTRODUCE_RESTART = Key.create("INTRODUCE_RESTART");
    private static boolean ourShowBalloonInHeadlessMode;
    protected PsiNamedElement myElementToRename;
    protected final Editor myEditor;
    protected final Project myProject;
    protected RangeMarker myRenameOffset;
    protected @NlsContexts.PopupAdvertisement String myAdvertisementText;
    private ArrayList<RangeHighlighter> myHighlighters;
    protected String myInitialName;
    protected String myOldName;
    protected RangeMarker myBeforeRevert;
    protected String myInsertedName;
    protected LinkedHashSet<String> myNameSuggestions;
    protected StartMarkAction myMarkAction;
    protected PsiElement myScope;
    protected RangeMarker myCaretRangeMarker;
    protected Balloon myBalloon;
    protected @NlsContexts.Command String myTitle;
    protected RelativePoint myTarget;

    public InplaceRefactoring(@NotNull Editor editor2, @Nullable PsiNamedElement elementToRename, @NotNull Project project2) {
        if (editor2 == null) {
            InplaceRefactoring.$$$reportNull$$$0(0);
        }
        if (project2 == null) {
            InplaceRefactoring.$$$reportNull$$$0(1);
        }
        this(editor2, elementToRename, project2, elementToRename != null ? elementToRename.getName() : null, elementToRename != null ? elementToRename.getName() : null);
    }

    public InplaceRefactoring(@NotNull Editor editor2, @Nullable PsiNamedElement elementToRename, @NotNull Project project2, @Nullable String oldName) {
        if (editor2 == null) {
            InplaceRefactoring.$$$reportNull$$$0(2);
        }
        if (project2 == null) {
            InplaceRefactoring.$$$reportNull$$$0(3);
        }
        this(editor2, elementToRename, project2, elementToRename != null ? elementToRename.getName() : null, oldName);
    }

    public InplaceRefactoring(@NotNull Editor editor2, @Nullable PsiNamedElement elementToRename, @NotNull Project project2, @Nullable String initialName, @Nullable String oldName) {
        if (editor2 == null) {
            InplaceRefactoring.$$$reportNull$$$0(4);
        }
        if (project2 == null) {
            InplaceRefactoring.$$$reportNull$$$0(5);
        }
        this.myEditor = editor2;
        this.myElementToRename = elementToRename;
        this.myProject = project2;
        this.myOldName = oldName;
        if (this.myElementToRename != null) {
            this.myInitialName = initialName;
            PsiFile containingFile = this.myElementToRename.getContainingFile();
            FileViewProvider viewProvider = containingFile.getViewProvider();
            if (!this.notSameFile(InplaceRefactoring.getTopLevelVirtualFile(viewProvider), containingFile) && this.myElementToRename.getTextRange() != null) {
                this.myRenameOffset = this.myEditor.getDocument().createRangeMarker(this.myElementToRename.getTextRange());
                this.myRenameOffset.setGreedyToRight(true);
                this.myRenameOffset.setGreedyToLeft(true);
            }
        }
    }

    public static void unableToStartWarning(Project project2, @NotNull Editor editor2) {
        if (editor2 == null) {
            InplaceRefactoring.$$$reportNull$$$0(6);
        }
        StartMarkAction startMarkAction = StartMarkAction.canStart((Editor)editor2);
        String message = IdeBundle.message((String)"dialog.message.command.not.finished.yet", (Object[])new Object[]{startMarkAction.getCommandName()});
        Document oldDocument = startMarkAction.getDocument();
        if (oldDocument != editor2.getDocument()) {
            int exitCode = Messages.showYesNoDialog((Project)project2, (String)message, (String)RefactoringBundle.getCannotRefactorMessage(null), (String)RefactoringBundle.message((String)"inplace.refactoring.continue.started"), (String)RefactoringBundle.message((String)"inplace.refactoring.abandon.started"), (Icon)Messages.getErrorIcon());
            InplaceRefactoring.navigateToStarted(oldDocument, project2, exitCode, startMarkAction.getCommandName());
        } else {
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor2, (String)message, (String)RefactoringBundle.getCannotRefactorMessage(null), null);
        }
    }

    public void setAdvertisementText(@NlsContexts.PopupAdvertisement String advertisementText) {
        this.myAdvertisementText = advertisementText;
    }

    public boolean performInplaceRefactoring(@Nullable LinkedHashSet<String> nameSuggestions) {
        if (this.myEditor instanceof ImaginaryEditor && this.myEditor.getUserData(INPLACE_RENAME_ALLOWED) != Boolean.TRUE) {
            return false;
        }
        this.myNameSuggestions = nameSuggestions;
        if (InjectedLanguageUtil.isInInjectedLanguagePrefixSuffix(this.myElementToRename)) {
            return false;
        }
        FileViewProvider fileViewProvider = this.myElementToRename.getContainingFile().getViewProvider();
        VirtualFile file2 = InplaceRefactoring.getTopLevelVirtualFile(fileViewProvider);
        SearchScope referencesSearchScope = this.getReferencesSearchScope(file2);
        Collection references = ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ReadAction.compute(() -> {
            Collection<PsiReference> refs = this.collectRefs(referencesSearchScope);
            this.addReferenceAtCaret(refs);
            return refs;
        }), RefactoringBundle.message((String)"progress.title.collecting.references"), true, this.myProject);
        if (references == null) {
            return false;
        }
        for (PsiReference ref : references) {
            PsiFile containingFile = ref.getElement().getContainingFile();
            if (!this.notSameFile(file2, containingFile)) continue;
            return false;
        }
        PsiElement scope = this.checkLocalScope();
        if (scope == null) {
            return false;
        }
        PsiFile containingFile = scope.getContainingFile();
        if (containingFile == null) {
            return false;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)this.myProject, (PsiElement)containingFile)) {
            return true;
        }
        this.myEditor.putUserData(INPLACE_RENAMER, (Object)this);
        NotNullList<Pair<PsiElement, TextRange>> stringUsages = new NotNullList<Pair<PsiElement, TextRange>>();
        this.collectAdditionalElementsToRename(stringUsages);
        try {
            return this.buildTemplateAndStart(references, stringUsages, scope, containingFile);
        }
        catch (Throwable e) {
            this.myEditor.putUserData(INPLACE_RENAMER, null);
            FinishMarkAction.finish((Project)this.myProject, (Editor)this.myEditor, (StartMarkAction)this.myMarkAction);
            throw e;
        }
    }

    protected boolean notSameFile(@Nullable VirtualFile file2, @NotNull PsiFile containingFile) {
        if (containingFile == null) {
            InplaceRefactoring.$$$reportNull$$$0(7);
        }
        return !Comparing.equal(InplaceRefactoring.getTopLevelVirtualFile(containingFile.getViewProvider()), file2);
    }

    protected SearchScope getReferencesSearchScope(VirtualFile file2) {
        if (file2 == null) {
            return ProjectScope.getProjectScope(this.myElementToRename.getProject());
        }
        PsiFile containingFile = this.myElementToRename.getContainingFile();
        if (!file2.equals(containingFile.getVirtualFile())) {
            PsiFile topLevelFile = PsiManager.getInstance(this.myProject).findFile(file2);
            return topLevelFile == null ? ProjectScope.getProjectScope(this.myElementToRename.getProject()) : new LocalSearchScope(topLevelFile);
        }
        return new LocalSearchScope(containingFile);
    }

    @Nullable
    protected PsiElement checkLocalScope() {
        SearchScope searchScope2 = PsiSearchHelper.getInstance((Project)this.myElementToRename.getProject()).getUseScope((PsiElement)this.myElementToRename);
        if (searchScope2 instanceof LocalSearchScope) {
            PsiElement[] elements = this.getElements((LocalSearchScope)searchScope2);
            return PsiTreeUtil.findCommonParent(elements);
        }
        return null;
    }

    private PsiElement @NotNull [] getElements(LocalSearchScope searchScope2) {
        PsiElement[] elements = searchScope2.getScope();
        FileViewProvider provider2 = this.myElementToRename.getContainingFile().getViewProvider();
        for (PsiElement element : elements) {
            if (element instanceof PsiFile && ((PsiFile)element).getViewProvider() == provider2) continue;
            if (elements == null) {
                InplaceRefactoring.$$$reportNull$$$0(8);
            }
            return elements;
        }
        PsiElement[] psiElementArray = new PsiElement[]{this.myElementToRename.getContainingFile()};
        if (psiElementArray == null) {
            InplaceRefactoring.$$$reportNull$$$0(9);
        }
        return psiElementArray;
    }

    protected void collectAdditionalElementsToRename(@NotNull List<? super Pair<PsiElement, TextRange>> stringUsages) {
        if (stringUsages == null) {
            InplaceRefactoring.$$$reportNull$$$0(10);
        }
    }

    protected abstract boolean shouldSelectAll();

    protected MyLookupExpression createLookupExpression(PsiElement selectedElement) {
        return new MyLookupExpression(this.getInitialName(), this.myNameSuggestions, this.myElementToRename, selectedElement, this.shouldSelectAll(), this.myAdvertisementText);
    }

    protected Expression createTemplateExpression(PsiElement selectedElement) {
        return this.createLookupExpression(selectedElement);
    }

    protected boolean acceptReference(PsiReference reference2) {
        return true;
    }

    protected Collection<PsiReference> collectRefs(SearchScope referencesSearchScope) {
        Query search2 = ReferencesSearch.search((PsiElement)this.myElementToRename, (SearchScope)referencesSearchScope, (boolean)false);
        CommonProcessors.CollectProcessor<PsiReference> processor = new CommonProcessors.CollectProcessor<PsiReference>(){

            @Override
            protected boolean accept(PsiReference reference2) {
                ProgressManager.checkCanceled();
                return InplaceRefactoring.this.acceptReference(reference2);
            }
        };
        search2.forEach(processor);
        return processor.getResults();
    }

    protected boolean buildTemplateAndStart(@NotNull Collection<PsiReference> refs, @NotNull Collection<Pair<PsiElement, TextRange>> stringUsages, @NotNull PsiElement scope, @NotNull PsiFile containingFile) {
        if (refs == null) {
            InplaceRefactoring.$$$reportNull$$$0(11);
        }
        if (stringUsages == null) {
            InplaceRefactoring.$$$reportNull$$$0(12);
        }
        if (scope == null) {
            InplaceRefactoring.$$$reportNull$$$0(13);
        }
        if (containingFile == null) {
            InplaceRefactoring.$$$reportNull$$$0(14);
        }
        PsiLanguageInjectionHost context2 = InjectedLanguageManager.getInstance(containingFile.getProject()).getInjectionHost(containingFile);
        Editor topLevelEditor = InjectedLanguageEditorUtil.getTopLevelEditor(this.myEditor);
        this.myScope = context2 == null || topLevelEditor == this.myEditor ? scope : context2.getContainingFile();
        TemplateBuilderImpl builder2 = new TemplateBuilderImpl(this.myScope);
        PsiElement nameIdentifier = this.getNameIdentifier();
        int offset2 = topLevelEditor.getCaretModel().getOffset();
        PsiElement selectedElement = this.getSelectedInEditorElement(nameIdentifier, refs, stringUsages, offset2);
        boolean subrefOnPrimaryElement = false;
        boolean hasReferenceOnNameIdentifier = false;
        for (PsiReference psiReference : refs) {
            if (this.isReferenceAtCaret(selectedElement, psiReference, offset2)) {
                Expression expression = this.createTemplateExpression(selectedElement);
                builder2.replaceElement(psiReference.getElement(), this.getRangeToRename(psiReference), PRIMARY_VARIABLE_NAME, expression, this.shouldStopAtLookupExpression(expression));
                subrefOnPrimaryElement = true;
                continue;
            }
            this.addVariable(psiReference, selectedElement, builder2, offset2);
            hasReferenceOnNameIdentifier |= this.isReferenceAtCaret(nameIdentifier, psiReference);
        }
        if (!(nameIdentifier == null || subrefOnPrimaryElement && (hasReferenceOnNameIdentifier |= selectedElement.getTextRange().contains(nameIdentifier.getTextRange())))) {
            this.addVariable(nameIdentifier, selectedElement, builder2);
        }
        for (Pair pair : stringUsages) {
            this.addVariable((PsiElement)pair.first, (TextRange)pair.second, selectedElement, builder2);
        }
        this.addAdditionalVariables(builder2);
        int segmentsLimit = Registry.intValue("inplace.rename.segments.limit", -1);
        if (segmentsLimit != -1 && builder2.getElementsCount() > segmentsLimit) {
            return false;
        }
        try {
            this.myMarkAction = this.startRename();
        }
        catch (StartMarkAction.AlreadyStartedException alreadyStartedException) {
            Document oldDocument = alreadyStartedException.getDocument();
            if (oldDocument != this.myEditor.getDocument()) {
                int exitCode = Messages.showYesNoCancelDialog((Project)this.myProject, (String)alreadyStartedException.getMessage(), (String)this.getCommandName(), (String)RefactoringBundle.message((String)"inplace.refactoring.navigate.to.started"), (String)RefactoringBundle.message((String)"inplace.refactoring.abandon.started"), (String)RefactoringBundle.message((String)"inplace.refactoring.cancel.current"), (Icon)Messages.getErrorIcon());
                this.navigateToAlreadyStarted(oldDocument, exitCode);
                return true;
            }
            this.revertState();
            TemplateState templateState2 = TemplateManagerImpl.getTemplateState(topLevelEditor);
            if (templateState2 != null) {
                templateState2.gotoEnd(true);
            }
            return false;
        }
        this.beforeTemplateStart();
        WriteCommandAction.writeCommandAction(this.myProject).withName(this.getCommandName()).run(() -> this.startTemplate(builder2));
        this.afterTemplateStart();
        if (this.myBalloon == null) {
            this.showBalloon();
        }
        return true;
    }

    protected boolean shouldStopAtLookupExpression(Expression expression) {
        return expression instanceof MyLookupExpression;
    }

    protected boolean isReferenceAtCaret(PsiElement selectedElement, PsiReference ref, int offset2) {
        return this.isReferenceAtCaret(selectedElement, ref) && this.checkRangeContainsOffset(offset2, ref.getRangeInElement(), ref.getElement());
    }

    protected boolean isReferenceAtCaret(PsiElement selectedElement, PsiReference ref) {
        TextRange textRange = ref.getRangeInElement().shiftRight(ref.getElement().getTextRange().getStartOffset());
        if (selectedElement != null) {
            TextRange selectedElementRange = selectedElement.getTextRange();
            LOG.assertTrue(selectedElementRange != null, selectedElement);
            if (selectedElementRange.contains(textRange)) {
                return true;
            }
        }
        return false;
    }

    protected void beforeTemplateStart() {
        this.myCaretRangeMarker = this.myEditor.getDocument().createRangeMarker(this.myEditor.getCaretModel().getOffset(), this.myEditor.getCaretModel().getOffset());
        this.myCaretRangeMarker.setGreedyToLeft(true);
        this.myCaretRangeMarker.setGreedyToRight(true);
    }

    protected void afterTemplateStart() {
    }

    private void startTemplate(TemplateBuilderImpl builder2) {
        MyTemplateListener templateListener = new MyTemplateListener();
        int offset2 = this.myEditor.getCaretModel().getOffset();
        Editor topLevelEditor = InjectedLanguageEditorUtil.getTopLevelEditor(this.myEditor);
        TextRange range = this.myScope.getTextRange();
        assert (range != null);
        RangeMarker rangeMarker = topLevelEditor.getDocument().createRangeMarker(range);
        Template template = builder2.buildInlineTemplate();
        template.setToShortenLongNames(false);
        template.setToReformat(false);
        this.myHighlighters = new ArrayList();
        topLevelEditor.getCaretModel().moveToOffset(rangeMarker.getStartOffset());
        TemplateManager.getInstance(this.myProject).startTemplate(topLevelEditor, template, templateListener);
        InplaceRefactoring.restoreOldCaretPositionAndSelection(this.myEditor, this.restoreCaretOffset(offset2), this::restoreSelection);
        this.highlightTemplateVariables(template, topLevelEditor);
        TemplateState templateState2 = TemplateManagerImpl.getTemplateState(topLevelEditor);
        if (templateState2 != null) {
            DaemonCodeAnalyzer.getInstance(this.myProject).disableUpdateByTimer(templateState2);
        }
    }

    private void highlightTemplateVariables(Template template, Editor topLevelEditor) {
        if (this.myHighlighters != null) {
            Map<TextRange, TextAttributes> rangesToHighlight;
            TemplateState templateState2 = TemplateManagerImpl.getTemplateState(topLevelEditor);
            if (templateState2 == null) {
                rangesToHighlight = Collections.emptyMap();
            } else {
                EditorColorsManager colorsManager = EditorColorsManager.getInstance();
                rangesToHighlight = new HashMap();
                InplaceRefactoring.variableHighlights(template, templateState2).forEach((range, attributesKey) -> {
                    TextAttributes attributes = colorsManager.getGlobalScheme().getAttributes(attributesKey);
                    if (attributes != null) {
                        TextAttributesWithKey attributesWithKey = new TextAttributesWithKey(attributes, (TextAttributesKey)attributesKey);
                        rangesToHighlight.put((TextRange)range, attributesWithKey);
                    }
                });
            }
            this.addHighlights(rangesToHighlight, topLevelEditor, this.myHighlighters, HighlightManager.getInstance((Project)this.myProject));
        }
    }

    @NotNull
    private static Map<TextRange, TextAttributesKey> variableHighlights(@NotNull Template template, @NotNull TemplateState templateState2) {
        if (template == null) {
            InplaceRefactoring.$$$reportNull$$$0(15);
        }
        if (templateState2 == null) {
            InplaceRefactoring.$$$reportNull$$$0(16);
        }
        HashMap<TextRange, TextAttributesKey> rangesToHighlight = new HashMap<TextRange, TextAttributesKey>();
        for (int i2 = 0; i2 < templateState2.getSegmentsCount(); ++i2) {
            TextAttributesKey attributesKey;
            TextRange segmentOffset = templateState2.getSegmentRange(i2);
            String name = template.getSegmentName(i2);
            if (name.equals(PRIMARY_VARIABLE_NAME)) {
                attributesKey = EditorColors.WRITE_SEARCH_RESULT_ATTRIBUTES;
            } else {
                if (!name.equals(OTHER_VARIABLE_NAME)) continue;
                attributesKey = EditorColors.SEARCH_RESULT_ATTRIBUTES;
            }
            rangesToHighlight.put(segmentOffset, attributesKey);
        }
        HashMap<TextRange, TextAttributesKey> hashMap = rangesToHighlight;
        if (hashMap == null) {
            InplaceRefactoring.$$$reportNull$$$0(17);
        }
        return hashMap;
    }

    static void restoreOldCaretPositionAndSelection(@NotNull Editor editor2, int restoredCaretOffset, @NotNull Runnable restoreSelection) {
        if (editor2 == null) {
            InplaceRefactoring.$$$reportNull$$$0(18);
        }
        if (restoreSelection == null) {
            InplaceRefactoring.$$$reportNull$$$0(19);
        }
        Runnable runnable = () -> {
            editor2.getCaretModel().moveToOffset(restoredCaretOffset);
            restoreSelection.run();
        };
        LookupImpl lookup2 = (LookupImpl)LookupManager.getActiveLookup(editor2);
        if (lookup2 != null && lookup2.getLookupStart() <= restoredCaretOffset) {
            lookup2.setLookupFocusDegree(LookupFocusDegree.UNFOCUSED);
            lookup2.performGuardedChange(runnable);
        } else {
            runnable.run();
        }
    }

    protected void restoreSelection() {
    }

    protected int restoreCaretOffset(int offset2) {
        return this.myCaretRangeMarker.isValid() ? this.myCaretRangeMarker.getEndOffset() : offset2;
    }

    public void stopIntroduce(Editor editor2) {
        InplaceRefactoring.stopIntroduce(editor2, this.myProject, this.getCommandName());
    }

    public static void stopIntroduce(Editor editor2, Project project2, @NlsContexts.Command String commandName2) {
        TemplateState templateState2 = TemplateManagerImpl.getTemplateState(editor2);
        if (templateState2 != null) {
            Runnable runnable = () -> templateState2.gotoEnd(true);
            CommandProcessor.getInstance().executeCommand(project2, runnable, commandName2, commandName2);
        }
    }

    protected void navigateToAlreadyStarted(Document oldDocument, int exitCode) {
        this.finish(true);
        if (exitCode != 2) {
            InplaceRefactoring.navigateToStarted(oldDocument, this.myProject, exitCode, this.getCommandName());
        }
    }

    private static void navigateToStarted(Document oldDocument, Project project2, @Messages.YesNoResult int exitCode, @NlsContexts.Command String commandName2) {
        PsiFile file2 = PsiDocumentManager.getInstance(project2).getPsiFile(oldDocument);
        if (file2 != null) {
            VirtualFile virtualFile2 = file2.getVirtualFile();
            if (virtualFile2 instanceof VirtualFileWindow) {
                virtualFile2 = ((VirtualFileWindow)((Object)virtualFile2)).getDelegate();
            }
            if (virtualFile2 != null) {
                FileEditor[] editors2;
                for (FileEditor editor2 : editors2 = FileEditorManager.getInstance(project2).getEditors(virtualFile2)) {
                    Editor textEditor;
                    TemplateState templateState2;
                    if (!(editor2 instanceof TextEditor) || (templateState2 = TemplateManagerImpl.getTemplateState(textEditor = ((TextEditor)editor2).getEditor())) == null) continue;
                    if (exitCode == 0) {
                        TextRange range = templateState2.getVariableRange(PRIMARY_VARIABLE_NAME);
                        if (range == null) continue;
                        PsiNavigationSupport.getInstance().createNavigatable(project2, virtualFile2, range.getStartOffset()).navigate(true);
                        return;
                    }
                    if (exitCode <= 0) continue;
                    InplaceRefactoring.stopIntroduce(textEditor, project2, commandName2);
                    return;
                }
            }
        }
    }

    @Nullable
    protected PsiElement getNameIdentifier() {
        return this.myElementToRename instanceof PsiNameIdentifierOwner ? ((PsiNameIdentifierOwner)this.myElementToRename).getNameIdentifier() : null;
    }

    public static EditorEx createPreviewComponent(Project project2, FileType languageFileType) {
        Document document = EditorFactory.getInstance().createDocument((CharSequence)"");
        UndoUtil.disableUndoFor(document);
        EditorEx previewEditor = (EditorEx)EditorFactory.getInstance().createEditor(document, project2, languageFileType, true);
        previewEditor.setOneLineMode(true);
        EditorSettings settings = previewEditor.getSettings();
        settings.setAdditionalLinesCount(0);
        settings.setAdditionalColumnsCount(1);
        settings.setRightMarginShown(false);
        settings.setFoldingOutlineShown(false);
        settings.setLineNumbersShown(false);
        settings.setLineMarkerAreaShown(false);
        settings.setIndentGuidesShown(false);
        settings.setVirtualSpace(false);
        previewEditor.setHorizontalScrollbarVisible(false);
        previewEditor.setVerticalScrollbarVisible(false);
        previewEditor.setCaretEnabled(false);
        settings.setLineCursorWidth(1);
        Color bg = previewEditor.getColorsScheme().getColor(EditorColors.CARET_ROW_COLOR);
        previewEditor.setBackgroundColor(bg);
        previewEditor.setBorder((Border)BorderFactory.createCompoundBorder((Border)new DottedBorder((Color)JBColor.GRAY), new LineBorder(bg, 2)));
        return previewEditor;
    }

    @Nullable
    protected StartMarkAction startRename() throws StartMarkAction.AlreadyStartedException {
        return InplaceRefactoring.startMarkAction(this.myProject, this.myEditor, this.getCommandName());
    }

    @NotNull
    static StartMarkAction startMarkAction(@NotNull Project project2, @NotNull Editor editor2, @NlsContexts.Command String commandName2) throws StartMarkAction.AlreadyStartedException {
        if (project2 == null) {
            InplaceRefactoring.$$$reportNull$$$0(20);
        }
        if (editor2 == null) {
            InplaceRefactoring.$$$reportNull$$$0(21);
        }
        StartMarkAction[] markAction = new StartMarkAction[1];
        StartMarkAction.AlreadyStartedException[] ex = new StartMarkAction.AlreadyStartedException[1];
        CommandProcessor.getInstance().executeCommand(project2, () -> {
            try {
                markAction[0] = StartMarkAction.start((Editor)editor2, (Project)project2, (String)commandName2);
            }
            catch (StartMarkAction.AlreadyStartedException e) {
                ex[0] = e;
            }
        }, commandName2, null);
        if (ex[0] != null) {
            throw ex[0];
        }
        StartMarkAction startMarkAction = markAction[0];
        if (startMarkAction == null) {
            InplaceRefactoring.$$$reportNull$$$0(22);
        }
        return startMarkAction;
    }

    @Nullable
    protected PsiNamedElement getVariable() {
        PsiFile psiFile;
        if (this.myElementToRename != null && this.myElementToRename.isValid()) {
            if (Comparing.strEqual(this.myOldName, this.myElementToRename.getName())) {
                return this.myElementToRename;
            }
            if (this.myRenameOffset != null) {
                return PsiTreeUtil.findElementOfClassAtRange(this.myElementToRename.getContainingFile(), this.myRenameOffset.getStartOffset(), this.myRenameOffset.getEndOffset(), PsiNameIdentifierOwner.class);
            }
        }
        if (this.myRenameOffset != null && (psiFile = PsiDocumentManager.getInstance(this.myProject).getPsiFile(this.myEditor.getDocument())) != null) {
            return PsiTreeUtil.findElementOfClassAtRange(psiFile, this.myRenameOffset.getStartOffset(), this.myRenameOffset.getEndOffset(), PsiNameIdentifierOwner.class);
        }
        return this.myElementToRename;
    }

    protected void moveOffsetAfter(boolean success) {
        if (this.myCaretRangeMarker != null) {
            this.myCaretRangeMarker.dispose();
        }
    }

    protected void addAdditionalVariables(TemplateBuilderImpl builder2) {
    }

    protected void addReferenceAtCaret(Collection<? super PsiReference> refs) {
        PsiFile myEditorFile = PsiDocumentManager.getInstance(this.myProject).getPsiFile(this.myEditor.getDocument());
        PsiReference reference2 = (myEditorFile != null ? myEditorFile : this.myElementToRename.getContainingFile()).findReferenceAt(this.myEditor.getCaretModel().getOffset());
        if (reference2 instanceof PsiMultiReference) {
            PsiReference[] references;
            for (PsiReference ref : references = ((PsiMultiReference)reference2).getReferences()) {
                this.addReferenceIfNeeded(refs, ref);
            }
        } else {
            this.addReferenceIfNeeded(refs, reference2);
        }
    }

    private void addReferenceIfNeeded(@NotNull Collection<? super PsiReference> refs, @Nullable PsiReference reference2) {
        if (refs == null) {
            InplaceRefactoring.$$$reportNull$$$0(23);
        }
        if (reference2 != null && reference2.isReferenceTo(this.myElementToRename) && !refs.contains(reference2)) {
            refs.add(reference2);
        }
    }

    protected void showDialogAdvertisement(@NonNls @Nullable String actionId) {
        Shortcut shortcut = KeymapUtil.getPrimaryShortcut((String)actionId);
        if (shortcut != null) {
            this.setAdvertisementText(RefactoringBundle.message((String)"inplace.refactoring.advertisement.text", (Object[])new Object[]{KeymapUtil.getShortcutText((Shortcut)shortcut)}));
        }
    }

    public String getInitialName() {
        if (this.myInitialName == null) {
            PsiNamedElement variable = this.getVariable();
            if (variable != null) {
                return variable.getName();
            }
            LOG.error("Initial name should be provided");
            return "";
        }
        return this.myInitialName;
    }

    protected void revertState() {
        if (this.myOldName == null) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
            Editor topLevelEditor = InjectedLanguageEditorUtil.getTopLevelEditor(this.myEditor);
            ApplicationManager.getApplication().runWriteAction(() -> {
                TemplateState state = TemplateManagerImpl.getTemplateState(topLevelEditor);
                if (state != null) {
                    int segmentsCount = state.getSegmentsCount();
                    Document document = topLevelEditor.getDocument();
                    for (int i2 = 0; i2 < segmentsCount; ++i2) {
                        TextRange segmentRange = state.getSegmentRange(i2);
                        document.replaceString(segmentRange.getStartOffset(), segmentRange.getEndOffset(), this.myOldName);
                    }
                }
            });
            if (!this.myProject.isDisposed() && this.myProject.isOpen()) {
                PsiDocumentManager.getInstance(this.myProject).commitDocument(topLevelEditor.getDocument());
            }
        }, this.getCommandName(), null);
    }

    @NlsContexts.Command
    protected abstract String getCommandName();

    public void finish(boolean success) {
        if (this.myHighlighters != null) {
            if (!this.myProject.isDisposed()) {
                HighlightManager highlightManager = HighlightManager.getInstance((Project)this.myProject);
                for (RangeHighlighter highlighter : this.myHighlighters) {
                    highlightManager.removeSegmentHighlighter(this.myEditor, highlighter);
                }
            }
            this.myHighlighters = null;
        }
        this.myEditor.putUserData(INPLACE_RENAMER, null);
        if (this.myBalloon != null && !this.isRestart()) {
            this.myBalloon.hide();
        }
    }

    protected void addHighlights(@NotNull Map<TextRange, TextAttributes> ranges2, @NotNull Editor editor2, @NotNull Collection<RangeHighlighter> highlighters, @NotNull HighlightManager highlightManager) {
        if (ranges2 == null) {
            InplaceRefactoring.$$$reportNull$$$0(24);
        }
        if (editor2 == null) {
            InplaceRefactoring.$$$reportNull$$$0(25);
        }
        if (highlighters == null) {
            InplaceRefactoring.$$$reportNull$$$0(26);
        }
        if (highlightManager == null) {
            InplaceRefactoring.$$$reportNull$$$0(27);
        }
        for (Map.Entry<TextRange, TextAttributes> entry : ranges2.entrySet()) {
            TextRange range = entry.getKey();
            TextAttributes attributes = entry.getValue();
            if (attributes instanceof TextAttributesWithKey) {
                TextAttributesKey attributesKey = ((TextAttributesWithKey)attributes).getTextAttributesKey();
                highlightManager.addOccurrenceHighlight(editor2, range.getStartOffset(), range.getEndOffset(), attributesKey, 0, highlighters);
                continue;
            }
            highlightManager.addOccurrenceHighlight(editor2, range.getStartOffset(), range.getEndOffset(), attributes, 0, highlighters, null);
        }
        for (RangeHighlighter highlighter : highlighters) {
            highlighter.setGreedyToLeft(true);
            highlighter.setGreedyToRight(true);
        }
    }

    protected abstract boolean performRefactoring();

    protected void performCleanup() {
    }

    private void addVariable(PsiReference reference2, PsiElement selectedElement, TemplateBuilderImpl builder2, int offset2) {
        PsiElement element = reference2.getElement();
        if (element == selectedElement && this.checkRangeContainsOffset(offset2, reference2.getRangeInElement(), element)) {
            Expression expression = this.createTemplateExpression(selectedElement);
            builder2.replaceElement(reference2.getElement(), this.getRangeToRename(reference2), PRIMARY_VARIABLE_NAME, expression, this.shouldStopAtLookupExpression(expression));
        } else {
            builder2.replaceElement(reference2.getElement(), this.getRangeToRename(reference2), OTHER_VARIABLE_NAME, PRIMARY_VARIABLE_NAME, false);
        }
    }

    private void addVariable(PsiElement element, PsiElement selectedElement, TemplateBuilderImpl builder2) {
        this.addVariable(element, null, selectedElement, builder2);
    }

    private void addVariable(PsiElement element, @Nullable TextRange textRange, PsiElement selectedElement, TemplateBuilderImpl builder2) {
        if (element == selectedElement) {
            Expression expression = this.createTemplateExpression(this.myElementToRename);
            builder2.replaceElement(element, this.getRangeToRename(element), PRIMARY_VARIABLE_NAME, expression, this.shouldStopAtLookupExpression(expression));
        } else {
            builder2.replaceElement(element, Objects.requireNonNullElseGet(textRange, () -> this.getRangeToRename(element)), OTHER_VARIABLE_NAME, PRIMARY_VARIABLE_NAME, false);
        }
    }

    @NotNull
    protected TextRange getRangeToRename(@NotNull PsiElement element) {
        if (element == null) {
            InplaceRefactoring.$$$reportNull$$$0(28);
        }
        return new TextRange(0, element.getTextLength());
    }

    @NotNull
    protected TextRange getRangeToRename(@NotNull PsiReference reference2) {
        if (reference2 == null) {
            InplaceRefactoring.$$$reportNull$$$0(29);
        }
        TextRange textRange = reference2.getRangeInElement();
        if (textRange == null) {
            InplaceRefactoring.$$$reportNull$$$0(30);
        }
        return textRange;
    }

    public void setElementToRename(PsiNamedElement elementToRename) {
        this.myElementToRename = elementToRename;
    }

    protected boolean isIdentifier(String newName2, Language language) {
        return LanguageNamesValidation.isIdentifier(language, newName2, this.myProject);
    }

    @NotNull
    protected static VirtualFile getTopLevelVirtualFile(@NotNull FileViewProvider fileViewProvider) {
        VirtualFile file2;
        if (fileViewProvider == null) {
            InplaceRefactoring.$$$reportNull$$$0(31);
        }
        if ((file2 = fileViewProvider.getVirtualFile()) instanceof VirtualFileWindow) {
            file2 = ((VirtualFileWindow)((Object)file2)).getDelegate();
        }
        VirtualFile virtualFile2 = file2;
        if (virtualFile2 == null) {
            InplaceRefactoring.$$$reportNull$$$0(32);
        }
        return virtualFile2;
    }

    protected PsiElement getSelectedInEditorElement(@Nullable PsiElement nameIdentifier, @NotNull Collection<? extends PsiReference> refs, @NotNull Collection<? extends Pair<PsiElement, TextRange>> stringUsages, int offset2) {
        TextRange range;
        if (refs == null) {
            InplaceRefactoring.$$$reportNull$$$0(33);
        }
        if (stringUsages == null) {
            InplaceRefactoring.$$$reportNull$$$0(34);
        }
        for (PsiReference psiReference : refs) {
            PsiElement element = psiReference.getElement();
            if (!this.checkRangeContainsOffset(offset2, psiReference.getRangeInElement(), element)) continue;
            return element;
        }
        if (nameIdentifier != null && (range = nameIdentifier.getTextRange()) != null && this.checkRangeContainsOffset(offset2, range, nameIdentifier, 0)) {
            return nameIdentifier;
        }
        for (Pair pair : stringUsages) {
            if (!this.checkRangeContainsOffset(offset2, (TextRange)pair.second, (PsiElement)pair.first)) continue;
            return (PsiElement)pair.first;
        }
        LOG.error(nameIdentifier + " by " + this.getClass().getName());
        return null;
    }

    private boolean checkRangeContainsOffset(int offset2, TextRange textRange, PsiElement element) {
        return this.checkRangeContainsOffset(offset2, textRange, element, element.getTextRange().getStartOffset());
    }

    protected boolean checkRangeContainsOffset(int offset2, TextRange textRange, PsiElement element, int shiftOffset) {
        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance(this.myProject);
        PsiLanguageInjectionHost injectionHost = injectedLanguageManager.getInjectionHost(element);
        if (injectionHost != null) {
            PsiLanguageInjectionHost initialInjectedHost;
            PsiElement nameIdentifier = this.getNameIdentifier();
            PsiLanguageInjectionHost psiLanguageInjectionHost = initialInjectedHost = nameIdentifier != null ? injectedLanguageManager.getInjectionHost(nameIdentifier) : null;
            if (initialInjectedHost != null && initialInjectedHost != injectionHost) {
                return false;
            }
            return injectedLanguageManager.injectedToHost(element, textRange).shiftRight(shiftOffset).containsOffset(offset2);
        }
        return textRange.shiftRight(shiftOffset).containsOffset(offset2);
    }

    protected boolean isRestart() {
        Boolean isRestart = (Boolean)this.myEditor.getUserData(INTRODUCE_RESTART);
        return isRestart != null && isRestart != false;
    }

    public static boolean canStartAnotherRefactoring(@NotNull Editor editor2, RefactoringActionHandler handler2, PsiElement ... element) {
        if (editor2 == null) {
            InplaceRefactoring.$$$reportNull$$$0(35);
        }
        InplaceRefactoring inplaceRefactoring = InplaceRefactoring.getActiveInplaceRenamer(editor2);
        return StartMarkAction.canStart((Editor)editor2) == null || inplaceRefactoring != null && inplaceRefactoring.startsOnTheSameElements(editor2, handler2, element);
    }

    public static InplaceRefactoring getActiveInplaceRenamer(Editor editor2) {
        return editor2 != null ? (InplaceRefactoring)editor2.getUserData(INPLACE_RENAMER) : null;
    }

    protected boolean startsOnTheSameElements(Editor editor2, RefactoringActionHandler handler2, PsiElement[] element) {
        return element.length == 1 && this.startsOnTheSameElement(handler2, element[0]);
    }

    protected boolean startsOnTheSameElement(RefactoringActionHandler handler2, PsiElement element) {
        return this.getVariable() == element;
    }

    protected void releaseResources() {
    }

    @Nullable
    protected JComponent getComponent() {
        return null;
    }

    protected void showBalloon() {
        JComponent component2 = this.getComponent();
        if (component2 == null) {
            return;
        }
        Dimension size = component2.getPreferredSize();
        if (size.height == 0 && size.width == 0) {
            return;
        }
        if (!ourShowBalloonInHeadlessMode && ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return;
        }
        BalloonBuilder balloonBuilder = JBPopupFactory.getInstance().createDialogBalloonBuilder(component2, null).setSmallVariant(true);
        Color borderColor = UIManager.getColor("InplaceRefactoringPopup.borderColor");
        if (borderColor != null) {
            balloonBuilder.setBorderColor(borderColor);
        }
        this.adjustBalloon(balloonBuilder);
        this.myBalloon = balloonBuilder.createBalloon();
        Disposer.register(this.myProject, (Disposable)this.myBalloon);
        Disposer.register((Disposable)this.myBalloon, () -> {
            this.releaseIfNotRestart();
            this.myEditor.putUserData(PopupFactoryImpl.ANCHOR_POPUP_POSITION, null);
        });
        EditorUtil.disposeWithEditor((Editor)this.myEditor, (Disposable)this.myBalloon);
        this.myEditor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        this.showBalloonInEditor();
    }

    protected void showBalloonInEditor() {
        final JBPopupFactory popupFactory = JBPopupFactory.getInstance();
        this.myBalloon.show((PositionTracker)new PositionTracker<Balloon>((Component)this.myEditor.getContentComponent()){

            @Override
            public RelativePoint recalculateLocation(@NotNull Balloon object) {
                if (object == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (InplaceRefactoring.this.myTarget != null && !popupFactory.isBestPopupLocationVisible(InplaceRefactoring.this.myEditor)) {
                    return InplaceRefactoring.this.myTarget;
                }
                if (InplaceRefactoring.this.myCaretRangeMarker != null && InplaceRefactoring.this.myCaretRangeMarker.isValid()) {
                    InplaceRefactoring.this.myEditor.putUserData(PopupFactoryImpl.ANCHOR_POPUP_POSITION, (Object)InplaceRefactoring.this.myEditor.offsetToVisualPosition(InplaceRefactoring.this.myCaretRangeMarker.getStartOffset()));
                }
                RelativePoint target2 = popupFactory.guessBestPopupLocation(InplaceRefactoring.this.myEditor);
                Point screenPoint = target2.getScreenPoint();
                int y = screenPoint.y;
                if (target2.getPoint().getY() > (double)InplaceRefactoring.this.myEditor.getLineHeight() + InplaceRefactoring.this.myBalloon.getPreferredSize().getHeight()) {
                    y -= InplaceRefactoring.this.myEditor.getLineHeight();
                }
                InplaceRefactoring.this.myTarget = new RelativePoint(new Point(screenPoint.x, y));
                return InplaceRefactoring.this.myTarget;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/refactoring/rename/inplace/InplaceRefactoring$2", "recalculateLocation"));
            }
        }, Balloon.Position.above);
    }

    protected void adjustBalloon(BalloonBuilder builder2) {
    }

    protected void releaseIfNotRestart() {
        if (!this.isRestart()) {
            this.releaseResources();
        }
    }

    public static boolean isShowBalloonInHeadlessMode() {
        return ourShowBalloonInHeadlessMode;
    }

    public static void setShowBalloonInHeadlessMode(boolean showBalloonInHeadlessMode) {
        ourShowBalloonInHeadlessMode = showBalloonInHeadlessMode;
    }

    @NotNull
    @NlsContexts.PopupAdvertisement
    public static String getPopupOptionsAdvertisement() {
        Shortcut shortcut = KeymapUtil.getPrimaryShortcut((String)"SelectVirtualTemplateElement");
        if (shortcut != null) {
            String string2 = RefactoringBundle.message((String)"inplace.refactoring.tab.advertisement.text", (Object[])new Object[]{KeymapUtil.getShortcutText((Shortcut)shortcut)});
            if (string2 == null) {
                InplaceRefactoring.$$$reportNull$$$0(36);
            }
            return string2;
        }
        String enterShortcut = KeymapUtil.getFirstKeyboardShortcutText((String)"EditorChooseLookupItem");
        String tabShortcut = KeymapUtil.getFirstKeyboardShortcutText((String)"EditorChooseLookupItemReplace");
        String string3 = LangBundle.message("popup.advertisement.press.or.to.replace", enterShortcut, tabShortcut);
        if (string3 == null) {
            InplaceRefactoring.$$$reportNull$$$0(37);
        }
        return string3;
    }

    protected final void initPopupOptionsAdvertisement() {
        this.setAdvertisementText(InplaceRefactoring.getPopupOptionsAdvertisement());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 17, 22, 30, 32, 36, 37 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 8: 
            case 9: 
            case 17: 
            case 22: 
            case 30: 
            case 32: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/rename/inplace/InplaceRefactoring";
                break;
            }
            case 10: 
            case 12: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringUsages";
                break;
            }
            case 11: 
            case 23: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateState";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restoreSelection";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighters";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightManager";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileViewProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/rename/inplace/InplaceRefactoring";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getElements";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "variableHighlights";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "startMarkAction";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeToRename";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelVirtualFile";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getPopupOptionsAdvertisement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "unableToStartWarning";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "notSameFile";
                break;
            }
            case 8: 
            case 9: 
            case 17: 
            case 22: 
            case 30: 
            case 32: 
            case 36: 
            case 37: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "collectAdditionalElementsToRename";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "buildTemplateAndStart";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "variableHighlights";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "restoreOldCaretPositionAndSelection";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "startMarkAction";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addReferenceIfNeeded";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "addHighlights";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getRangeToRename";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelVirtualFile";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedInEditorElement";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "canStartAnotherRefactoring";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 8, 9, 17, 22, 30, 32, 36, 37 -> new IllegalStateException(string2);
        };
    }

    private class MyTemplateListener
    extends TemplateEditingAdapter {
        private MyTemplateListener() {
        }

        @Override
        public void beforeTemplateFinished(@NotNull TemplateState templateState2, Template template) {
            TextResult value;
            if (templateState2 == null) {
                MyTemplateListener.$$$reportNull$$$0(0);
            }
            InplaceRefactoring.this.myInsertedName = (value = templateState2.getVariableValue(InplaceRefactoring.PRIMARY_VARIABLE_NAME)) != null ? value.toString().trim() : null;
            TextRange range = templateState2.getCurrentVariableRange();
            int currentOffset = InplaceRefactoring.this.myEditor.getCaretModel().getOffset();
            if (range == null && InplaceRefactoring.this.myRenameOffset != null) {
                range = InplaceRefactoring.this.myRenameOffset.getTextRange();
            }
            RangeMarker rangeMarker = InplaceRefactoring.this.myBeforeRevert = range != null && range.getEndOffset() >= currentOffset && range.getStartOffset() <= currentOffset ? InplaceRefactoring.this.myEditor.getDocument().createRangeMarker(range.getStartOffset(), currentOffset) : null;
            if (InplaceRefactoring.this.myBeforeRevert != null) {
                InplaceRefactoring.this.myBeforeRevert.setGreedyToRight(true);
            }
            InplaceRefactoring.this.finish(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void templateFinished(@NotNull Template template, boolean brokenOff) {
            if (template == null) {
                MyTemplateListener.$$$reportNull$$$0(1);
            }
            boolean bind = false;
            try {
                if (!brokenOff) {
                    bind = InplaceRefactoring.this.performRefactoring();
                } else {
                    InplaceRefactoring.this.performCleanup();
                }
                InplaceRefactoring.this.moveOffsetAfter(!brokenOff);
            }
            finally {
                if (!bind) {
                    try {
                        Editor editor2 = InjectedLanguageEditorUtil.getTopLevelEditor(InplaceRefactoring.this.myEditor);
                        if (editor2 instanceof EditorImpl) {
                            ((EditorImpl)editor2).stopDumbLater();
                        }
                    }
                    finally {
                        FinishMarkAction.finish((Project)InplaceRefactoring.this.myProject, (Editor)InplaceRefactoring.this.myEditor, (StartMarkAction)InplaceRefactoring.this.myMarkAction);
                        if (InplaceRefactoring.this.myBeforeRevert != null) {
                            InplaceRefactoring.this.myBeforeRevert.dispose();
                        }
                    }
                }
            }
        }

        @Override
        public void templateCancelled(Template template) {
            try {
                PsiDocumentManager documentManager = PsiDocumentManager.getInstance(InplaceRefactoring.this.myProject);
                documentManager.commitAllDocuments();
                InplaceRefactoring.this.finish(false);
                InplaceRefactoring.this.moveOffsetAfter(false);
            }
            finally {
                FinishMarkAction.finish((Project)InplaceRefactoring.this.myProject, (Editor)InplaceRefactoring.this.myEditor, (StartMarkAction)InplaceRefactoring.this.myMarkAction);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "templateState";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "template";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/refactoring/rename/inplace/InplaceRefactoring$MyTemplateListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeTemplateFinished";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "templateFinished";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class TextAttributesWithKey
    extends TextAttributes {
        @NotNull
        private final TextAttributesKey myTextAttributesKey;

        TextAttributesWithKey(@NotNull TextAttributes textAttributes, @NotNull TextAttributesKey textAttributesKey) {
            if (textAttributes == null) {
                TextAttributesWithKey.$$$reportNull$$$0(0);
            }
            if (textAttributesKey == null) {
                TextAttributesWithKey.$$$reportNull$$$0(1);
            }
            this.myTextAttributesKey = textAttributesKey;
            this.copyFrom(textAttributes);
        }

        @NotNull
        TextAttributesKey getTextAttributesKey() {
            TextAttributesKey textAttributesKey = this.myTextAttributesKey;
            if (textAttributesKey == null) {
                TextAttributesWithKey.$$$reportNull$$$0(2);
            }
            return textAttributesKey;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textAttributes";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textAttributesKey";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/refactoring/rename/inplace/InplaceRefactoring$TextAttributesWithKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/refactoring/rename/inplace/InplaceRefactoring$TextAttributesWithKey";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextAttributesKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2 -> new IllegalStateException(string2);
            };
        }
    }
}

