/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.inplace;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TemplateResultListener;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.codeInsight.template.impl.Variable;
import com.intellij.ide.nls.NlsMessages;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.model.Pointer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.impl.FinishMarkAction;
import com.intellij.openapi.command.impl.StartMarkAction;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.refactoring.InplaceRefactoringContinuation;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.api.ModifiableRenameUsage;
import com.intellij.refactoring.rename.api.PsiRenameUsage;
import com.intellij.refactoring.rename.api.RenameTarget;
import com.intellij.refactoring.rename.api.RenameUsage;
import com.intellij.refactoring.rename.api.RenameUsageFileUpdaters;
import com.intellij.refactoring.rename.api.RenameValidationResult;
import com.intellij.refactoring.rename.api.RenameValidator;
import com.intellij.refactoring.rename.api.ReplaceTextTargetContext;
import com.intellij.refactoring.rename.impl.OptionsKt;
import com.intellij.refactoring.rename.impl.PsiRenameUsageRangeUpdater;
import com.intellij.refactoring.rename.impl.RenameKt;
import com.intellij.refactoring.rename.impl.RenameOptions;
import com.intellij.refactoring.rename.impl.SearchKt;
import com.intellij.refactoring.rename.impl.TextOptions;
import com.intellij.refactoring.rename.impl.TextRenameUsage;
import com.intellij.refactoring.rename.inplace.HighlightingKt;
import com.intellij.refactoring.rename.inplace.ImaginaryInplaceRefactoring;
import com.intellij.refactoring.rename.inplace.InplaceRefactoring;
import com.intellij.refactoring.rename.inplace.InplaceRenameContinuation;
import com.intellij.refactoring.rename.inplace.InplaceRenameKt;
import com.intellij.refactoring.rename.inplace.InplaceRenameTextUsageExpression;
import com.intellij.refactoring.rename.inplace.InplaceRenameUsageExpression;
import com.intellij.refactoring.rename.inplace.InplaceTemplateHighlighting;
import com.intellij.refactoring.rename.inplace.MyLookupExpression;
import com.intellij.refactoring.rename.inplace.PreventInvalidTemplateFinishAction;
import com.intellij.refactoring.rename.inplace.SegmentData;
import com.intellij.refactoring.rename.inplace.TemplateData;
import com.intellij.refactoring.rename.inplace.TemplateInlayUtil;
import com.intellij.refactoring.rename.inplace.UtilKt;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenamer;
import com.intellij.ui.LightweightHint;
import com.intellij.util.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u00aa\u0001\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u001a&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH\u0002\u001a&\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH\u0002\u001a\u0015\u0010\u0010\u001a\u00070\u0001\u00a2\u0006\u0002\b\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a \u0010\u0014\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u001a\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u001a>\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\"0$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&H\u0002\u001a,\u0010(\u001a\u00020\u00052\u0006\u0010)\u001a\u00020*2\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020-0,H\u0002\u001a4\u0010.\u001a\u00020*2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010/\u001a\u00020\u00162\u0006\u00100\u001a\u00020\u001c2\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00050,H\u0002\u001a \u00102\u001a\u00020\u00052\u000e\u00103\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u0018042\u0006\u00105\u001a\u00020'H\u0002\u001a\u0018\u00106\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u00107\u001a\u000208H\u0002\u001a\u0018\u00109\u001a\u00020:2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010;\u001a\u00020<H\u0002\u001a\n\u0010=\u001a\u00020\u0001*\u00020*\u001a\f\u0010>\u001a\u00020?*\u00020*H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"commentStringUsageVariablePrefix", "", "plainTextUsageVariablePrefix", "usageVariablePrefix", "assignTemplateExpressionsToVariables", "", "template", "Lcom/intellij/codeInsight/template/Template;", "originSegment", "Lcom/intellij/refactoring/rename/inplace/SegmentData;", "segments", "", "buildTemplate", "project", "Lcom/intellij/openapi/project/Project;", "hostDocumentContent", "createWarningConfirmationMessage", "Lcom/intellij/openapi/util/NlsSafe;", "showWarningConfirmation", "", "inplaceRename", "editor", "Lcom/intellij/openapi/editor/Editor;", "target", "Lcom/intellij/refactoring/rename/api/RenameTarget;", "moveCaretForTemplate", "Ljava/lang/Runnable;", "prepareTemplate", "Lcom/intellij/refactoring/rename/inplace/TemplateData;", "hostDocument", "Lcom/intellij/openapi/editor/Document;", "hostFile", "Lcom/intellij/psi/PsiFile;", "originUsage", "Lcom/intellij/refactoring/rename/api/PsiRenameUsage;", "usages", "", "textOptionsRef", "Lkotlin/Function0;", "Lcom/intellij/refactoring/rename/impl/TextOptions;", "registerTemplateValidation", "templateState", "Lcom/intellij/codeInsight/template/impl/TemplateState;", "nameValidator", "Lkotlin/Function1;", "Lcom/intellij/refactoring/rename/api/RenameValidationResult;", "runLiveTemplate", "hostEditor", "data", "newNameConsumer", "setTextOptions", "targetPointer", "Lcom/intellij/model/Pointer;", "newOptions", "showEditorHint", "label", "Ljavax/swing/JComponent;", "storeInplaceContinuation", "Lcom/intellij/openapi/Disposable;", "continuation", "Lcom/intellij/refactoring/InplaceRefactoringContinuation;", "getNewName", "getOriginSegmentEndOffset", "", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\ninplaceRename.kt\nKotlin\n*S Kotlin\n*F\n+ 1 inplaceRename.kt\ncom/intellij/refactoring/rename/inplace/InplaceRenameKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,473:1\n800#2,11:474\n1549#2:485\n1620#2,3:486\n11335#3:489\n11670#3,3:490\n*S KotlinDebug\n*F\n+ 1 inplaceRename.kt\ncom/intellij/refactoring/rename/inplace/InplaceRenameKt\n*L\n97#1:474,11\n260#1:485\n260#1:486,3\n452#1:489\n452#1:490,3\n*E\n"})
public final class InplaceRenameKt {
    @NotNull
    private static final String usageVariablePrefix = "inplace_usage_";
    @NotNull
    public static final String commentStringUsageVariablePrefix = "comment_string_usage_";
    @NotNull
    public static final String plainTextUsageVariablePrefix = "plain_text_usage_";

    /*
     * WARNING - void declaration
     */
    public static final boolean inplaceRename(@NotNull Project project2, @NotNull Editor editor2, @NotNull RenameTarget target2) {
        Object v7;
        Object[] usage2;
        List psiUsages;
        PsiFile hostFile;
        Document hostDocument;
        Editor hostEditor;
        KFunction validateName2;
        Pointer<? extends RenameTarget> targetPointer;
        block15: {
            void $this$filterIsInstanceTo$iv$iv;
            PsiFile psiFile;
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
            targetPointer = target2.createPointer();
            validateName2 = (KFunction)new Function1<String, RenameValidationResult>((Object)target2.validator()){

                @NotNull
                public final RenameValidationResult invoke(@NotNull String p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((RenameValidator)this.receiver).validate(p0);
                }
            };
            Document document = editor2.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
            Document document2 = document;
            PsiFile psiFile2 = PsiDocumentManager.getInstance(project2).getPsiFile(document2);
            if (psiFile2 == null) {
                return false;
            }
            PsiFile file2 = psiFile2;
            EditorWindow editorWindow = editor2 instanceof EditorWindow ? (EditorWindow)editor2 : null;
            Object object = editorWindow != null ? editorWindow.getDelegate() : null;
            if (object == null) {
                object = editor2;
            }
            hostEditor = object;
            DocumentWindow documentWindow = document2 instanceof DocumentWindow ? (DocumentWindow)document2 : null;
            Document document3 = documentWindow != null ? documentWindow.getDelegate() : null;
            if (document3 == null) {
                document3 = hostDocument = document2;
            }
            if ((psiFile = PsiDocumentManager.getInstance(project2).getPsiFile(hostDocument)) == null) {
                return false;
            }
            hostFile = psiFile;
            Query<? extends RenameUsage> usageQuery = SearchKt.buildUsageQuery(project2, target2, new RenameOptions(new TextOptions(true, true), new LocalSearchScope(hostFile)));
            Collection<? extends RenameUsage> collection = usageQuery.findAll();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"usageQuery.findAll()");
            Collection<? extends RenameUsage> usages = collection;
            Iterable $this$filterIsInstance$iv = usages;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo22 = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof PsiRenameUsage)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            psiUsages = (List)destination$iv$iv;
            int segmentsLimit = Registry.intValue("inplace.rename.segments.limit", -1);
            if (segmentsLimit != -1 && psiUsages.size() > segmentsLimit) {
                return false;
            }
            int offset2 = editor2.getCaretModel().getOffset();
            Iterable $i$f$filterIsInstanceTo22 = psiUsages;
            for (Object element$iv$iv : $i$f$filterIsInstanceTo22) {
                usage2 = (Object[])element$iv$iv;
                boolean bl = false;
                boolean bl2 = Intrinsics.areEqual((Object)usage2.getFile(), (Object)file2) && usage2.getRange().containsOffset(offset2);
                if (!bl2) continue;
                v7 = element$iv$iv;
                break block15;
            }
            v7 = null;
        }
        PsiRenameUsage originUsage = v7;
        if (originUsage == null) {
            return false;
        }
        if (!(originUsage instanceof ModifiableRenameUsage)) {
            return false;
        }
        if (((ModifiableRenameUsage)((Object)originUsage)).getFileUpdater() != RenameUsageFileUpdaters.getIdFileRangeUpdater()) {
            TextRange textRange = UtilKt.usageRangeInHost(hostFile, originUsage);
            if (textRange == null) {
                return false;
            }
            TextRange originUsageRange = textRange;
            String string2 = hostDocument.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"hostDocument.text");
            String hostDocumentContent = string2;
            String string3 = originUsageRange.substring(hostDocumentContent);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"originUsageRange.substring(hostDocumentContent)");
            String originUsageText = string3;
            if (!originUsage.getDeclaration() || !Intrinsics.areEqual((Object)originUsageText, (Object)target2.getTargetName())) {
                return false;
            }
        }
        Ref.ObjectRef textOptions = new Ref.ObjectRef();
        textOptions.element = OptionsKt.getTextOptions(target2);
        TemplateData templateData = InplaceRenameKt.prepareTemplate(hostDocument, hostFile, originUsage, psiUsages, (Function0<TextOptions>)((Function0)new Function0<TextOptions>((Ref.ObjectRef<TextOptions>)textOptions){
            final /* synthetic */ Ref.ObjectRef<TextOptions> $textOptions;
            {
                this.$textOptions = $textOptions;
                super(0);
            }

            @NotNull
            public final TextOptions invoke() {
                return (TextOptions)this.$textOptions.element;
            }
        }));
        if (templateData == null) {
            return false;
        }
        TemplateData data2 = templateData;
        usage2 = new Object[]{target2.presentation().getPresentableText()};
        String string4 = RefactoringBundle.message((String)"rename.command.name.0.in.place.template", (Object[])usage2);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(\"rename.command.\u2026tation().presentableText)");
        String commandName2 = string4;
        try {
            Object[] objectArray = InplaceRefactoring.startMarkAction(project2, hostEditor, commandName2);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"{\n    InplaceRefactoring\u2026tEditor, commandName)\n  }");
            usage2 = objectArray;
        }
        catch (StartMarkAction.AlreadyStartedException e) {
            InplaceRefactoring.unableToStartWarning(project2, hostEditor);
            return true;
        }
        Object[] startMarkAction = usage2;
        Runnable finishMarkAction = () -> InplaceRenameKt.inplaceRename$lambda$1(project2, hostEditor, (StartMarkAction)startMarkAction);
        WriteCommandAction.writeCommandAction(project2).withName(commandName2).run(() -> InplaceRenameKt.inplaceRename$lambda$2(project2, hostEditor, data2, textOptions, editor2, validateName2, targetPointer, finishMarkAction));
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static final TemplateData prepareTemplate(Document hostDocument, PsiFile hostFile, PsiRenameUsage originUsage, Collection<? extends PsiRenameUsage> usages, Function0<TextOptions> textOptionsRef) {
        void $this$mapTo$iv$iv;
        Iterable usageRangeInHost;
        TextRange textRange = UtilKt.usageRangeInHost(hostFile, originUsage);
        if (textRange == null) {
            return null;
        }
        TextRange originUsageRange = textRange;
        String string2 = hostDocument.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"hostDocument.text");
        String hostDocumentContent = string2;
        String string3 = originUsageRange.substring(hostDocumentContent);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"originUsageRange.substring(hostDocumentContent)");
        String originUsageText = string3;
        SegmentData originSegment = new SegmentData(originUsageRange, "PrimaryVariable", new MyLookupExpression(originUsageText, null, null, null, false, null));
        Function0 isCommentStringActive2 = (Function0)new Function0<Boolean>(textOptionsRef){
            final /* synthetic */ Function0<TextOptions> $textOptionsRef;
            {
                this.$textOptionsRef = $textOptionsRef;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return Intrinsics.areEqual((Object)((TextOptions)this.$textOptionsRef.invoke()).getCommentStringOccurrences(), (Object)true);
            }
        };
        Function0 isPlainTextActive2 = (Function0)new Function0<Boolean>(textOptionsRef){
            final /* synthetic */ Function0<TextOptions> $textOptionsRef;
            {
                this.$textOptionsRef = $textOptionsRef;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return Intrinsics.areEqual((Object)((TextOptions)this.$textOptionsRef.invoke()).getTextOccurrences(), (Object)true);
            }
        };
        ArrayList segments = new ArrayList(usages.size());
        ((Collection)segments).add(originSegment);
        int variableCounter = 0;
        for (PsiRenameUsage psiRenameUsage : usages) {
            SegmentData segmentData;
            block10: {
                Function1 usageTextByName2;
                block9: {
                    ModifiableRenameUsage.FileUpdater fileUpdater2;
                    if (psiRenameUsage == originUsage || !(psiRenameUsage instanceof ModifiableRenameUsage) || !((fileUpdater2 = ((ModifiableRenameUsage)((Object)psiRenameUsage)).getFileUpdater()) instanceof PsiRenameUsageRangeUpdater) || UtilKt.usageRangeInHost(hostFile, psiRenameUsage) == null) continue;
                    if (fileUpdater2 == RenameUsageFileUpdaters.getIdFileRangeUpdater()) {
                        v3 = ((PsiRenameUsageRangeUpdater)fileUpdater2).getUsageTextByName();
                    } else {
                        Pointer<? extends ModifiableRenameUsage> usagePtr = ((ModifiableRenameUsage)((Object)psiRenameUsage)).createPointer();
                        v3 = usageTextByName2 = (Function1)new Function1<String, String>(usagePtr){
                            final /* synthetic */ Pointer<? extends ModifiableRenameUsage> $usagePtr;
                            {
                                this.$usagePtr = $usagePtr;
                                super(1);
                            }

                            @NotNull
                            public final String invoke(@NotNull String newName2) {
                                Object object;
                                block5: {
                                    block4: {
                                        Intrinsics.checkNotNullParameter((Object)newName2, (String)"newName");
                                        object = this.$usagePtr.dereference();
                                        if (object == null || (object = object.getFileUpdater()) == null) break block4;
                                        Function1<String, String> $this$asSafely$iv = object;
                                        boolean $i$f$asSafely = false;
                                        Function1<String, String> function1 = $this$asSafely$iv;
                                        if (!(function1 instanceof PsiRenameUsageRangeUpdater)) {
                                            function1 = null;
                                        }
                                        if ((object = (Object)function1) != null && (object = object.getUsageTextByName()) != null && (object = (String)object.invoke((Object)newName2)) != null) break block5;
                                    }
                                    object = newName2;
                                }
                                return object;
                            }
                        };
                    }
                    if (!(psiRenameUsage instanceof TextRenameUsage)) break block9;
                    Intrinsics.checkNotNullExpressionValue((Object)((TextRange)((Object)usageRangeInHost)).substring(hostDocumentContent), (String)"usageRangeInHost.substring(hostDocumentContent)");
                    switch (WhenMappings.$EnumSwitchMapping$0[((TextRenameUsage)psiRenameUsage).getContext().ordinal()]) {
                        case 1: {
                            String originalText;
                            segmentData = new SegmentData((TextRange)((Object)usageRangeInHost), commentStringUsageVariablePrefix + variableCounter, new InplaceRenameTextUsageExpression((Function1<? super String, String>)usageTextByName2, originalText, (Function0<Boolean>)isCommentStringActive2));
                            break block10;
                        }
                        case 2: {
                            String originalText;
                            segmentData = new SegmentData((TextRange)((Object)usageRangeInHost), plainTextUsageVariablePrefix + variableCounter, new InplaceRenameTextUsageExpression((Function1<? super String, String>)usageTextByName2, originalText, (Function0<Boolean>)isPlainTextActive2));
                            break block10;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
                segmentData = new SegmentData((TextRange)((Object)usageRangeInHost), usageVariablePrefix + variableCounter, new InplaceRenameUsageExpression((Function1<? super String, String>)usageTextByName2));
            }
            SegmentData segment = segmentData;
            ((Collection)segments).add(segment);
            ++variableCounter;
        }
        List list2 = segments;
        Comparator<Object> comparator = Comparator.comparing(arg_0 -> InplaceRenameKt.prepareTemplate$lambda$3((Function1)prepareTemplate.1.INSTANCE, arg_0), Segment.BY_START_OFFSET_THEN_END_OFFSET);
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"comparing(SegmentData::r\u2026T_OFFSET_THEN_END_OFFSET)");
        CollectionsKt.sortWith((List)list2, comparator);
        Project project2 = hostFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"hostFile.project");
        Template template = InplaceRenameKt.buildTemplate(project2, hostDocumentContent, segments);
        InplaceRenameKt.assignTemplateExpressionsToVariables(template, originSegment, segments);
        Iterable iterable = segments;
        Template template2 = template;
        boolean $i$f$map = false;
        usageRangeInHost = iterable;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            SegmentData segmentData = (SegmentData)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getRange());
        }
        List list3 = (List)destination$iv$iv;
        Template template3 = template2;
        return new TemplateData(template3, list3);
    }

    private static final Template buildTemplate(Project project2, String hostDocumentContent, List<SegmentData> segments) {
        Template template = TemplateManager.getInstance(project2).createTemplate("", "");
        int lastOffset = 0;
        for (SegmentData segmentData : segments) {
            TextRange range = segmentData.component1();
            String variableName = segmentData.component2();
            String string2 = hostDocumentContent.substring(lastOffset, range.getStartOffset());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            template.addTextSegment(string2);
            template.addVariableSegment(variableName);
            lastOffset = range.getEndOffset();
        }
        String string3 = hostDocumentContent.substring(lastOffset);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
        template.addTextSegment(string3);
        Intrinsics.checkNotNullExpressionValue((Object)template, (String)"template");
        return template;
    }

    private static final void assignTemplateExpressionsToVariables(Template template, SegmentData originSegment, List<SegmentData> segments) {
        template.addVariable(new Variable(originSegment.getVariableName(), originSegment.getExpression(), originSegment.getExpression(), true, false));
        for (SegmentData segmentData : segments) {
            String variableName = segmentData.component2();
            Expression expression = segmentData.component3();
            if (Intrinsics.areEqual((Object)variableName, (Object)originSegment.getVariableName())) continue;
            template.addVariable(new Variable(variableName, expression, null, false, false));
        }
    }

    private static final TemplateState runLiveTemplate(Project project2, Editor hostEditor, TemplateData data2, Function1<? super String, Unit> newNameConsumer) {
        Template template = data2.getTemplate();
        template.setInline(true);
        template.setToIndent(false);
        template.setToShortenLongNames(false);
        template.setToReformat(false);
        Runnable restoreCaretAndSelection = InplaceRenameKt.moveCaretForTemplate(hostEditor);
        Document document = hostEditor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"hostEditor.document");
        Runnable restoreDocument = UtilKt.deleteInplaceTemplateSegments(project2, document, data2.getTemplateSegmentRanges());
        TemplateState templateState2 = TemplateManager.getInstance(project2).runTemplate(hostEditor, template);
        Intrinsics.checkNotNullExpressionValue((Object)templateState2, (String)"getInstance(project).run\u2026ate(hostEditor, template)");
        TemplateState state = templateState2;
        DaemonCodeAnalyzer.getInstance(project2).disableUpdateByTimer(state);
        UtilKt.addTemplateResultListener(state, (Function1<? super TemplateResultListener.TemplateResult, Unit>)((Function1)new Function1<TemplateResultListener.TemplateResult, Unit>(restoreDocument, state, newNameConsumer){
            final /* synthetic */ Runnable $restoreDocument;
            final /* synthetic */ TemplateState $state;
            final /* synthetic */ Function1<String, Unit> $newNameConsumer;
            {
                this.$restoreDocument = $restoreDocument;
                this.$state = $state;
                this.$newNameConsumer = $newNameConsumer;
                super(1);
            }

            public final void invoke(@NotNull TemplateResultListener.TemplateResult result2) {
                Intrinsics.checkNotNullParameter((Object)((Object)result2), (String)"result");
                switch (runLiveTemplate.WhenMappings.$EnumSwitchMapping$0[result2.ordinal()]) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        this.$restoreDocument.run();
                        break;
                    }
                    case 3: {
                        String newName2 = InplaceRenameKt.getNewName(this.$state);
                        this.$restoreDocument.run();
                        this.$newNameConsumer.invoke((Object)newName2);
                    }
                }
            }
        }));
        restoreCaretAndSelection.run();
        return state;
    }

    private static final Runnable moveCaretForTemplate(Editor editor2) {
        CaretModel caretModel = editor2.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        CaretModel caretModel2 = caretModel;
        int offset2 = caretModel2.getOffset();
        SelectionModel selectionModel = editor2.getSelectionModel();
        boolean bl = false;
        TextRange selectedRange = selectionModel.hasSelection() ? new TextRange(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd()) : null;
        caretModel2.moveToOffset(0);
        return () -> InplaceRenameKt.moveCaretForTemplate$lambda$6(editor2, offset2, selectedRange);
    }

    private static final void setTextOptions(Pointer<? extends RenameTarget> targetPointer, TextOptions newOptions) {
        block0: {
            RenameTarget renameTarget = targetPointer.dereference();
            if (renameTarget == null) break block0;
            RenameTarget restoredTarget = renameTarget;
            boolean bl = false;
            OptionsKt.setTextOptions(restoredTarget, newOptions);
        }
    }

    @NotNull
    public static final String getNewName(@NotNull TemplateState $this$getNewName) {
        Intrinsics.checkNotNullParameter((Object)$this$getNewName, (String)"<this>");
        TextResult textResult = $this$getNewName.getVariableValue("PrimaryVariable");
        if (textResult == null) {
            String string2 = "Required value was null.";
            throw new IllegalArgumentException(string2.toString());
        }
        String string3 = textResult.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"requireNotNull(getVariab\u2026MARY_VARIABLE_NAME)).text");
        return string3;
    }

    private static final int getOriginSegmentEndOffset(TemplateState $this$getOriginSegmentEndOffset) {
        TextRange textRange = $this$getOriginSegmentEndOffset.getVariableRange("PrimaryVariable");
        if (textRange == null) {
            String string2 = "Required value was null.";
            throw new IllegalArgumentException(string2.toString());
        }
        return textRange.getEndOffset();
    }

    private static final Disposable storeInplaceContinuation(Editor editor2, InplaceRefactoringContinuation continuation) {
        editor2.putUserData(InplaceRefactoringContinuation.INPLACE_REFACTORING_CONTINUATION, (Object)continuation);
        editor2.putUserData(InplaceRefactoring.INPLACE_RENAMER, (Object)ImaginaryInplaceRefactoring.INSTANCE);
        return () -> InplaceRenameKt.storeInplaceContinuation$lambda$8(editor2);
    }

    private static final void registerTemplateValidation(TemplateState templateState2, Editor editor2, Function1<? super String, ? extends RenameValidationResult> nameValidator) {
        Ref.BooleanRef showWarningConfirmation = new Ref.BooleanRef();
        PreventInvalidTemplateFinishAction preventAction2 = new PreventInvalidTemplateFinishAction((Function0<Boolean>)((Function0)new Function0<Boolean>(nameValidator, templateState2, showWarningConfirmation){
            final /* synthetic */ Function1<String, RenameValidationResult> $nameValidator;
            final /* synthetic */ TemplateState $templateState;
            final /* synthetic */ Ref.BooleanRef $showWarningConfirmation;
            {
                this.$nameValidator = $nameValidator;
                this.$templateState = $templateState;
                this.$showWarningConfirmation = $showWarningConfirmation;
                super(0);
            }

            @Nullable
            public final Boolean invoke() {
                Boolean bl;
                block5: {
                    block6: {
                        RenameValidationResult result2;
                        block4: {
                            result2 = (RenameValidationResult)this.$nameValidator.invoke((Object)InplaceRenameKt.getNewName(this.$templateState));
                            if (!(result2 instanceof RenameValidationResult.Companion.OK)) break block4;
                            bl = null;
                            break block5;
                        }
                        if (!(result2 instanceof RenameValidationResult.Companion.RenameValidationResultData)) break block6;
                        switch (registerTemplateValidation.preventAction.WhenMappings.$EnumSwitchMapping$0[((RenameValidationResult.Companion.RenameValidationResultData)result2).getLevel().ordinal()]) {
                            case 1: {
                                bl = !this.$showWarningConfirmation.element ? Boolean.valueOf(true) : null;
                                break block5;
                            }
                            case 2: {
                                bl = false;
                                break block5;
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                    }
                    throw new NoWhenBranchMatchedException();
                }
                return bl;
            }
        }), (Function1<? super Boolean, Unit>)((Function1)new Function1<Boolean, Unit>(showWarningConfirmation, templateState2, nameValidator, editor2){
            final /* synthetic */ Ref.BooleanRef $showWarningConfirmation;
            final /* synthetic */ TemplateState $templateState;
            final /* synthetic */ Function1<String, RenameValidationResult> $nameValidator;
            final /* synthetic */ Editor $editor;
            {
                this.$showWarningConfirmation = $showWarningConfirmation;
                this.$templateState = $templateState;
                this.$nameValidator = $nameValidator;
                this.$editor = $editor;
                super(1);
            }

            public final void invoke(boolean it) {
                this.$showWarningConfirmation.element = it;
                InplaceRenameKt.access$registerTemplateValidation$validateAndShowHint(this.$templateState, this.$nameValidator, this.$editor, this.$showWarningConfirmation);
            }
        }));
        preventAction2.registerCustomShortcutSet(ActionUtil.getShortcutSet((String)"NextTemplateVariable"), editor2.getComponent(), templateState2);
        editor2.getDocument().addDocumentListener(new DocumentListener(showWarningConfirmation, templateState2, nameValidator, editor2){
            final /* synthetic */ Ref.BooleanRef $showWarningConfirmation;
            final /* synthetic */ TemplateState $templateState;
            final /* synthetic */ Function1<String, RenameValidationResult> $nameValidator;
            final /* synthetic */ Editor $editor;
            {
                this.$showWarningConfirmation = $showWarningConfirmation;
                this.$templateState = $templateState;
                this.$nameValidator = $nameValidator;
                this.$editor = $editor;
            }

            public void documentChanged(@NotNull DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.$showWarningConfirmation.element = false;
                InplaceRenameKt.access$registerTemplateValidation$validateAndShowHint(this.$templateState, this.$nameValidator, this.$editor, this.$showWarningConfirmation);
            }
        }, templateState2);
        editor2.getCaretModel().addCaretListener(new CaretListener(templateState2, nameValidator, editor2, showWarningConfirmation){
            final /* synthetic */ TemplateState $templateState;
            final /* synthetic */ Function1<String, RenameValidationResult> $nameValidator;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ Ref.BooleanRef $showWarningConfirmation;
            {
                this.$templateState = $templateState;
                this.$nameValidator = $nameValidator;
                this.$editor = $editor;
                this.$showWarningConfirmation = $showWarningConfirmation;
            }

            public void caretPositionChanged(@NotNull CaretEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                InplaceRenameKt.access$registerTemplateValidation$validateAndShowHint(this.$templateState, this.$nameValidator, this.$editor, this.$showWarningConfirmation);
            }
        }, (Disposable)templateState2);
        InplaceRenameKt.registerTemplateValidation$validateAndShowHint(templateState2, nameValidator, editor2, showWarningConfirmation);
    }

    private static final void showEditorHint(Editor editor2, JComponent label2) {
        LightweightHint hint = new LightweightHint(label2);
        int flags = 1033;
        HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor2, (short)1, flags, 0, false);
    }

    /*
     * WARNING - void declaration
     */
    private static final String createWarningConfirmationMessage(boolean showWarningConfirmation) {
        String string2;
        if (showWarningConfirmation) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            HtmlBuilder htmlBuilder = new HtmlBuilder();
            HtmlChunk.Element element = HtmlChunk.p();
            Object[] objectArray = new Object[1];
            Shortcut[] shortcutArray = ActionUtil.getShortcutSet((String)"NextTemplateVariable").getShortcuts();
            Intrinsics.checkNotNullExpressionValue((Object)shortcutArray, (String)"getShortcutSet(\"NextTemplateVariable\").shortcuts");
            Object[] objectArray2 = shortcutArray;
            int n = 0;
            Object[] objectArray3 = objectArray;
            String string3 = "inplace.refactoring.press.again.to.complete";
            HtmlChunk.Element element2 = element;
            HtmlBuilder htmlBuilder2 = htmlBuilder;
            boolean $i$f$map = false;
            void var5_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Shortcut shortcut = (Shortcut)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(KeymapUtil.getShortcutText((Shortcut)it));
            }
            collection = (List)destination$iv$iv;
            objectArray3[n] = NlsMessages.formatOrList((Collection)collection);
            String string4 = htmlBuilder2.append(element2.addText(RefactoringBundle.message((String)string3, (Object[])objectArray))).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"HtmlBuilder().append(Htm\u2026     ))\n    )).toString()");
            string2 = string4;
        } else {
            string2 = "";
        }
        return string2;
    }

    private static final void inplaceRename$performRename(KFunction<? extends RenameValidationResult> validateName2, Pointer<? extends RenameTarget> targetPointer, Project $project, String newName2) {
        RenameValidationResult validation = (RenameValidationResult)((Function1)validateName2).invoke((Object)newName2);
        RenameValidationResult.Companion.RenameValidationResultData renameValidationResultData = validation instanceof RenameValidationResult.Companion.RenameValidationResultData ? (RenameValidationResult.Companion.RenameValidationResultData)validation : null;
        if ((renameValidationResultData != null ? renameValidationResultData.getLevel() : null) == RenameValidationResult.Companion.RenameValidationResultProblemLevel.ERROR) {
            return;
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        RenameTarget renameTarget = targetPointer.dereference();
        if (renameTarget == null) {
            return;
        }
        RenameTarget restoredTarget = renameTarget;
        RenameOptions options2 = OptionsKt.renameOptions($project, restoredTarget);
        RenameKt.rename$default($project, targetPointer, newName2, options2, false, 16, null);
    }

    private static final void inplaceRename$lambda$1(Project $project, Editor $hostEditor, StartMarkAction $startMarkAction) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$hostEditor, (String)"$hostEditor");
        Intrinsics.checkNotNullParameter((Object)$startMarkAction, (String)"$startMarkAction");
        FinishMarkAction.finish((Project)$project, (Editor)$hostEditor, (StartMarkAction)$startMarkAction);
    }

    private static final void inplaceRename$lambda$2(Project $project, Editor $hostEditor, TemplateData $data, Ref.ObjectRef $textOptions, Editor $editor, KFunction $validateName, Pointer $targetPointer, Runnable $finishMarkAction) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$hostEditor, (String)"$hostEditor");
        Intrinsics.checkNotNullParameter((Object)$data, (String)"$data");
        Intrinsics.checkNotNullParameter((Object)$textOptions, (String)"$textOptions");
        Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
        Intrinsics.checkNotNullParameter((Object)$validateName, (String)"$validateName");
        Intrinsics.checkNotNullParameter((Object)$targetPointer, (String)"$targetPointer");
        Intrinsics.checkNotNullParameter((Object)$finishMarkAction, (String)"$finishMarkAction");
        try {
            TemplateState templateState2 = InplaceRenameKt.runLiveTemplate($project, $hostEditor, $data, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>((KFunction<? extends RenameValidationResult>)$validateName, (Pointer<? extends RenameTarget>)$targetPointer, $project){
                final /* synthetic */ KFunction<RenameValidationResult> $validateName;
                final /* synthetic */ Pointer<? extends RenameTarget> $targetPointer;
                final /* synthetic */ Project $project;
                {
                    this.$validateName = $validateName;
                    this.$targetPointer = $targetPointer;
                    this.$project = $project;
                    super(1, Intrinsics.Kotlin.class, "performRename", "inplaceRename$performRename(Lkotlin/reflect/KFunction;Lcom/intellij/model/Pointer;Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", 0);
                }

                public final void invoke(@NotNull String p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    InplaceRenameKt.access$inplaceRename$performRename(this.$validateName, this.$targetPointer, this.$project, p0);
                }
            }));
            InplaceTemplateHighlighting templateHighlighting = HighlightingKt.highlightTemplateVariables($project, $hostEditor, $data.getTemplate(), templateState2, (TextOptions)$textOptions.element);
            templateHighlighting.updateHighlighters$intellij_platform_lang_impl((TextOptions)$textOptions.element);
            TemplateInlayUtil.INSTANCE.createRenameSettingsInlay$intellij_platform_lang_impl(templateState2, InplaceRenameKt.getOriginSegmentEndOffset(templateState2), (TextOptions)$textOptions.element, (Function1<? super TextOptions, Unit>)((Function1)new Function1<TextOptions, Unit>((Ref.ObjectRef<TextOptions>)$textOptions, templateState2, templateHighlighting, (Pointer<? extends RenameTarget>)$targetPointer){
                final /* synthetic */ Ref.ObjectRef<TextOptions> $textOptions;
                final /* synthetic */ TemplateState $templateState;
                final /* synthetic */ InplaceTemplateHighlighting $templateHighlighting;
                final /* synthetic */ Pointer<? extends RenameTarget> $targetPointer;
                {
                    this.$textOptions = $textOptions;
                    this.$templateState = $templateState;
                    this.$templateHighlighting = $templateHighlighting;
                    this.$targetPointer = $targetPointer;
                    super(1);
                }

                public final void invoke(@NotNull TextOptions newOptions) {
                    Intrinsics.checkNotNullParameter((Object)newOptions, (String)"newOptions");
                    this.$textOptions.element = newOptions;
                    this.$templateState.update();
                    this.$templateHighlighting.updateHighlighters$intellij_platform_lang_impl((TextOptions)this.$textOptions.element);
                    InplaceRenameKt.access$setTextOptions(this.$targetPointer, (TextOptions)this.$textOptions.element);
                }
            }));
            InplaceRenameKt.registerTemplateValidation(templateState2, $editor, (Function1<? super String, ? extends RenameValidationResult>)((Function1)$validateName));
            Disposer.register(templateState2, templateHighlighting);
            Disposer.register(templateState2, InplaceRenameKt.storeInplaceContinuation($hostEditor, new InplaceRenameContinuation($targetPointer)));
            Disposer.register(templateState2, $finishMarkAction::run);
        }
        catch (Throwable e) {
            $finishMarkAction.run();
            throw e;
        }
    }

    private static final TextRange prepareTemplate$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (TextRange)$tmp0.invoke(p0);
    }

    private static final void moveCaretForTemplate$lambda$6$lambda$5(TextRange $selectedRange, Editor $editor) {
        Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
        if ($selectedRange != null) {
            VariableInplaceRenamer.restoreSelection($editor, $selectedRange);
        }
    }

    private static final void moveCaretForTemplate$lambda$6(Editor $editor, int $offset, TextRange $selectedRange) {
        Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
        InplaceRefactoring.restoreOldCaretPositionAndSelection($editor, $offset, () -> InplaceRenameKt.moveCaretForTemplate$lambda$6$lambda$5($selectedRange, $editor));
    }

    private static final void storeInplaceContinuation$lambda$8(Editor $editor) {
        Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
        $editor.putUserData(InplaceRefactoringContinuation.INPLACE_REFACTORING_CONTINUATION, null);
        $editor.putUserData(InplaceRefactoring.INPLACE_RENAMER, null);
    }

    private static final void registerTemplateValidation$validateAndShowHint$lambda$9(Editor $editor, RenameValidationResult $validationResult, String $newName, Ref.BooleanRef $showWarningConfirmation) {
        Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
        Intrinsics.checkNotNullParameter((Object)$validationResult, (String)"$validationResult");
        Intrinsics.checkNotNullParameter((Object)$newName, (String)"$newName");
        Intrinsics.checkNotNullParameter((Object)$showWarningConfirmation, (String)"$showWarningConfirmation");
        JComponent jComponent = ((RenameValidationResult.Companion.RenameValidationResultData)$validationResult).getLevel() == RenameValidationResult.Companion.RenameValidationResultProblemLevel.WARNING ? HintUtil.createWarningLabel((String)(((RenameValidationResult.Companion.RenameValidationResultData)$validationResult).message($newName) + InplaceRenameKt.createWarningConfirmationMessage($showWarningConfirmation.element))) : HintUtil.createErrorLabel((String)((RenameValidationResult.Companion.RenameValidationResultData)$validationResult).message($newName));
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"if (validationResult.lev\u2026nResult.message(newName))");
        InplaceRenameKt.showEditorHint($editor, jComponent);
    }

    private static final void registerTemplateValidation$validateAndShowHint(TemplateState $templateState, Function1<? super String, ? extends RenameValidationResult> $nameValidator, Editor $editor, Ref.BooleanRef showWarningConfirmation) {
        String newName2 = InplaceRenameKt.getNewName($templateState);
        if (((CharSequence)newName2).length() == 0) {
            return;
        }
        RenameValidationResult validationResult = (RenameValidationResult)$nameValidator.invoke((Object)newName2);
        if (validationResult instanceof RenameValidationResult.Companion.RenameValidationResultData) {
            ApplicationManager.getApplication().invokeLater(() -> InplaceRenameKt.registerTemplateValidation$validateAndShowHint$lambda$9($editor, validationResult, newName2, showWarningConfirmation));
        }
    }

    public static final /* synthetic */ void access$registerTemplateValidation$validateAndShowHint(TemplateState $templateState, Function1 $nameValidator, Editor $editor, Ref.BooleanRef showWarningConfirmation) {
        InplaceRenameKt.registerTemplateValidation$validateAndShowHint($templateState, (Function1<? super String, ? extends RenameValidationResult>)$nameValidator, $editor, showWarningConfirmation);
    }

    public static final /* synthetic */ void access$inplaceRename$performRename(KFunction validateName2, Pointer targetPointer, Project $project, String newName2) {
        InplaceRenameKt.inplaceRename$performRename((KFunction<? extends RenameValidationResult>)validateName2, targetPointer, $project, newName2);
    }

    public static final /* synthetic */ void access$setTextOptions(Pointer targetPointer, TextOptions newOptions) {
        InplaceRenameKt.setTextOptions(targetPointer, newOptions);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ReplaceTextTargetContext.values().length];
            try {
                nArray[ReplaceTextTargetContext.IN_COMMENTS_AND_STRINGS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReplaceTextTargetContext.IN_PLAIN_TEXT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

