/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.inplace;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.refactoring.rename.impl.TextOptions;
import com.intellij.refactoring.rename.inplace.HighlightingKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u0010\u001a\u00020\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u0015\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u0014J\u001e\u0010\u0012\u001a\u00020\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/refactoring/rename/inplace/InplaceTemplateHighlighting;", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/Editor;", "highlightManager", "Lcom/intellij/codeInsight/highlighting/HighlightManager;", "usageHighlighters", "", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "commentStringHighlighters", "textHighlighters", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/codeInsight/highlighting/HighlightManager;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "textOptions", "Lcom/intellij/refactoring/rename/impl/TextOptions;", "dispose", "", "disposeHighlighters", "highlighters", "updateHighlighters", "newOptions", "updateHighlighters$intellij_platform_lang_impl", "key", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "intellij.platform.lang.impl"})
public final class InplaceTemplateHighlighting
implements Disposable {
    @NotNull
    private final Editor editor;
    @NotNull
    private final HighlightManager highlightManager;
    @NotNull
    private final List<RangeHighlighter> usageHighlighters;
    @NotNull
    private final List<RangeHighlighter> commentStringHighlighters;
    @NotNull
    private final List<RangeHighlighter> textHighlighters;
    @NotNull
    private TextOptions textOptions;

    public InplaceTemplateHighlighting(@NotNull Editor editor2, @NotNull HighlightManager highlightManager, @NotNull List<? extends RangeHighlighter> usageHighlighters, @NotNull List<? extends RangeHighlighter> commentStringHighlighters, @NotNull List<? extends RangeHighlighter> textHighlighters) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)highlightManager, (String)"highlightManager");
        Intrinsics.checkNotNullParameter(usageHighlighters, (String)"usageHighlighters");
        Intrinsics.checkNotNullParameter(commentStringHighlighters, (String)"commentStringHighlighters");
        Intrinsics.checkNotNullParameter(textHighlighters, (String)"textHighlighters");
        this.editor = editor2;
        this.highlightManager = highlightManager;
        this.usageHighlighters = usageHighlighters;
        this.commentStringHighlighters = commentStringHighlighters;
        this.textHighlighters = textHighlighters;
        this.textOptions = new TextOptions(true, true);
    }

    public final void updateHighlighters$intellij_platform_lang_impl(@NotNull TextOptions newOptions) {
        TextAttributesKey newKey;
        Intrinsics.checkNotNullParameter((Object)newOptions, (String)"newOptions");
        if (Intrinsics.areEqual((Object)this.textOptions, (Object)newOptions)) {
            return;
        }
        if (!Intrinsics.areEqual((Object)this.textOptions.getCommentStringOccurrences(), (Object)newOptions.getCommentStringOccurrences())) {
            newKey = Intrinsics.areEqual((Object)newOptions.getCommentStringOccurrences(), (Object)true) ? EditorColors.SEARCH_RESULT_ATTRIBUTES : HighlightingKt.access$getNO_HIGHLIGHTING$p();
            Intrinsics.checkNotNullExpressionValue((Object)newKey, (String)"newKey");
            this.updateHighlighters(this.commentStringHighlighters, newKey);
        }
        if (!Intrinsics.areEqual((Object)this.textOptions.getTextOccurrences(), (Object)newOptions.getTextOccurrences())) {
            newKey = Intrinsics.areEqual((Object)newOptions.getTextOccurrences(), (Object)true) ? EditorColors.SEARCH_RESULT_ATTRIBUTES : HighlightingKt.access$getNO_HIGHLIGHTING$p();
            Intrinsics.checkNotNullExpressionValue((Object)newKey, (String)"newKey");
            this.updateHighlighters(this.textHighlighters, newKey);
        }
        this.textOptions = newOptions;
    }

    private final void updateHighlighters(List<? extends RangeHighlighter> highlighters, TextAttributesKey key) {
        for (RangeHighlighter rangeHighlighter : highlighters) {
            rangeHighlighter.setTextAttributesKey(key);
        }
    }

    @Override
    public void dispose() {
        this.disposeHighlighters(this.usageHighlighters);
        this.disposeHighlighters(this.commentStringHighlighters);
        this.disposeHighlighters(this.textHighlighters);
    }

    private final void disposeHighlighters(List<? extends RangeHighlighter> highlighters) {
        for (RangeHighlighter rangeHighlighter : highlighters) {
            this.highlightManager.removeSegmentHighlighter(this.editor, rangeHighlighter);
        }
    }
}

